/*
 * Decompiled with CFR 0.152.
 */
package madkit.action;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import madkit.action.ActionInfo;
import madkit.action.KernelAction;
import madkit.action.MDKAbstractAction;
import madkit.i18n.I18nUtilities;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.message.GUIMessage;
import madkit.message.KernelMessage;

public enum GUIManagerAction {
    LOAD_JAR_FILE(74),
    ICONIFY_ALL(85),
    DEICONIFY_ALL(73),
    KILL_AGENTS(65),
    SETUP_AGENT_GUI(515),
    LOG_LEVEL(515),
    WARNING_LOG_LEVEL(515),
    DISPOSE_AGENT_GUI(515);

    private ActionInfo actionInfo;
    private final int keyEvent;
    private static final ResourceBundle messages;

    private GUIManagerAction(int keyEvent) {
        this.keyEvent = keyEvent;
    }

    public Action getActionFor(final AbstractAgent agent, final Object ... commandOptions) {
        return new MDKAbstractAction(this.getActionInfo()){
            private static final long serialVersionUID = 2231685794614332333L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (agent.isAlive()) {
                    GUIMessage m = new GUIMessage(GUIManagerAction.this, commandOptions);
                    AgentAddress guiManager = agent.getAgentWithRole("local", "gui", "manager");
                    if (guiManager != null) {
                        agent.sendMessage(guiManager, m);
                    } else {
                        agent.receiveMessage(m);
                    }
                }
            }
        };
    }

    public ActionInfo getActionInfo() {
        if (this.actionInfo == null) {
            this.actionInfo = new ActionInfo(this, this.keyEvent, messages);
        }
        return this.actionInfo;
    }

    public static void addAllActionsTo(JComponent menuOrToolBar, final AbstractAgent agent) {
        try {
            Method add = menuOrToolBar.getClass().getMethod("add", Action.class);
            Method addSeparator = menuOrToolBar.getClass().getMethod("addSeparator", new Class[0]);
            for (final GUIManagerAction mkA : EnumSet.allOf(GUIManagerAction.class)) {
                if (mkA == SETUP_AGENT_GUI) {
                    return;
                }
                Action a = mkA.getActionFor(agent, new Object[0]);
                if (mkA == LOAD_JAR_FILE) {
                    a = new MDKAbstractAction(mkA.actionInfo){
                        private static final long serialVersionUID = -7758727130858069498L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (agent.isAlive()) {
                                agent.sendMessage("local", "system", "manager", new KernelMessage(KernelAction.LOAD_JAR_FILE, mkA.getJarUrl()));
                            }
                        }
                    };
                }
                add.invoke((Object)menuOrToolBar, a);
                if (mkA != LOAD_JAR_FILE) continue;
                addSeparator.invoke((Object)menuOrToolBar, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private URL getJarUrl() {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setFileFilter(new FileNameExtensionFilter("Jar file", "jar"));
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                return chooser.getSelectedFile().toURI().toURL();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    static {
        messages = I18nUtilities.getResourceBundle(GUIManagerAction.class.getSimpleName());
    }
}

