/*
 * Decompiled with CFR 0.152.
 */
package madkit.action;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class ActionInfo {
    public static final boolean javawsIsOn = System.getProperty("javawebstart.version") != null;
    private static final String imageDir = "images/";
    private final int keyEvent;
    private final ImageIcon bigIcon;
    private final ImageIcon smallIcon;
    private String name;
    private final String shortDescription;
    private final String longDescription;

    <E extends Enum<E>> ActionInfo(E enumAction, int keyEvent, ResourceBundle resource) {
        this.keyEvent = keyEvent;
        this.name = enumAction.name();
        URL imageUrl = enumAction.getClass().getResource(imageDir + this.name + ".png");
        if (imageUrl != null) {
            this.bigIcon = new ImageIcon(imageUrl);
            this.smallIcon = this.bigIcon.getIconWidth() > 16 ? new ImageIcon(this.bigIcon.getImage().getScaledInstance(16, 16, 4)) : this.bigIcon;
        } else {
            this.smallIcon = null;
            this.bigIcon = null;
        }
        String[] codes = null;
        try {
            codes = resource.getString(this.name).split(";");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (codes != null) {
            this.shortDescription = codes.length > 1 ? codes[1] : codes[0];
            this.longDescription = codes.length > 2 ? codes[2] : this.shortDescription;
            this.name = codes[0];
        } else {
            this.shortDescription = this.longDescription = enumAction.getClass().getSimpleName();
        }
    }

    public int getKeyEvent() {
        return this.keyEvent;
    }

    public ImageIcon getBigIcon() {
        return this.bigIcon;
    }

    public ImageIcon getSmallIcon() {
        return this.smallIcon;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public static <E extends Enum<E>> String enumToMethodName(E e) {
        String[] tab = e.name().split("_");
        String methodName = tab[0].toLowerCase();
        for (int i = 1; i < tab.length; ++i) {
            String s = tab[i];
            methodName = methodName + s.charAt(0) + s.substring(1).toLowerCase();
        }
        return methodName;
    }
}

