/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import madkit.kernel.AbstractAgent;
import madkit.kernel.KernelAddress;
import madkit.kernel.Role;

public class AgentAddress
implements Serializable {
    private static final long serialVersionUID = -5109274890965282440L;
    private transient AbstractAgent agent;
    private final KernelAddress kernelAddress;
    private final int hashCode;
    private Role roleObject;
    private String cgr;

    AgentAddress(AbstractAgent agt, Role role, KernelAddress ka) {
        this.agent = agt;
        this.roleObject = role;
        this.kernelAddress = ka;
        this.hashCode = agt.hashCode();
    }

    final AbstractAgent getAgent() {
        return this.agent;
    }

    final void setRoleObject(Role newRole) {
        if (newRole == null && this.cgr == null) {
            this.cgr = this.roleObject.getCommunityName() + ";;" + this.roleObject.getGroupName() + ";;" + this.roleObject.getRoleName();
        }
        this.roleObject = newRole;
    }

    Role getRoleObject() {
        return this.roleObject;
    }

    public KernelAddress getKernelAddress() {
        return this.kernelAddress;
    }

    public String getCommunity() {
        return this.roleObject != null ? this.roleObject.getCommunityName() : this.cgr.split(";;")[0];
    }

    public String getGroup() {
        return this.roleObject != null ? this.roleObject.getGroupName() : this.cgr.split(";;")[1];
    }

    public String getRole() {
        return this.roleObject != null ? this.roleObject.getRoleName() : this.cgr.split(";;")[2];
    }

    public String toString() {
        return this.hashCode + "@(" + this.getCommunity() + "," + this.getGroup() + "," + this.getRole() + ")" + this.kernelAddress;
    }

    public boolean equals(Object agentAddress) throws ClassCastException {
        if (this == agentAddress) {
            return true;
        }
        if (agentAddress == null || agentAddress.hashCode() != this.hashCode) {
            return false;
        }
        AgentAddress aa = (AgentAddress)agentAddress;
        return this.kernelAddress.equals(aa.kernelAddress) && this.getRole().equals(aa.getRole()) && this.getGroup().equals(aa.getGroup()) && this.getCommunity().equals(aa.getCommunity());
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public boolean isFrom(KernelAddress kernel) {
        return this.kernelAddress.equals(kernel);
    }

    public final String getAgentNetworkID() {
        return this.hashCode + "@" + this.kernelAddress.getNetworkID();
    }

    public final String getSimpleAgentNetworkID() {
        return this.hashCode + "@" + this.kernelAddress;
    }

    final void setAgent(AbstractAgent a) {
        this.agent = a;
    }
}

