/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.awt.Desktop;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import madkit.action.KernelAction;
import madkit.gui.SwingUtil;
import madkit.gui.menu.AboutFrame;
import madkit.i18n.Words;
import madkit.kernel.Madkit;

public final class HelpMenu
extends JMenu {
    private static final ImageIcon HELP_ICON = new ImageIcon(SwingUtil.class.getResource("images/help.png"));
    private static final ActionListener ABOUT = e -> new AboutFrame();
    private static final ActionListener DOC_LINKS = e -> {
        try {
            Desktop.getDesktop().browse(new URI(Madkit.WEB + "/" + e.getActionCommand()));
        }
        catch (IOException | URISyntaxException e1) {
            e1.printStackTrace();
        }
    };

    public HelpMenu() {
        super(Words.HELP.toString());
        JMenuItem mi;
        this.setMnemonic(69);
        if (Desktop.isDesktopSupported()) {
            ImageIcon ii = KernelAction.CONNECT_WEB_REPO.getActionInfo().getSmallIcon();
            mi = new JMenuItem("API", ii);
            mi.addActionListener(DOC_LINKS);
            mi.setActionCommand("repository/MaDKit-" + Madkit.VERSION + "/docs/api");
            this.add(mi);
            mi = new JMenuItem(Words.TUTORIALS.toString(), ii);
            mi.addActionListener(DOC_LINKS);
            mi.setActionCommand("tutorials");
            this.add(mi);
            mi = new JMenuItem("Forum", ii);
            mi.addActionListener(DOC_LINKS);
            mi.setActionCommand("forum");
            this.add(mi);
        }
        mi = new JMenuItem(Words.ABOUT.toString(), HELP_ICON);
        mi.setMnemonic(65);
        mi.addActionListener(ABOUT);
        this.add(mi);
    }
}

