/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.scheduler;

import java.time.LocalDateTime;
import java.util.PriorityQueue;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import madkit.kernel.Scheduler;
import madkit.simulation.activator.DateBasedDiscreteEventActivator;

public class DateBasedDiscreteEventScheduler
extends Scheduler {
    private PriorityQueue<DateBasedDiscreteEventActivator<? extends AbstractAgent>> activationList = new PriorityQueue();

    public DateBasedDiscreteEventScheduler() {
    }

    public DateBasedDiscreteEventScheduler(LocalDateTime initialDate) {
        super(initialDate);
    }

    @Override
    public void doSimulationStep() {
        this.logActivationStep();
        DateBasedDiscreteEventActivator<? extends AbstractAgent> nextActivator = this.getActivationList().poll();
        this.getSimulationTime().setCurrentDate(nextActivator.getNextActivationDate());
        nextActivator.execute(new Object[0]);
        this.getActivationList().add(nextActivator);
    }

    @Override
    public void addActivator(Activator<? extends AbstractAgent> activator) {
        super.addActivator(activator);
        if (activator instanceof DateBasedDiscreteEventActivator) {
            this.getActivationList().add((DateBasedDiscreteEventActivator)activator);
        }
    }

    @Override
    public void logActivationStep() {
        super.logActivationStep();
        this.getLogger().finest(() -> "Activation list -> " + this.getActivationList());
    }

    public PriorityQueue<DateBasedDiscreteEventActivator<? extends AbstractAgent>> getActivationList() {
        return this.activationList;
    }
}

