/*
 * Decompiled with CFR 0.152.
 */
package madkit.marketorg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.action.AgentAction;
import madkit.gui.AgentFrame;
import madkit.gui.OutputPanel;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.message.IntegerMessage;
import madkit.message.ObjectMessage;
import madkit.message.StringMessage;

public class Broker
extends Agent {
    private static final long serialVersionUID = 1217908977100108396L;
    static int nbOfBrokersOnScreen = 0;
    private static ImageIcon brokerImage = new ImageIcon(new ImageIcon(Broker.class.getResource("images/broker.png")).getImage().getScaledInstance(70, 70, 4));
    private JPanel blinkPanel;

    @Override
    protected void activate() {
        this.createGroupIfAbsent("travel", "travel-clients", true, null);
        this.createGroupIfAbsent("travel", "travel-providers", true, null);
        this.requestRole("travel", "travel-clients", "broker", null);
        this.requestRole("travel", "travel-providers", "broker", null);
    }

    @Override
    protected void live() {
        while (this.isAlive()) {
            String role;
            Message m = this.purgeMailbox();
            if (m == null) {
                m = this.waitNextMessage();
            }
            if (!(role = m.getSender().getRole()).equals("client")) continue;
            this.handleClientRequest((StringMessage)m);
        }
    }

    private void handleClientRequest(StringMessage request) {
        if (!this.checkAgentAddress(request.getSender())) {
            return;
        }
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.YELLOW);
        }
        this.getLogger().info(() -> "I received a request for a " + (String)request.getContent() + " \nfrom " + request.getSender());
        List<Message> bids = this.getBids(request);
        if (bids == null) {
            return;
        }
        IntegerMessage best = this.selectBestOffer(bids);
        this.makeTransactionHappenBetweenClientAndProvider(request, best);
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.LIGHT_GRAY);
        }
    }

    private List<Message> getBids(StringMessage request) {
        List<Message> bids = this.broadcastMessageWithRoleAndWaitForReplies("travel", "travel-providers", (String)request.getContent() + "-" + "provider", new StringMessage("make-bid-please"), "broker", 900);
        if (bids == null) {
            this.getLogger().info(() -> "No bids at all : No one is selling " + ((String)request.getContent()).toUpperCase() + " !!\nPlease launch other providers !");
            if (this.hasGUI()) {
                this.blinkPanel.setBackground(Color.LIGHT_GRAY);
            }
            return null;
        }
        return bids;
    }

    private void makeTransactionHappenBetweenClientAndProvider(StringMessage request, IntegerMessage best) {
        String contractGroupId = Instant.now().toString();
        Message ack = this.sendMessageWithRoleAndWaitForReply(best.getSender(), new StringMessage(contractGroupId), "broker", 1000);
        if (ack != null) {
            this.getLogger().info(() -> "Provider is ready !\nSending the contract number to client");
            this.sendReply(request, new StringMessage(contractGroupId));
            this.pause((int)(Math.random() * 2000.0 + 1000.0));
        } else {
            this.getLogger().info(() -> "Provider disappears !!!!");
        }
    }

    private IntegerMessage selectBestOffer(List<Message> bids) {
        List<IntegerMessage> offers = Arrays.asList(bids.toArray(new IntegerMessage[0]));
        IntegerMessage best = ObjectMessage.min(offers);
        this.getLogger().info(() -> "The best offer is from " + best.getSender() + " " + best.getContent());
        return best;
    }

    @Override
    protected void end() {
        AgentAction.RELOAD.getActionFor(this, new Object[0]).actionPerformed(null);
    }

    @Override
    public void setupFrame(AgentFrame frame) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new OutputPanel(this), "Center");
        this.blinkPanel = new JPanel();
        this.blinkPanel.add(new JLabel(brokerImage));
        p.add((Component)this.blinkPanel, "North");
        this.blinkPanel.setBackground(Color.LIGHT_GRAY);
        p.validate();
        frame.add(p);
        int xLocation = nbOfBrokersOnScreen++ * 390;
        if ((double)(xLocation + 390) > Toolkit.getDefaultToolkit().getScreenSize().getWidth()) {
            nbOfBrokersOnScreen = 0;
        }
        frame.setLocation(xLocation, 320);
        frame.setSize(390, 300);
    }
}

