/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.concurrent.ThreadFactory;
import madkit.kernel.KernelAddress;

final class AgentThreadFactory
implements ThreadFactory {
    private static final int MKRA_PRIORITY = 4;
    private static final int MKDA_PRIORITY = 10;
    private final boolean daemonThreads;
    private final ThreadGroup group;

    AgentThreadFactory(KernelAddress kernelAddress, boolean daemonThreadFactory) {
        this.daemonThreads = daemonThreadFactory;
        this.group = new ThreadGroup(this.daemonThreads ? "DAEMON" : "LIFE" + kernelAddress){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof ThreadDeath) {
                    e.printStackTrace();
                    throw new AssertionError((Object)"ThreadDeath uncaught");
                }
                System.err.println("--------------internal BUG--------------------");
                System.err.println("\n-----------------uncaught exception on " + t);
                e.printStackTrace();
            }
        };
        if (daemonThreadFactory) {
            this.group.setMaxPriority(10);
        } else {
            this.group.setMaxPriority(4);
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r);
        t.setDaemon(this.daemonThreads);
        return t;
    }

    ThreadGroup getThreadGroup() {
        return this.group;
    }
}

