/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import madkit.action.KernelAction;
import madkit.gui.MASModel;
import madkit.gui.SwingUtil;
import madkit.gui.menu.ClassPathSensitiveMenu;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.MadkitClassLoader;

public class LaunchMAS
extends ClassPathSensitiveMenu {
    private static final long serialVersionUID = -8245417381074154169L;
    private final transient AbstractAgent myAgent;

    public LaunchMAS(AbstractAgent agent) {
        super(Words.MAS.toString());
        this.setMnemonic(83);
        this.myAgent = agent;
        this.update();
    }

    private void addTomenu(Action a, JMenu subMenu, MASModel demo) {
        JMenuItem name = new JMenuItem(a);
        String displayedName = demo.getName();
        name.setText(displayedName);
        name.setIcon(SwingUtil.MADKIT_LOGO_SMALL);
        name.setToolTipText(demo.toString());
        name.setAccelerator(null);
        name.setActionCommand(displayedName);
        subMenu.add(name);
    }

    @Override
    public void update() {
        if (!this.myAgent.isAlive()) {
            return;
        }
        this.removeAll();
        for (MASModel dm : MadkitClassLoader.getAvailableConfigurations()) {
            this.addTomenu(KernelAction.LAUNCH_MAS.getActionFor(this.myAgent, dm), this, dm);
        }
        this.setVisible(this.getItemCount() != 0);
    }
}

