/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import madkit.action.ActionInfo;
import madkit.action.LoggingAction;
import madkit.gui.SwingUtil;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentLogger;

public class AgentLogLevelMenu
extends JMenu {
    private static final long serialVersionUID = 1274573952636236546L;
    private static final Preferences UI_LOGGING_PREFERENCES = Preferences.userRoot().node(AgentLogger.class.getName());
    private static final Map<AbstractAgent, AgentLogLevelMenu> menus = new HashMap<AbstractAgent, AgentLogLevelMenu>();
    private static final Level[] logLevels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    private final ButtonGroup logGroup;
    private final transient AgentLogger agentLogger;

    public AgentLogLevelMenu(AbstractAgent agent) {
        super("Logging");
        this.setMnemonic(76);
        ActionInfo action = LoggingAction.LOG_LEVEL.getActionInfo();
        JMenu logLevelMenu = new JMenu(action.getName());
        logLevelMenu.setIcon(action.getSmallIcon());
        logLevelMenu.setToolTipText(action.getShortDescription());
        this.logGroup = new ButtonGroup();
        this.add(logLevelMenu);
        String agentLogLEvelKey = agent.getName() + "_LL";
        this.agentLogger = agent.getLogger();
        ActionListener setLogLevelListener = evt -> {
            String levelName = evt.getActionCommand();
            this.agentLogger.setLevel(Level.parse(levelName));
            UI_LOGGING_PREFERENCES.put(agentLogLEvelKey, levelName);
        };
        for (Level l : logLevels) {
            JRadioButtonMenuItem logItem = new JRadioButtonMenuItem(l.getLocalizedName());
            this.initMenuItem(logItem, setLogLevelListener, l.toString(), this.logGroup, logLevelMenu);
        }
        this.agentLogger.setLevel(Level.parse(UI_LOGGING_PREFERENCES.get(agentLogLEvelKey, this.agentLogger.getLevel().toString())));
        this.update();
        SwingUtil.addBooleanActionTo(this, this.agentLogger.getEnableCGRWarningsAction());
        if (agent.hasGUI()) {
            menus.put(agent, this);
        }
    }

    private void update() {
        this.updateLogLevelGroup(this.agentLogger.getLevel());
    }

    public static void update(AbstractAgent agent) {
        AgentLogLevelMenu menu = menus.get(agent);
        if (menu != null) {
            menu.update();
        }
    }

    private void updateLogLevelGroup(Level logLevel) {
        Enumeration<AbstractButton> buttons = this.logGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.getActionCommand().equals(logLevel.toString())) continue;
            button.setSelected(true);
            return;
        }
    }

    private void initMenuItem(JRadioButtonMenuItem logItem, ActionListener listener, String actionCommand, ButtonGroup group, JMenu menu) {
        menu.add(logItem);
        logItem.setActionCommand(actionCommand);
        logItem.addActionListener(listener);
        group.add(logItem);
    }

    public static void remove(AbstractAgent abstractAgent) {
        menus.remove(abstractAgent);
    }
}

