/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import madkit.action.KernelAction;
import madkit.action.SchedulingAction;
import madkit.bees.AbstractBee;
import madkit.bees.BeeEnvironment;
import madkit.bees.BeeInformation;
import madkit.bees.BeeLauncher;
import madkit.bees.BeeScheduler;
import madkit.gui.AgentFrame;
import madkit.gui.SwingUtil;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.gui.menu.AgentMenu;
import madkit.gui.menu.LaunchAgentsMenu;
import madkit.gui.menu.MadkitMenu;
import madkit.message.EnumMessage;
import madkit.message.KernelMessage;
import madkit.message.ObjectMessage;
import madkit.message.SchedulingMessage;
import madkit.simulation.probe.PropertyProbe;
import madkit.simulation.viewer.SwingViewer;

public class BeeViewer
extends SwingViewer {
    private final BeeEnvironment environment;
    private JPanel display;
    private AbstractAction synchroPaint;
    private AbstractAction artMode;
    private AbstractAction randomMode;
    private AbstractAction launch;
    private AbstractAction trailModeAction;
    private AbstractAction multicoreMode;
    private PropertyProbe<AbstractBee, BeeInformation> beeProbe;
    private final BeeScheduler sch;
    protected int nbOfBeesToLaunch = 30000;
    public static int nbOfBroadcast = 0;

    public BeeViewer(BeeScheduler beeScheduler) {
        this.sch = beeScheduler;
        this.environment = new BeeEnvironment(new Dimension(1600, 1024));
    }

    @Override
    protected void activate() {
        this.requestRole("buzz", "bees", "bee observer");
        this.beeProbe = new PropertyProbe<AbstractBee, BeeInformation>("buzz", "bees", "bee", "myInformation"){

            @Override
            public void adding(AbstractBee bee) {
                super.adding(bee);
                bee.setEnvironment(BeeViewer.this.environment);
            }
        };
        this.addProbe(this.beeProbe);
    }

    @Override
    protected void end() {
        this.removeProbe(this.beeProbe);
        this.sendMessage("buzz", "bees", "launcher", new KernelMessage(KernelAction.EXIT, new Object[0]));
        this.sendMessage("buzz", "bees", "scheduler", new SchedulingMessage(SchedulingAction.SHUTDOWN, new Object[0]));
        this.leaveRole("buzz", "bees", "viewer");
    }

    @Override
    protected void render(Graphics g) {
        if (g != null) {
            this.computeFromInfoProbe(g);
        }
    }

    private void computeFromInfoProbe(Graphics g) {
        g.drawString("You are watching " + this.beeProbe.size() + " MaDKit agents", 10, 10);
        Color lastColor = null;
        boolean trailMode = (Boolean)this.trailModeAction.getValue("SwingSelectedKey");
        for (AbstractBee arg0 : this.beeProbe.getCurrentAgentsList()) {
            BeeInformation b = this.beeProbe.getPropertyValue(arg0);
            Color c = b.getBeeColor();
            if (c != lastColor) {
                lastColor = c;
                g.setColor(lastColor);
            }
            Point p = b.getCurrentPosition();
            if (trailMode) {
                Point p1 = b.getPreviousPosition();
                g.drawLine(p1.x, p1.y, p.x, p.y);
                continue;
            }
            g.drawLine(p.x, p.y, p.x, p.y);
        }
    }

    @Override
    public void setupFrame(AgentFrame frame) {
        super.setupFrame(frame);
        this.buildActions(frame);
        frame.setBackground(Color.black);
        JMenuBar jmenubar = new JMenuBar();
        jmenubar.add(new MadkitMenu(this));
        jmenubar.add(new AgentMenu(this));
        jmenubar.add(new LaunchAgentsMenu(this));
        jmenubar.add(new AgentLogLevelMenu(this));
        jmenubar.add(this.sch.getSchedulerMenu());
        JMenu options = new JMenu("Options");
        options.add(new JCheckBoxMenuItem(this.synchroPaint));
        options.add(new JCheckBoxMenuItem(this.artMode));
        options.add(new JCheckBoxMenuItem(this.randomMode));
        options.add(new JCheckBoxMenuItem(this.trailModeAction));
        options.add(this.launch);
        jmenubar.add(options);
        ActionListener beeLaunchActionListener = evt -> this.sendLaunchMessage(Integer.parseInt(evt.getActionCommand()));
        JMenu numberOfBees = new JMenu("Number of bees to launch when clicking the icon");
        JMenu launchBees = new JMenu("Launching");
        ButtonGroup bgroup = new ButtonGroup();
        int defaultBeesNb = 10000;
        for (int i = 1000; i <= 1000000; i *= 10) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("Launch " + i + " bees");
            item.setActionCommand(new Integer(i).toString().toString());
            item.addActionListener(e -> {
                this.nbOfBeesToLaunch = Integer.parseInt(e.getActionCommand());
            });
            JMenuItem it = new JMenuItem("Launch " + i + " bees");
            it.addActionListener(beeLaunchActionListener);
            it.setActionCommand("" + i);
            launchBees.add(it);
            item.setActionCommand("" + i);
            if (i == defaultBeesNb) {
                item.setSelected(true);
            }
            bgroup.add(item);
            numberOfBees.add(item);
        }
        options.add(numberOfBees);
        jmenubar.add(launchBees);
        frame.setJMenuBar(jmenubar);
        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.display = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (!((Boolean)BeeViewer.this.artMode.getValue("SwingSelectedKey")).booleanValue()) {
                    super.paintComponent(g);
                }
                BeeViewer.this.render(g);
            }
        };
        this.setDisplayPane(this.display);
        this.display.setBackground(Color.BLACK);
        this.display.setForeground(Color.white);
        frame.add(this.display);
        this.display.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BeeViewer.this.environment.setEnvSize(e.getComponent().getSize());
                if (BeeViewer.this.beeProbe != null) {
                    BeeViewer.this.beeProbe.initialize();
                }
            }
        });
        JToolBar tb = new JToolBar();
        this.addButtonToToolbar(tb, this.randomMode);
        this.addButtonToToolbar(tb, this.artMode);
        this.addButtonToToolbar(tb, this.trailModeAction);
        this.addButtonToToolbar(tb, this.synchroPaint);
        this.addButtonToToolbar(tb, this.launch);
        this.addButtonToToolbar(tb, this.multicoreMode);
        JPanel tools = new JPanel(new FlowLayout(0));
        tools.add(tb);
        tools.add(this.sch.getSchedulerToolBar());
        JToolBar modelProperties = new JToolBar();
        modelProperties.add(SwingUtil.createSliderPanel(this.environment.getQueenAcceleration(), "queen acceleration"));
        modelProperties.add(SwingUtil.createSliderPanel(this.environment.getQueenVelocity(), "queen velocity"));
        modelProperties.add(SwingUtil.createSliderPanel(this.environment.getBeeAcceleration(), "bee acceleration"));
        modelProperties.add(SwingUtil.createSliderPanel(this.environment.getBeeVelocity(), "bee velocity"));
        tools.add(modelProperties);
        frame.add((Component)this.sch.getSchedulerStatusLabel(), "South");
        this.display.getParent().add((Component)tools, "First");
        frame.setLocationRelativeTo(null);
        frame.setExtendedState(6);
    }

    private void addButtonToToolbar(JToolBar tb, Action a) {
        JToggleButton jt = new JToggleButton(a);
        jt.setText(null);
        tb.add(jt);
    }

    void buildActions(JFrame frame) {
        this.synchroPaint = new AbstractAction("Synchronous painting"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeeViewer.this.setSynchronousPainting((Boolean)BeeViewer.this.synchroPaint.getValue("SwingSelectedKey") == false);
            }
        };
        this.initActionIcon(this.synchroPaint, "Deactivate the synchronous painting mode (faster)", "synchroPaint");
        this.synchroPaint.putValue("SwingSelectedKey", false);
        this.artMode = new AbstractAction("Art mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.initActionIcon(this.artMode, "A funny painting mode", "artMode");
        this.randomMode = new AbstractAction("Random mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeeViewer.this.sendMessage("buzz", "bees", "launcher", new EnumMessage<BeeLauncher.BeeLauncherAction>(BeeLauncher.BeeLauncherAction.RANDOM_MODE, BeeViewer.this.randomMode.getValue("SwingSelectedKey")));
            }
        };
        this.initActionIcon(this.randomMode, "Random mode: Randomly launch or kill bees", "random");
        this.randomMode.putValue("SwingSelectedKey", true);
        this.multicoreMode = new AbstractAction("Multicore mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeeViewer.this.sendMessage("buzz", "bees", "scheduler", new ObjectMessage<Boolean>((Boolean)BeeViewer.this.multicoreMode.getValue("SwingSelectedKey")));
            }
        };
        this.initActionIcon(this.multicoreMode, "Multicore mode: Use several processor cores if available (more efficient if synchro painting is off", "multicore");
        this.trailModeAction = new AbstractAction("Trail mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.initActionIcon(this.trailModeAction, "Trails mode: display agents with trails or like point particles", "trail");
        this.trailModeAction.putValue("SwingSelectedKey", true);
        this.launch = new AbstractAction("Launch bees"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeeViewer.this.sendLaunchMessage(BeeViewer.this.nbOfBeesToLaunch);
            }
        };
        this.initActionIcon(this.launch, "Launch some bees", "launch");
    }

    private void initActionIcon(AbstractAction a, String description, String actionCommand) {
        a.putValue("SwingSelectedKey", false);
        a.putValue("ActionCommandKey", actionCommand);
        a.putValue("ShortDescription", description);
        ImageIcon big = new ImageIcon(this.getClass().getResource("images/bees_" + actionCommand + ".png"));
        a.putValue("SwingLargeIconKey", big);
        a.putValue("SmallIcon", new ImageIcon(big.getImage().getScaledInstance(16, 16, 4)));
    }

    private void sendLaunchMessage(int nb) {
        this.sendMessage("buzz", "bees", "launcher", new EnumMessage<BeeLauncher.BeeLauncherAction>(BeeLauncher.BeeLauncherAction.LAUNCH_BEES, nb));
    }
}

