/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.activator;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.PriorityQueue;
import madkit.kernel.AbstractAgent;
import madkit.simulation.activator.GenericBehaviorActivator;

public class DiscreteEventAgentsActivator<A extends AbstractAgent>
extends GenericBehaviorActivator<A>
implements Comparable<DiscreteEventAgentsActivator<A>> {
    private LocalDateTime nextActivationDate;
    private Duration defaultInterval = Duration.ofSeconds(1L);
    private PriorityQueue<A> agentsActivationList = new PriorityQueue(new Comparator<A>(){

        @Override
        public int compare(AbstractAgent o1, AbstractAgent o2) {
            return o1.getNextEventDate().compareTo(o2.getNextEventDate());
        }
    });

    public DiscreteEventAgentsActivator(String community, String group, String role, String theBehaviorToActivate) {
        super(community, group, role, theBehaviorToActivate);
    }

    @Override
    public int compareTo(DiscreteEventAgentsActivator<A> o) {
        int result = this.getNextActivationDate().compareTo(o.getNextActivationDate());
        if (result == 0) {
            return Integer.compare(this.getPriority(), o.getPriority());
        }
        return result;
    }

    public LocalDateTime getNextActivationDate() {
        return this.nextActivationDate;
    }

    @Override
    protected void adding(A agent) {
        super.adding(agent);
        this.agentsActivationList.add(agent);
    }

    @Override
    protected void removing(A agent) {
        super.removing(agent);
        this.agentsActivationList.remove(agent);
    }

    public void setNextActivationDate(LocalDateTime nextActivationDate) {
        this.nextActivationDate = nextActivationDate;
    }

    @Override
    public void execute(Object ... args) {
        while (this.agentsActivationList.size() > 0 && ((AbstractAgent)this.agentsActivationList.peek()).getNextEventDate().equals(this.nextActivationDate)) {
            AbstractAgent a = (AbstractAgent)this.agentsActivationList.poll();
            this.executeBehaviorOf(a, this.getBehaviorName(), args);
            this.agentsActivationList.add(a);
        }
        this.setNextActivationDate(((AbstractAgent)this.agentsActivationList.peek()).getNextEventDate());
    }

    @Override
    public String toString() {
        return super.toString() + " ; nextDate = " + this.getNextActivationDate();
    }

    public Duration getDefaultInterval() {
        return this.defaultInterval;
    }

    public void setDefaultInterval(Duration defaultInterval) {
        this.defaultInterval = defaultInterval;
    }
}

