/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import com.sun.javaws.jnl.JARDesc;
import com.sun.jnlp.JNLPClassLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import madkit.gui.MASModel;
import madkit.gui.menu.ClassPathSensitiveMenu;
import madkit.kernel.AbstractAgent;
import madkit.kernel.MadkitProperties;
import madkit.util.XMLUtilities;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class MadkitClassLoader
extends URLClassLoader {
    private Collection<String> classesToReload;
    private static Set<String> agentClasses;
    private static Set<String> mdkFiles;
    private static Set<String> xmlFiles;
    private static Set<String> mains;
    private static Set<MASModel> demos;
    private static Set<URL> scannedURLs;
    private static MadkitClassLoader currentMCL;

    private MadkitClassLoader(URL[] urls, ClassLoader parent, Collection<String> toReload) {
        super(urls, parent);
        if (toReload != null) {
            this.classesToReload = new HashSet<String>(toReload);
        }
        currentMCL = this;
    }

    public static MadkitClassLoader getLoader() {
        return currentMCL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if (this.classesToReload != null && this.classesToReload.contains(name)) {
            c = this.findLoadedClass(name);
            if (c == null) {
                this.addUrlAndloadClasses(name);
                this.classesToReload = null;
                return this.loadClass(name, resolve);
            }
            MadkitClassLoader mcl = new MadkitClassLoader(this.getURLs(), (ClassLoader)this, this.classesToReload);
            this.classesToReload.remove(name);
            c = mcl.loadClass(name, resolve);
        } else {
            c = this.findLoadedClass(name);
        }
        if (c == null) {
            return super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public static void reloadClass(String name) throws ClassNotFoundException {
        if (currentMCL.getResource(name.replace('.', '/') + ".class") == null) {
            throw new ClassNotFoundException(name);
        }
        if (MadkitClassLoader.currentMCL.classesToReload == null) {
            MadkitClassLoader.currentMCL.classesToReload = new HashSet<String>();
        }
        MadkitClassLoader.currentMCL.classesToReload.add(name);
    }

    public static boolean loadJarsFromDirectory(String directoryPath) {
        File demoDir = new File(directoryPath);
        boolean hasLoadSomething = false;
        if (demoDir.isDirectory()) {
            for (File f : demoDir.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    if (!MadkitClassLoader.loadUrl(f.toURI().toURL())) continue;
                    hasLoadSomething = true;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        return hasLoadSomething;
    }

    private void addUrlAndloadClasses(String name) {
        if (name.startsWith("madkit.kernel.")) {
            return;
        }
        URL url = this.getResource(name.replace('.', '/') + ".class");
        if (url != null && url.getProtocol().equals("file")) {
            String packageName = MadkitClassLoader.getClassPackageName(name);
            packageName = packageName == null ? "" : packageName + '.';
            String urlPath = url.getPath();
            File packageDir = new File(urlPath.substring(0, urlPath.lastIndexOf(47)));
            for (String fileName : packageDir.list()) {
                if (!fileName.endsWith(".class")) continue;
                try {
                    String className = packageName + fileName.substring(0, fileName.length() - 6);
                    if (this.findLoadedClass(className) != null) continue;
                    this.findClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (ClassCircularityError classCircularityError) {
                    // empty catch block
                }
            }
        }
    }

    public static String getClassPackageName(String classFullName) {
        int index = classFullName.lastIndexOf(46);
        return index > 0 ? classFullName.substring(0, index) : null;
    }

    public static String getClassSimpleName(String classFullName) {
        int index = classFullName.lastIndexOf(46);
        return index > 0 ? classFullName.substring(index + 1, classFullName.length()) : classFullName;
    }

    private static void scanClassPathForAgentClasses() {
        if (scannedURLs == null) {
            scannedURLs = new HashSet<URL>();
            agentClasses = new TreeSet<String>();
            demos = new HashSet<MASModel>();
            mdkFiles = new HashSet<String>();
            xmlFiles = new HashSet<String>();
            mains = new HashSet<String>();
        }
        for (URL dir : MadkitClassLoader.getLoader().getURLs()) {
            if (!scannedURLs.add(dir)) continue;
            if (dir.getFile().endsWith(".jar")) {
                try (JarFile jarFile = ((JarURLConnection)new URL("jar:" + dir + "!/").openConnection()).getJarFile();){
                    MadkitClassLoader.scanJarFileForLaunchConfig(jarFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            MadkitClassLoader.scanFolderForAgentClasses(new File(dir.getFile()), null, dir.getPath());
        }
    }

    public static boolean loadUrl(URL url) {
        if (!Arrays.asList(MadkitClassLoader.getLoader().getURLs()).contains(url)) {
            MadkitClassLoader.getLoader().addURL(url);
            System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + url.getPath());
            ClassPathSensitiveMenu.updateAllMenus();
            return true;
        }
        return false;
    }

    public static Set<MASModel> getAvailableConfigurations() {
        MadkitClassLoader.scanClassPathForAgentClasses();
        return new HashSet<MASModel>(demos);
    }

    public static Set<String> getAllAgentClasses() {
        MadkitClassLoader.scanClassPathForAgentClasses();
        return new TreeSet<String>(agentClasses);
    }

    public static Set<String> getMDKFiles() {
        MadkitClassLoader.scanClassPathForAgentClasses();
        return new TreeSet<String>(mdkFiles);
    }

    public static Set<String> getXMLConfigurations() {
        MadkitClassLoader.scanClassPathForAgentClasses();
        return new TreeSet<String>(xmlFiles);
    }

    public static Set<String> getAgentsWithMain() {
        MadkitClassLoader.scanClassPathForAgentClasses();
        return new TreeSet<String>(mains);
    }

    void addMASConfig(MASModel session) {
        demos.add(session);
    }

    private static void scanJarFileForLaunchConfig(JarFile jarFile) {
        Attributes projectInfo = null;
        try {
            projectInfo = jarFile.getManifest().getAttributes("MaDKit-Project-Info");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (projectInfo != null) {
            String mdkArgs = projectInfo.getValue("MaDKit-Args");
            if (MadkitClassLoader.check(mdkArgs)) {
                String projectName = projectInfo.getValue("Project-Name").trim();
                String projectDescription = projectInfo.getValue("Description").trim();
                MASModel mas = new MASModel(projectName, mdkArgs.trim().split("\\s+"), projectDescription);
                demos.add(mas);
            }
            if (MadkitClassLoader.check(mdkArgs = projectInfo.getValue("MDK-Files"))) {
                for (String configFile : mdkArgs.split(",")) {
                    mdkFiles.add(configFile);
                }
            }
            if (MadkitClassLoader.check(mdkArgs = projectInfo.getValue("Main-Classes"))) {
                mains.addAll(Arrays.asList(mdkArgs.split(",")));
            }
            if (MadkitClassLoader.check(mdkArgs = projectInfo.getValue("XML-Files"))) {
                xmlFiles.addAll(Arrays.asList(mdkArgs.split(",")));
            }
            agentClasses.addAll(Arrays.asList(projectInfo.getValue("Agent-Classes").split(",")));
        }
    }

    private static boolean check(String args) {
        return args != null && !args.trim().isEmpty();
    }

    private static void scanFolderForAgentClasses(File file, String pckName, String currentUrlPath) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                String fileName = f.getName();
                if (f.isDirectory()) {
                    MadkitClassLoader.scanFolderForAgentClasses(f, pckName == null ? fileName : pckName + "." + fileName, currentUrlPath);
                    continue;
                }
                if (fileName.endsWith(".class")) {
                    String className = (pckName == null ? "" : pckName + ".") + fileName.replace(".class", "");
                    if (!MadkitClassLoader.isAgentClass(className)) continue;
                    agentClasses.add(className);
                    continue;
                }
                if (fileName.endsWith(".mdk")) {
                    mdkFiles.add(f.getPath().substring(currentUrlPath.length()));
                    continue;
                }
                if (!fileName.endsWith(".xml")) continue;
                String xmlFile = f.getPath().substring(currentUrlPath.length());
                try {
                    Document dom = XMLUtilities.getDOM(xmlFile);
                    if (dom == null || !dom.getDocumentElement().getNodeName().equals("MDK")) continue;
                    xmlFiles.add(xmlFile);
                }
                catch (IOException | ParserConfigurationException | SAXException exception) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean isAgentClass(String className) {
        block4: {
            try {
                Class<?> cl = MadkitClassLoader.getLoader().loadClass(className);
                if (cl == null || !AbstractAgent.class.isAssignableFrom(cl) || cl.getConstructor(null) == null || Modifier.isAbstract(cl.getModifiers()) || !Modifier.isPublic(cl.getModifiers())) break block4;
                try {
                    cl.getDeclaredMethod("main", String[].class);
                    mains.add(className);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return true;
            }
            catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodException | SecurityException | VerifyError throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static String findJExecutable(File dir, String executable) {
        if ((dir = new File(dir, "bin")).exists()) {
            for (File candidate : dir.listFiles()) {
                if (!candidate.getName().contains(executable)) continue;
                return candidate.getAbsolutePath();
            }
        }
        return null;
    }

    public static String findJavaExecutable(String executable) {
        File lookupDir = new File(System.getProperty("java.home"));
        String exe = MadkitClassLoader.findJExecutable(lookupDir, executable);
        if (exe != null) {
            return exe;
        }
        exe = MadkitClassLoader.findJExecutable(lookupDir = lookupDir.getParentFile(), executable);
        if (exe != null) {
            return exe;
        }
        while (lookupDir != null) {
            for (File dir : lookupDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        String dirName = pathname.getName();
                        return dirName.contains("jdk") || dirName.contains("java");
                    }
                    return false;
                }
            })) {
                exe = MadkitClassLoader.findJExecutable(dir, executable);
                if (exe == null) continue;
                return exe;
            }
            lookupDir = lookupDir.getParentFile();
        }
        return null;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        p.setProperty("agents.classes", MadkitClassLoader.normalizeResult(MadkitClassLoader.getAllAgentClasses()));
        p.setProperty("mdk.files", MadkitClassLoader.normalizeResult(MadkitClassLoader.getMDKFiles()));
        p.setProperty("xml.files", MadkitClassLoader.normalizeResult(MadkitClassLoader.getXMLConfigurations()));
        p.setProperty("main.classes", MadkitClassLoader.normalizeResult(MadkitClassLoader.getAgentsWithMain()));
        String findJavaExecutable = MadkitClassLoader.findJavaExecutable("jarsigner");
        if (findJavaExecutable != null) {
            p.setProperty("jarsigner.path", findJavaExecutable);
        }
        try (FileOutputStream out = new FileOutputStream(new File(System.getProperty("java.io.tmpdir") + File.separatorChar + "agentClasses.properties"));){
            p.store(out, MadkitClassLoader.getLoader().toString());
        }
    }

    private static String normalizeResult(Set<String> set) {
        String s = set.toString();
        return s.substring(1, s.length() - 1).replace(", ", ",");
    }

    public String toString() {
        return "MCL CP : " + Arrays.deepToString(this.getURLs()) + "\nmains=" + MadkitClassLoader.getAgentsWithMain();
    }

    static {
        URL[] urls;
        if (MadkitProperties.JAVAWS_IS_ON) {
            JARDesc[] jars = JNLPClassLoader.getInstance().getLaunchDesc().getResources().getEagerOrAllJarDescs(true);
            urls = new URL[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                urls[i] = jars[i].getLocation();
            }
        } else {
            String[] urlsName = System.getProperty("java.class.path").split(File.pathSeparator);
            urls = new URL[urlsName.length];
            for (int i = 0; i < urlsName.length; ++i) {
                try {
                    urls[i] = new File(urlsName[i]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        currentMCL = new MadkitClassLoader(urls, MadkitClassLoader.class.getClassLoader(), null);
    }
}

