/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import madkit.gui.AgentStatusPanel;
import madkit.gui.PrintableFrame;
import madkit.gui.SwingUtil;
import madkit.gui.menu.DisplayMenu;
import madkit.gui.menu.HelpMenu;
import madkit.gui.menu.LaunchAgentsMenu;
import madkit.gui.menu.LaunchMAS;
import madkit.gui.menu.LaunchMDKConfigurations;
import madkit.gui.menu.LaunchMain;
import madkit.gui.menu.LaunchXMLConfigurations;
import madkit.gui.menu.MadkitMenu;
import madkit.gui.toolbar.MadkitToolBar;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Madkit;

public class MDKDesktopFrame
extends JFrame
implements PrintableFrame {
    private static final Preferences DESKTOP_UI_PREFERENCES = Preferences.userRoot().node(MDKDesktopFrame.class.getName());
    private static final long serialVersionUID = -5136102562032184534L;
    private final JDesktopPane desktopPane;

    public MDKDesktopFrame() {
        super("MaDKit " + Madkit.VERSION + " Desktop ");
        this.setPreferredSize(new Dimension(800, 600));
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(Color.BLACK);
        this.add(this.desktopPane);
        this.setIconImage(SwingUtil.MADKIT_LOGO.getImage());
        String key = "MDK_Desktop_BGC";
        this.setBackground(new Color(DESKTOP_UI_PREFERENCES.getInt("MDK_Desktop_BGC", Color.BLACK.getRGB())));
        this.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("background")) {
                DESKTOP_UI_PREFERENCES.putInt("MDK_Desktop_BGC", ((Color)evt.getNewValue()).getRGB());
            }
        });
    }

    public JMenuBar getMenuBar(AbstractAgent guiManager) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new MadkitMenu(guiManager));
        menuBar.add(new LaunchAgentsMenu(guiManager));
        menuBar.add(new LaunchMAS(guiManager));
        menuBar.add(new LaunchMain("Main"));
        menuBar.add(new LaunchMDKConfigurations("Configuration"));
        menuBar.add(new LaunchXMLConfigurations(guiManager, "XML"));
        menuBar.add(new DisplayMenu(this));
        menuBar.add(new HelpMenu());
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(new AgentStatusPanel(guiManager));
        return menuBar;
    }

    public JToolBar getToolBar(AbstractAgent guiManager) {
        return new MadkitToolBar(guiManager);
    }

    final JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        if (this.desktopPane != null) {
            this.desktopPane.setBackground(bgColor);
        }
    }
}

