/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import madkit.gui.SwingUtil;
import madkit.gui.menu.SwingLink;
import madkit.i18n.Words;
import madkit.kernel.Madkit;

final class AboutFrame
extends JDialog {
    private static final long serialVersionUID = -6873297970139729692L;

    public AboutFrame() {
        this.setTitle("MaDKit");
        JLabel icon = new JLabel(SwingUtil.MADKIT_LOGO);
        icon.setBounds(10, 10, 10, 10);
        this.add((Component)icon, "West");
        this.setIconImage(SwingUtil.MADKIT_LOGO.getImage());
        JTextPane textPanel = new JTextPane();
        textPanel.setEditable(false);
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.add(Box.createRigidArea(new Dimension(0, 110)));
        StyledDocument doc = textPanel.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        Style s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = doc.addStyle("large", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontSize(s, 20);
        String version = null;
        try (BufferedReader in2 = new BufferedReader(new InputStreamReader(new URL(Madkit.WEB + "/LAST").openStream()));){
            version = "\n\n   " + Words.LAST_AVAILABLE.toString() + ": " + in2.readLine() + "\n";
        }
        catch (IOException in2) {
            // empty catch block
        }
        try {
            doc.insertString(doc.getLength(), "  MaDKit\n", doc.getStyle("large"));
            doc.insertString(doc.getLength(), "   Multiagent Development Kit\n\n", doc.getStyle("italic"));
            doc.insertString(doc.getLength(), "   Version: " + Madkit.VERSION + "\n   Build id: " + Madkit.BUILD_ID + (version == null ? "" : version), doc.getStyle("small"));
            textPanel.add(new SwingLink(Madkit.WEB.substring(7, 21), new URI(Madkit.WEB)));
        }
        catch (URISyntaxException | BadLocationException e) {
            e.printStackTrace();
        }
        this.add(textPanel);
        JButton close = new JButton("OK");
        close.addActionListener(evt -> this.dispose());
        this.add((Component)close, "South");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.setSize(400, 250);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        close.requestFocus();
    }
}

