/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import madkit.kernel.AbstractAgent;

abstract class AgentsJob
implements Callable<Void>,
Cloneable {
    private List<AbstractAgent> list;

    AgentsJob() {
    }

    @Override
    public Void call() throws Exception {
        for (AbstractAgent a : this.list) {
            this.proceedAgent(a);
        }
        return null;
    }

    final ArrayList<AgentsJob> getJobs(List<AbstractAgent> l, int cpuCoreNb) {
        ArrayList<AgentsJob> workers = new ArrayList<AgentsJob>(cpuCoreNb);
        int bucketSize = l.size();
        int nbOfAgentsPerTask = bucketSize / cpuCoreNb;
        if (nbOfAgentsPerTask == 0) {
            this.list = l;
            workers.add(this);
            return workers;
        }
        for (int i = 0; i < cpuCoreNb; ++i) {
            int firstIndex = nbOfAgentsPerTask * i;
            workers.add(this.createNewAgentJobWithList(l.subList(firstIndex, firstIndex + nbOfAgentsPerTask)));
        }
        workers.add(this.createNewAgentJobWithList(l.subList(cpuCoreNb * nbOfAgentsPerTask, l.size())));
        return workers;
    }

    private AgentsJob createNewAgentJobWithList(List<AbstractAgent> l) {
        AgentsJob aj = null;
        try {
            aj = (AgentsJob)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        aj.list = l;
        return aj;
    }

    abstract void proceedAgent(AbstractAgent var1);
}

