/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import madkit.action.BooleanAction;
import madkit.action.GUIManagerAction;
import madkit.action.GlobalAction;
import madkit.action.KernelAction;
import madkit.kernel.AbstractAgent;
import madkit.kernel.MadkitProperties;

public final class SwingUtil {
    public static final ImageIcon MADKIT_LOGO = new ImageIcon(SwingUtil.class.getResource("images/madkit_logo.png"));
    public static final ImageIcon MADKIT_LOGO_SMALL = new ImageIcon(MADKIT_LOGO.getImage().getScaledInstance(14, 14, 4));

    private SwingUtil() {
    }

    public static JPanel createSliderPanel(JSlider slider, String label) {
        return SwingUtil.createSliderPanel(slider, label, 170);
    }

    public static JPanel createSliderPanel(JSlider slider, String label, int width) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder(label));
        p.setPreferredSize(new Dimension(width, 60));
        p.add(slider);
        return p;
    }

    public static JPanel createSliderPanel(BoundedRangeModel model, String label) {
        return SwingUtil.createSliderPanel(SwingUtil.createJSlider(model), label);
    }

    public static JSlider createJSlider(final BoundedRangeModel model) {
        final JSlider slider = new JSlider(model);
        slider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                slider.setValue(-e.getWheelRotation() * model.getMaximum() / 100 + model.getValue());
            }
        });
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        return slider;
    }

    public static void addMaDKitActionsTo(Container menuOrToolBar, AbstractAgent agent) {
        try {
            Class<?> componentClass = menuOrToolBar.getClass();
            Method add = componentClass.getMethod("add", Action.class);
            Method addSeparator = componentClass.getMethod("addSeparator", new Class[0]);
            add.invoke((Object)menuOrToolBar, KernelAction.EXIT.getActionFor(agent, new Object[0]));
            addSeparator.invoke((Object)menuOrToolBar, new Object[0]);
            add.invoke((Object)menuOrToolBar, KernelAction.COPY.getActionFor(agent, new Object[0]));
            add.invoke((Object)menuOrToolBar, KernelAction.RESTART.getActionFor(agent, new Object[0]));
            addSeparator.invoke((Object)menuOrToolBar, new Object[0]);
            add.invoke((Object)menuOrToolBar, KernelAction.LAUNCH_NETWORK.getActionFor(agent, new Object[0]));
            add.invoke((Object)menuOrToolBar, KernelAction.STOP_NETWORK.getActionFor(agent, new Object[0]));
            add.invoke((Object)menuOrToolBar, GUIManagerAction.CONNECT_TO_IP.getActionFor(agent, new Object[0]));
            addSeparator.invoke((Object)menuOrToolBar, new Object[0]);
            if (GlobalAction.JCONSOLE != null && !MadkitProperties.JAVAWS_IS_ON) {
                add.invoke((Object)menuOrToolBar, GlobalAction.JCONSOLE);
            }
            add.invoke((Object)menuOrToolBar, KernelAction.CONSOLE.getActionFor(agent, new Object[0]));
            SwingUtil.addBooleanActionTo(menuOrToolBar, GlobalAction.DEBUG);
            add.invoke((Object)menuOrToolBar, GlobalAction.LOG_FILES);
            if (!MadkitProperties.JAVAWS_IS_ON) {
                addSeparator.invoke((Object)menuOrToolBar, new Object[0]);
                add.invoke((Object)menuOrToolBar, GlobalAction.LOAD_LOCAL_DEMOS);
                add.invoke((Object)menuOrToolBar, GlobalAction.LOAD_JAR_FILE);
            }
            addSeparator.invoke((Object)menuOrToolBar, new Object[0]);
            add.invoke((Object)menuOrToolBar, GUIManagerAction.ICONIFY_ALL.getActionFor(agent, new Object[0]));
            add.invoke((Object)menuOrToolBar, GUIManagerAction.DEICONIFY_ALL.getActionFor(agent, new Object[0]));
            addSeparator.invoke((Object)menuOrToolBar, new Object[0]);
            add.invoke((Object)menuOrToolBar, GUIManagerAction.KILL_AGENTS.getActionFor(agent, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static AbstractButton addBooleanActionTo(Container menuOrToolBar, BooleanAction action) {
        try {
            Method addButton = Container.class.getMethod("add", Component.class);
            if (menuOrToolBar instanceof JMenu) {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(action);
                addButton.invoke((Object)menuOrToolBar, jCheckBoxMenuItem);
                return jCheckBoxMenuItem;
            }
            JToggleButton jToggleButton = new JToggleButton(action);
            jToggleButton.setText(null);
            addButton.invoke((Object)menuOrToolBar, jToggleButton);
            return jToggleButton;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void scaleAllAbstractButtonIconsOf(Container container, int size) {
        for (Component c : container.getComponents()) {
            ImageIcon i;
            if (!(c instanceof AbstractButton) || (i = (ImageIcon)((AbstractButton)c).getIcon()) == null) continue;
            i.setImage(i.getImage().getScaledInstance(size, size, 4));
        }
    }
}

