/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentLogger;

public class OutputPanel
extends JPanel {
    private static final long serialVersionUID = 602152712654986449L;
    private final JTextArea textArea = new JTextArea(5, 32);
    private transient StreamHandler handler;

    public OutputPanel(AbstractAgent agent) {
        this.setLayout(new BorderLayout());
        this.textArea.setEditable(false);
        this.setPreferredSize(new Dimension(250, 100));
        this.setBackground(Color.WHITE);
        this.initHandler(agent);
        this.add("Center", new JScrollPane(this.textArea));
        JButton b = new JButton("clear");
        b.addActionListener(evt -> this.clearOutput());
        this.add("South", b);
        this.setBackground(Color.WHITE);
    }

    public void writeToTextArea(String text) {
        if (EventQueue.isDispatchThread()) {
            this.textArea.append(text);
            this.textArea.setCaretPosition(this.textArea.getText().length());
        } else {
            EventQueue.invokeLater(() -> this.writeToTextArea(text));
        }
    }

    public void clearOutput() {
        this.textArea.setText(null);
    }

    @Override
    public void setBackground(Color bg) {
        if (this.textArea != null) {
            this.textArea.setBackground(bg);
        }
        super.setBackground(bg);
    }

    private void initHandler(AbstractAgent agent) {
        this.handler = new StreamHandler(){

            @Override
            public synchronized void publish(LogRecord record) {
                String msg;
                if (!this.isLoggable(record)) {
                    return;
                }
                try {
                    msg = this.getFormatter().format(record);
                }
                catch (Exception ex) {
                    this.reportError(null, ex, 5);
                    return;
                }
                OutputPanel.this.writeToTextArea(msg);
            }

            @Override
            public boolean isLoggable(LogRecord record) {
                int levelValue = this.getLevel().intValue();
                if (record.getLevel().intValue() < levelValue || levelValue == Level.OFF.intValue()) {
                    return false;
                }
                Filter filter = this.getFilter();
                if (filter == null) {
                    return true;
                }
                return filter.isLoggable(record);
            }
        };
        this.handler.setFormatter(AgentLogger.AGENT_FILE_FORMATTER);
        agent.getLogger().addHandler(this.getHandler());
    }

    public StreamHandler getHandler() {
        return this.handler;
    }
}

