/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import madkit.action.GUIManagerAction;
import madkit.action.KernelAction;
import madkit.gui.AgentFrame;
import madkit.gui.MDKDesktopFrame;
import madkit.gui.SwingUtil;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Madkit;
import madkit.kernel.MadkitClassLoader;
import madkit.kernel.MadkitProperties;
import madkit.kernel.Message;
import madkit.message.GUIMessage;
import madkit.message.KernelMessage;

class GUIManagerAgent
extends Agent {
    private final ConcurrentMap<AbstractAgent, JFrame> guis = new ConcurrentHashMap<AbstractAgent, JFrame>();
    private boolean shuttedDown = false;
    private JDesktopPane desktopPane;
    private MDKDesktopFrame myFrame;
    private Constructor<? extends AgentFrame> agentFrameConstrutor;

    GUIManagerAgent(boolean asDaemon) {
        super(asDaemon);
        this.getLogger().doNotReactToDebugMode();
    }

    @Override
    protected void activate() {
        this.getLogger().setLevel(Madkit.LevelOption.guiLogLevel.getValue(this.getMadkitConfig()));
        try {
            this.agentFrameConstrutor = MadkitClassLoader.getLoader().loadClass(this.getMadkitProperty(Madkit.Option.agentFrameClass)).getDeclaredConstructor(AbstractAgent.class);
        }
        catch (ClassCastException | ClassNotFoundException | NoSuchMethodException | SecurityException e1) {
            this.getLogger().severeLog("agent frame init :", e1);
            try {
                this.agentFrameConstrutor = AgentFrame.class.getConstructor(AbstractAgent.class);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        this.setThreadPriority(10);
        if (!this.isDaemon()) {
            try {
                this.buildUI();
                if (MadkitProperties.JAVAWS_IS_ON) {
                    this.setMadkitProperty(Madkit.BooleanOption.autoConnectMadkitWebsite, "true");
                }
            }
            catch (HeadlessException e) {
                this.headlessLog(e);
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.getLogger().severeLog(Words.FAILED.toString() + " : UI creation", e);
            }
        }
        this.createGroup("local", "gui");
    }

    private void headlessLog(HeadlessException e) {
        this.getLogger().severe("\t" + e.getMessage() + "\n\tNo graphic environment, quitting");
        this.shuttedDown = true;
    }

    @Override
    protected void live() {
        while (!this.shuttedDown) {
            Message m = this.waitNextMessage();
            if (m instanceof GUIMessage) {
                this.proceedCommandMessage((GUIMessage)m);
                continue;
            }
            if (m instanceof KernelMessage) {
                this.proceedEnumMessage((KernelMessage)m);
                continue;
            }
            this.getLogger().warning(() -> "I received a message that I do not understand. Discarding " + m);
        }
    }

    private void proceedCommandMessage(GUIMessage cm) {
        if (this.isAlive()) {
            if (cm.getCode() == GUIManagerAction.SETUP_AGENT_GUI) {
                try {
                    this.setupAgentGui((AbstractAgent)((Object[])cm.getContent())[0]);
                }
                catch (HeadlessException e) {
                    this.headlessLog(e);
                }
                finally {
                    this.sendReply(cm, cm);
                }
            } else {
                super.proceedEnumMessage(cm);
            }
        }
    }

    @Override
    protected void end() {
        this.killAgents();
        if (this.myFrame != null) {
            this.myFrame.dispose();
        }
        this.getLogger().finer(() -> "Ending: Frames disposed");
    }

    private void exit() {
        this.shuttedDown = true;
    }

    private void setupAgentGui(final AbstractAgent agent) {
        if (!this.shuttedDown && agent.isAlive()) {
            this.getLogger().fine(() -> "Setting up GUI for " + agent);
            AgentFrame f = null;
            try {
                f = this.agentFrameConstrutor.newInstance(agent);
                agent.setupFrame(f);
            }
            catch (Exception e) {
                agent.getLogger().severeLog("Frame setup problem -> default GUI settings", e);
                f = AgentFrame.createAgentFrame(agent);
            }
            this.guis.put(agent, f);
            AgentFrame af = f;
            SwingUtilities.invokeLater(() -> {
                if (this.desktopPane != null) {
                    final JInternalFrame jf = this.buildInternalFrame(af);
                    this.desktopPane.add(jf);
                    jf.setDefaultCloseOperation(0);
                    jf.addInternalFrameListener(new InternalFrameAdapter(){

                        @Override
                        public void internalFrameClosing(InternalFrameEvent e) {
                            if (agent.isAlive()) {
                                jf.setTitle("Closing " + agent.getName());
                                AgentFrame.killAgent(agent, 2);
                            } else {
                                jf.dispose();
                            }
                        }
                    });
                    jf.setLocation(this.checkLocation(jf));
                    jf.setVisible(true);
                } else {
                    af.setLocation(this.checkLocation(af));
                    af.setVisible(true);
                }
            });
        }
    }

    private JInternalFrame buildInternalFrame(AgentFrame af) {
        JInternalFrame ijf = new JInternalFrame(af.getTitle(), true, true, true, true);
        ijf.setFrameIcon(SwingUtil.MADKIT_LOGO_SMALL);
        ijf.setSize(af.getSize());
        ijf.setLocation(af.getLocation());
        ijf.setBackground(af.getBackground());
        ijf.setContentPane(af.getContentPane());
        ijf.setJMenuBar(af.getJMenuBar());
        af.setInternalFrame(ijf);
        return ijf;
    }

    private void iconifyAll(boolean iconify) {
        int code = iconify ? 1 : 0;
        for (JFrame f : this.guis.values()) {
            f.setExtendedState(code);
        }
        if (this.myFrame != null) {
            for (JInternalFrame ijf : this.desktopPane.getAllFrames()) {
                try {
                    ijf.setIcon(iconify);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void iconifyAll() {
        this.iconifyAll(true);
    }

    private void deiconifyAll() {
        this.iconifyAll(false);
    }

    private void disposeAgentGui(AbstractAgent agent) {
        JFrame f = (JFrame)this.guis.remove(agent);
        if (f != null) {
            f.dispose();
        }
    }

    private Point checkLocation(Container c) {
        List<JInternalFrame> l;
        Dimension dim;
        if (c instanceof JInternalFrame) {
            dim = this.desktopPane.getSize();
            l = Arrays.asList(this.desktopPane.getAllFrames());
        } else {
            dim = Toolkit.getDefaultToolkit().getScreenSize();
            l = new ArrayList(this.guis.values());
        }
        Dimension size = c.getSize();
        if (size.width > dim.width) {
            size.width = dim.width;
        }
        if (size.height > dim.height) {
            size.height = dim.height;
        }
        c.setSize(size);
        dim.width -= 20;
        boolean notGood = true;
        Point location = c.getLocation();
        location.x = location.x > 0 ? location.x : 1;
        location.y = location.y > 0 ? location.y : 1;
        location.x = location.x <= dim.width ? location.x : location.x % dim.width;
        int n = location.y = location.y <= dim.height ? location.y : location.y % dim.height;
        while (notGood) {
            notGood = false;
            for (Container container : l) {
                if (container == c || !location.equals(container.getLocation())) continue;
                notGood = true;
                location.x += 20;
                location.x %= dim.width;
                location.y += 20;
                location.y %= dim.height;
            }
        }
        return location;
    }

    private void killAgents() {
        for (JFrame f : this.guis.values()) {
            f.dispose();
        }
        this.guis.clear();
    }

    private void buildUI() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.myFrame = (MDKDesktopFrame)MadkitClassLoader.getLoader().loadClass(this.getMadkitProperty(Madkit.Option.desktopFrameClass)).newInstance();
        this.desktopPane = this.myFrame.getDesktopPane();
        this.myFrame.setJMenuBar(this.myFrame.getMenuBar(this));
        JToolBar tb = this.myFrame.getToolBar(this);
        tb.setRollover(true);
        tb.setFloatable(false);
        this.myFrame.add((Component)tb, "First");
        this.myFrame.setDefaultCloseOperation(0);
        this.myFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                KernelAction.EXIT.getActionFor(GUIManagerAgent.this, new Object[0]).actionPerformed(null);
            }
        });
        this.myFrame.pack();
        this.myFrame.setVisible(true);
        this.myFrame.setExtendedState(6);
        this.myFrame.setResizable(true);
    }
}

