/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import madkit.action.ActionInfo;
import madkit.action.GUIManagerAction;
import madkit.gui.AgentFrame;
import madkit.gui.AgentStatusPanel;
import madkit.gui.OutputPanel;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.i18n.ErrorMessages;
import madkit.i18n.I18nUtilities;
import madkit.i18n.Words;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentLogger;
import madkit.kernel.CGRNotAvailable;
import madkit.kernel.ConversationID;
import madkit.kernel.FakeKernel;
import madkit.kernel.Gatekeeper;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelException;
import madkit.kernel.Madkit;
import madkit.kernel.MadkitClassLoader;
import madkit.kernel.MadkitKernel;
import madkit.kernel.Message;
import madkit.kernel.OrganizationWarning;
import madkit.kernel.Probe;
import madkit.kernel.SelfKillException;
import madkit.kernel.TerminatedKernel;
import madkit.message.ConversationFilter;
import madkit.message.EnumMessage;
import madkit.message.GUIMessage;
import madkit.message.MessageFilter;
import madkit.message.hook.HookMessage;
import madkit.util.MadkitProperties;
import madkit.util.XMLUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AbstractAgent
implements Comparable<AbstractAgent> {
    private static final transient AtomicInteger agentCounter = new AtomicInteger(0);
    static final transient MadkitKernel FAKE_KERNEL = new FakeKernel();
    private static final transient MadkitKernel TERMINATED_KERNEL = new TerminatedKernel();
    final AtomicReference<State> state = new AtomicReference<State>(State.NOT_LAUNCHED);
    transient MadkitKernel kernel = FAKE_KERNEL;
    private final int _hashCode;
    private boolean hasGUI;
    private String name;
    final AtomicBoolean alive = new AtomicBoolean();
    final BlockingDeque<Message> messageBox = new LinkedBlockingDeque<Message>();
    AgentLogger logger;
    private static final Map<Class<?>, Class<?>> primitiveTypes = new HashMap();

    public AbstractAgent() {
        this._hashCode = agentCounter.getAndIncrement();
    }

    AbstractAgent(Object fake) {
        this._hashCode = -1;
    }

    MadkitKernel getMadkitKernel() {
        return this.kernel.getMadkitKernel();
    }

    public void createGUIOnStartUp() {
        if (this.state.get().compareTo(State.ACTIVATED) < 0) {
            this.hasGUI = true;
        }
    }

    public boolean hasGUI() {
        return this.hasGUI;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final String getNetworkID() {
        return this._hashCode + "@" + this.getKernelAddress().hashCode();
    }

    public final String getSimpleNetworkID() {
        return this._hashCode + this.getKernelAddress().toString();
    }

    final AtomicBoolean getAlive() {
        return this.alive;
    }

    public boolean isAlive() {
        return this.alive.get();
    }

    private final void activationFirstStage() {
        if (!this.state.compareAndSet(State.INITIALIZING, State.ACTIVATED)) {
            throw new AssertionError((Object)"not init in activation");
        }
        this.setMyThread(Thread.currentThread());
        if (!this.alive.compareAndSet(false, true)) {
            throw new AssertionError((Object)"already alive in launch");
        }
        if (this.hasGUI) {
            if (this.logger != null) {
                this.logger.finer(() -> "** setting up  GUI **");
            }
            this.sendMessage("local", "gui", "manager", new GUIMessage(GUIManagerAction.SETUP_AGENT_GUI, this));
            try {
                this.messageBox.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.logMethod(true);
    }

    void setMyThread(Thread thread) {
        thread.setName((Object)((Object)this.getState()) + "-" + this.hashCode());
    }

    final String getAgentThreadName(State s) {
        return (Object)((Object)s) + "-" + this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ReturnCode activation() {
        ReturnCode result = ReturnCode.AGENT_CRASH;
        try {
            try {
                this.activationFirstStage();
                this.activate();
                AtomicReference<State> atomicReference = this.state;
                synchronized (atomicReference) {
                    Thread.currentThread().setName(this.getAgentThreadName(State.LIVING));
                }
                result = ReturnCode.SUCCESS;
            }
            catch (SelfKillException e) {
                this.logLifeException(e);
                this.logMethod(false);
                this.state.set(State.LIVING);
                this.suicide(e);
                return ReturnCode.SUCCESS;
            }
            catch (Throwable e) {
                this.validateDeathOnException(e, State.LIVING);
            }
        }
        catch (ThreadDeath e) {
            this.logLifeException(e);
        }
        this.logMethod(false);
        return result;
    }

    final void logMethod(boolean entering) {
        if (this.logger != null) {
            this.logger.finer(() -> "** " + (Object)((Object)(entering ? Words.ENTERING : Words.EXITING)) + " " + this.getState().lifeCycleMethod() + " **");
        }
    }

    void suicide(SelfKillException e) {
        this.getMadkitKernel().startEndBehavior(this, e.getTimeOut(), true);
    }

    protected void activate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean ending() {
        AtomicReference<State> atomicReference;
        this.state.set(State.ENDING);
        Thread.currentThread().setName(this.getAgentThreadName(State.ENDING));
        this.logMethod(true);
        try {
            atomicReference = this.state;
            synchronized (atomicReference) {
                this.state.notify();
            }
            try {
                this.end();
            }
            catch (Throwable e) {
                this.validateDeathOnException(e, State.TERMINATED);
            }
            AtomicReference<State> e = this.state;
            synchronized (e) {
                this.alive.set(false);
                Thread.currentThread().setName(this.getAgentThreadName(State.TERMINATED));
            }
        }
        catch (ThreadDeath e) {
            this.logLifeException(e);
        }
        this.logMethod(false);
        atomicReference = this.state;
        synchronized (atomicReference) {
            this.state.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDeathOnException(Throwable e, State threadNewState) {
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            this.logLifeException(e);
            Thread.currentThread().setName(this.getAgentThreadName(threadNewState));
            if (!this.alive.compareAndSet(true, false)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Thread.currentThread().setName(this.getAgentThreadName(State.TERMINATED));
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            this.state.set(State.TERMINATED);
            this.state.notify();
        }
        this.kernel = this.getMadkitKernel();
        if (this.hasGUI) {
            this.kernel.broadcastMessageWithRole(this, "local", "gui", "manager", new GUIMessage(GUIManagerAction.DISPOSE_AGENT_GUI, this), null);
        }
        try {
            this.kernel.removeAgentFromOrganizations(this);
        }
        catch (Throwable e) {
            this.logLifeException(e);
        }
        if (this.logger != null) {
            this.logger.finest(() -> "** TERMINATED **");
        }
        if (this.hasGUI) {
            AgentLogLevelMenu.remove(this);
            AgentStatusPanel.remove(this);
        }
        if (this.kernel.isHooked()) {
            this.kernel.informHooks(HookMessage.AgentActionEvent.AGENT_TERMINATED, this);
        }
        this.kernel = TERMINATED_KERNEL;
    }

    protected void end() {
    }

    public ReturnCode launchAgent(AbstractAgent agent) {
        return this.launchAgent(agent, Integer.MAX_VALUE, false);
    }

    public ReturnCode launchAgent(AbstractAgent agent, int timeOutSeconds) {
        return this.launchAgent(agent, timeOutSeconds, false);
    }

    public ReturnCode launchAgent(AbstractAgent agent, boolean createFrame) {
        return this.launchAgent(agent, Integer.MAX_VALUE, createFrame);
    }

    public ReturnCode launchAgent(AbstractAgent agent, int timeOutSeconds, boolean createFrame) {
        return this.getKernel().launchAgent(this, agent, timeOutSeconds, createFrame);
    }

    public AbstractAgent launchAgent(String agentClass) {
        return this.launchAgent(agentClass, Integer.MAX_VALUE, false);
    }

    public AbstractAgent launchAgent(String agentClass, int timeOutSeconds) {
        return this.launchAgent(agentClass, timeOutSeconds, false);
    }

    public AbstractAgent launchAgent(String agentClass, boolean createFrame) {
        return this.launchAgent(agentClass, Integer.MAX_VALUE, createFrame);
    }

    public AbstractAgent launchAgent(String agentClass, int timeOutSeconds, boolean createFrame) {
        if (this.logger != null) {
            this.logger.finest(() -> (Object)((Object)Words.LAUNCH) + " " + agentClass + " GUI " + createFrame);
        }
        try {
            Constructor<?> c = MadkitClassLoader.getLoader().loadClass(agentClass).getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            AbstractAgent a = (AbstractAgent)c.newInstance(new Object[0]);
            if (ReturnCode.SUCCESS == this.launchAgent(a, timeOutSeconds, createFrame)) {
                return a;
            }
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | KernelException e) {
            this.getLogger().severeLog(Influence.LAUNCH_AGENT.failedString(), e);
        }
        return null;
    }

    final void cannotLaunchAgent(String agentClass, Throwable e, String infos) {
        this.getLogger().severeLog((Object)((Object)ErrorMessages.CANT_LAUNCH) + " " + agentClass + " : " + (infos != null ? infos : ""), e);
    }

    public List<AbstractAgent> launchAgentBucket(String agentClass, int bucketSize, int cpuCoreNb, String ... roles) {
        if (cpuCoreNb < 1 || bucketSize < 0) {
            throw new IllegalArgumentException("launchAgentBucket : cpuCoreNb = " + cpuCoreNb + " bucketsize = " + bucketSize);
        }
        List<AbstractAgent> bucket = null;
        try {
            bucket = this.getMadkitKernel().createBucket(agentClass, bucketSize, cpuCoreNb);
            this.launchAgentBucket(bucket, cpuCoreNb, roles);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.cannotLaunchAgent(agentClass, e, null);
            return null;
        }
        return bucket;
    }

    public List<AbstractAgent> launchAgentBucket(String agentClass, int bucketSize, String ... roles) {
        return this.launchAgentBucket(agentClass, bucketSize, 1, roles);
    }

    public void launchAgentBucket(List<? extends AbstractAgent> bucket, String ... roles) {
        this.getKernel().launchAgentBucketWithRoles(this, bucket, 1, roles);
    }

    public void launchAgentBucket(List<? extends AbstractAgent> bucket, int nbOfParallelTasks, String ... roles) {
        this.getKernel().launchAgentBucketWithRoles(this, bucket, nbOfParallelTasks, roles);
    }

    public ReturnCode killAgent(AbstractAgent target) {
        return this.killAgent(target, Integer.MAX_VALUE);
    }

    public ReturnCode killAgent(AbstractAgent target, int timeOutSeconds) {
        if (target == this && Thread.currentThread().getName().equals(this.getAgentThreadName(this.getState()))) {
            if (this.logger != null) {
                this.logger.log(Level.FINEST, () -> (Object)((Object)Influence.KILL_AGENT) + " (" + timeOutSeconds + ")" + target.getName() + "...");
            }
            if (this.alive.compareAndSet(true, false)) {
                throw new SelfKillException(timeOutSeconds);
            }
        }
        return this.getKernel().killAgent(this, target, timeOutSeconds);
    }

    final MadkitKernel getKernel() {
        return this.kernel;
    }

    final void setKernel(MadkitKernel kernel) {
        this.kernel = kernel;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getClass().getSimpleName() + "-" + this._hashCode;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLogLevel(Level newLevel) {
        this.getLogger().setLevel(newLevel);
    }

    public AgentLogger getLogger() {
        if (this.logger == null) {
            this.logger = AgentLogger.getLogger(this);
        }
        return this.logger;
    }

    @Override
    public int compareTo(AbstractAgent other) {
        return this._hashCode - other._hashCode;
    }

    public ReturnCode createGroup(String community, String group) {
        return this.createGroup(community, group, false, null);
    }

    public ReturnCode createGroup(String community, String group, boolean isDistributed) {
        return this.createGroup(community, group, isDistributed, null);
    }

    public ReturnCode createGroup(String community, String group, boolean isDistributed, Gatekeeper keyMaster) {
        if (this.getState() == State.INITIALIZING) {
            this.handleWarning(Influence.CREATE_GROUP, () -> new OrganizationWarning(ReturnCode.IGNORED, community, group, null));
            return ReturnCode.IGNORED;
        }
        return this.getKernel().createGroup(this, community, group, keyMaster, isDistributed);
    }

    public ReturnCode bucketModeCreateGroup(String community, String group, boolean isDistributed, Gatekeeper keyMaster) {
        return this.kernel.createGroup(this, community, group, keyMaster, isDistributed);
    }

    public boolean createGroupIfAbsent(String community, String group) {
        return this.createGroupIfAbsent(community, group, false, null);
    }

    public boolean createGroupIfAbsent(String community, String group, boolean isDistributed) {
        return this.createGroupIfAbsent(community, group, isDistributed, null);
    }

    public boolean createGroupIfAbsent(String community, String group, boolean isDistributed, Gatekeeper keyMaster) {
        return this.getKernel().createGroupIfAbsent(this, community, group, keyMaster, isDistributed);
    }

    public ReturnCode leaveGroup(String community, String group) {
        return this.getKernel().leaveGroup(this, community, group);
    }

    public ReturnCode requestRole(String community, String group, String role) {
        return this.requestRole(community, group, role, null);
    }

    public ReturnCode requestRole(String community, String group, String role, Object passKey) {
        if (this.getState() == State.INITIALIZING) {
            this.handleWarning(Influence.REQUEST_ROLE, () -> new OrganizationWarning(ReturnCode.IGNORED, community, group, role));
            return ReturnCode.IGNORED;
        }
        return this.kernel.requestRole(this, community, group, role, passKey);
    }

    public ReturnCode bucketModeRequestRole(String community, String group, String role, Object passKey) {
        return this.kernel.requestRole(this, community, group, role, passKey);
    }

    public ReturnCode leaveRole(String community, String group, String role) {
        return this.getKernel().leaveRole(this, community, group, role);
    }

    final void handleWarning(Influence i, Supplier<Throwable> e) {
        if (this.isWarningOn()) {
            Throwable t = e.get();
            this.filterAgentStackTrace(t);
            this.logger.log(Level.WARNING, t, () -> i.failedString());
        }
    }

    final boolean isWarningOn() {
        return this.logger != null && this.logger.isCGRWarningsOn();
    }

    final void filterAgentStackTrace(Throwable e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
            String agentClassName = this.getClass().getName();
            for (int i = 0; i < stackTrace.length; ++i) {
                String trace = stackTrace[i].getClassName();
                if ((trace.startsWith("madkit.kernel") || trace.startsWith("java.") || trace.startsWith("sun.")) && !trace.contains(agentClassName)) continue;
                stack.add(stackTrace[i]);
            }
            e.setStackTrace(stack.toArray(new StackTraceElement[0]));
        }
    }

    public AgentAddress getAgentAddressIn(String community, String group, String role) {
        return this.kernel.getAgentAddressIn(this, community, group, role);
    }

    public AgentAddress getAgentWithRole(String community, String group, String role) {
        return this.getKernel().getAgentWithRole(this, community, group, role);
    }

    public AgentAddress getDistantAgentWithRole(String community, String group, String role, KernelAddress from) {
        return this.getKernel().getDistantAgentWithRole(this, community, group, role, from);
    }

    public List<AgentAddress> getAgentsWithRole(String community, String group, String role) {
        return this.getAgentsWithRole(community, group, role, false);
    }

    public List<AgentAddress> getAgentsWithRole(String community, String group, String role, boolean callerIncluded) {
        return this.getKernel().getAgentsWithRole(this, community, group, role, callerIncluded);
    }

    public Message nextMessage() {
        if (this.logger != null) {
            Message m = this.messageBox.poll();
            this.logger.finest(() -> "nextMessage = " + m);
            return m;
        }
        return this.messageBox.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message nextMessage(MessageFilter filter) {
        BlockingDeque<Message> blockingDeque = this.messageBox;
        synchronized (blockingDeque) {
            Iterator<Message> iterator = this.messageBox.iterator();
            while (iterator.hasNext()) {
                Message m = iterator.next();
                if (!filter.accept(m)) continue;
                iterator.remove();
                return m;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> nextMessages(MessageFilter filter) {
        if (filter == null) {
            BlockingDeque<Message> blockingDeque = this.messageBox;
            synchronized (blockingDeque) {
                ArrayList<Message> match = new ArrayList<Message>(this.messageBox);
                this.messageBox.clear();
                return match;
            }
        }
        ArrayList<Message> match = new ArrayList<Message>();
        BlockingDeque<Message> blockingDeque = this.messageBox;
        synchronized (blockingDeque) {
            Iterator<Message> iterator = this.messageBox.iterator();
            while (iterator.hasNext()) {
                Message m = iterator.next();
                if (!filter.accept(m)) continue;
                iterator.remove();
                match.add(m);
            }
        }
        return match;
    }

    public Message getLastReceivedMessage() {
        return (Message)this.messageBox.pollLast();
    }

    public Message getLastReceivedMessage(MessageFilter filter) {
        Iterator iterator = this.messageBox.descendingIterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            if (!filter.accept(message)) continue;
            iterator.remove();
            return message;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message purgeMailbox() {
        BlockingDeque<Message> blockingDeque = this.messageBox;
        synchronized (blockingDeque) {
            Message m = (Message)this.messageBox.pollLast();
            this.messageBox.clear();
            return m;
        }
    }

    public boolean isMessageBoxEmpty() {
        return this.messageBox.isEmpty();
    }

    public ReturnCode sendMessage(AgentAddress receiver, Message messageToSend) {
        return this.sendMessageWithRole(receiver, messageToSend, null);
    }

    public ReturnCode sendMessageWithRole(AgentAddress receiver, Message message, String senderRole) {
        return this.getKernel().sendMessage(this, receiver, message, senderRole);
    }

    public ReturnCode sendMessage(String community, String group, String role, Message message) {
        return this.sendMessageWithRole(community, group, role, message, null);
    }

    public ReturnCode sendMessageWithRole(String community, String group, String role, Message message, String senderRole) {
        return this.getKernel().sendMessage(this, community, group, role, message, senderRole);
    }

    public ReturnCode broadcastMessage(String community, String group, String role, Message message) {
        return this.broadcastMessageWithRole(community, group, role, message, null);
    }

    public ReturnCode broadcastMessageWithRole(String community, String group, String role, Message messageToSend, String senderRole) {
        return this.getKernel().broadcastMessageWithRole(this, community, group, role, messageToSend, senderRole);
    }

    public ReturnCode sendReplyWithRole(Message messageToReplyTo, Message reply, String senderRole) {
        AgentAddress target = messageToReplyTo.getSender();
        if (target == null) {
            return ReturnCode.CANT_REPLY;
        }
        reply.getIDFrom(messageToReplyTo);
        return this.getKernel().sendMessage(this, target, reply, senderRole);
    }

    public ReturnCode sendReply(Message messageToReplyTo, Message reply) {
        return this.sendReplyWithRole(messageToReplyTo, reply, null);
    }

    public Message getReplyTo(Message originalMessage) {
        return this.nextMessage(new ConversationFilter(originalMessage));
    }

    public void receiveMessage(Message m) {
        this.messageBox.offer(m);
    }

    public final String getMadkitProperty(String key) {
        return this.getMadkitConfig().getProperty(key);
    }

    public <E extends Enum<E>> String getMadkitProperty(E option) {
        return this.getMadkitProperty(option.name());
    }

    public void setMadkitProperty(String key, String value) {
        this.getMadkitConfig().setProperty(key, value);
    }

    public <E extends Enum<E>> void setMadkitProperty(E option, String value) {
        this.getMadkitConfig().setProperty(option.name(), value);
    }

    public <E extends Enum<E>> boolean isMadkitPropertyTrue(E option) {
        return Boolean.parseBoolean(this.getMadkitProperty(option));
    }

    public void setupFrame(AgentFrame frame) {
        frame.setContentPane(new OutputPanel(this));
        frame.restoreUIPreferences();
    }

    public Map<String, Map<String, Map<String, Set<AgentAddress>>>> getOrganizationSnapShot(boolean global) {
        return this.getKernel().getOrganizationSnapShot(global);
    }

    public TreeSet<String> getExistingCommunities() {
        return this.getKernel().getExistingCommunities();
    }

    public TreeSet<String> getExistingGroups(String community) {
        return this.getKernel().getExistingGroups(community);
    }

    public TreeSet<String> getMyGroups(String community) {
        return this.getKernel().getGroupsOf(this, community);
    }

    public TreeSet<String> getMyRoles(String community, String group) {
        return this.getKernel().getRolesOf(this, community, group);
    }

    public TreeSet<String> getExistingRoles(String community, String group) {
        return this.getKernel().getExistingRoles(community, group);
    }

    public boolean checkAgentAddress(AgentAddress agentAddress) {
        return this.getMadkitKernel().resolveAddress(agentAddress) != null;
    }

    public boolean isCommunity(String community) {
        return this.getKernel().isCommunity(this, community);
    }

    public boolean isGroup(String community, String group) {
        return this.getKernel().isGroup(this, community, group);
    }

    public boolean hasRole(String community, String group, String role) {
        try {
            return this.getMadkitKernel().getRole(community, group, role).contains(this);
        }
        catch (CGRNotAvailable e) {
            return false;
        }
    }

    public boolean isRole(String community, String group, String role) {
        return this.getKernel().isRole(this, community, group, role);
    }

    public String toString() {
        return this.getName() + " (" + (Object)((Object)this.getState()) + ")";
    }

    public MadkitProperties getMadkitConfig() {
        return this.getKernel().getMadkitConfig();
    }

    public KernelAddress getKernelAddress() {
        return this.kernel.getKernelAddress();
    }

    public String getServerInfo() {
        return this.getMadkitKernel().getServerInfo();
    }

    final boolean logLifeException(Throwable e) {
        if (e instanceof ThreadDeath || e instanceof IllegalMonitorStateException) {
            if (this.logger != null) {
                this.logger.finer(() -> "-*-GET KILLED in " + this.getState().lifeCycleMethod() + "-*-");
            }
        } else if (this.alive.get() || this.state.get() == State.ENDING) {
            this.getLogger().severeLog("-*-" + this.getState().lifeCycleMethod() + " BUG*-*", e);
        }
        return false;
    }

    Message waitingNextMessage(long timeout, TimeUnit unit) {
        try {
            return this.messageBox.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException();
            return null;
        }
    }

    public void destroyCommunity(String community) {
        this.getKernel().destroyCommunity(this, community);
    }

    public void destroyGroup(String community, String group) {
        this.getKernel().destroyGroup(this, community, group);
    }

    public void destroyRole(String community, String group, String role) {
        this.getKernel().destroyRole(this, community, group, role);
    }

    List<Message> waitAnswers(Message message, int size, Integer timeOutMilliSeconds) {
        Message answer;
        long endTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeOutMilliSeconds.intValue());
        ConversationID conversationID = message.getConversationID();
        int missing = size;
        ArrayList<Message> receptions = new ArrayList<Message>(this.messageBox.size());
        ArrayList<Message> answers = new ArrayList<Message>(size);
        while (missing > 0 && System.nanoTime() < endTime && (answer = this.waitingNextMessage(endTime - System.nanoTime(), TimeUnit.NANOSECONDS)) != null) {
            if (answer.getConversationID().equals(conversationID)) {
                answers.add(answer);
                --missing;
                continue;
            }
            receptions.add(answer);
        }
        this.addAllToMessageBox(receptions);
        if (!answers.isEmpty()) {
            return answers;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAllToMessageBox(List<Message> receptions) {
        BlockingDeque<Message> blockingDeque = this.messageBox;
        synchronized (blockingDeque) {
            this.messageBox.addAll(receptions);
        }
    }

    final void handleInterruptedException() {
        if (Thread.currentThread().getName().equals(this.getAgentThreadName(this.getState())) && this.alive.compareAndSet(true, false)) {
            throw new SelfKillException(0);
        }
        Thread.currentThread().interrupt();
    }

    public ReturnCode launchXmlAgents(String xmlFile) throws SAXException, IOException, ParserConfigurationException {
        NodeList nodes = XMLUtilities.getDOM(xmlFile).getElementsByTagName("Agent");
        ReturnCode r = ReturnCode.SEVERE;
        for (int i = 0; i < nodes.getLength(); ++i) {
            r = this.launchNode(nodes.item(i));
        }
        return r;
    }

    public ReturnCode launchNode(Node agentXmlNode) {
        block24: {
            if (this.logger != null) {
                this.logger.finest(() -> "launchNode " + XMLUtilities.nodeToString(agentXmlNode));
            }
            NamedNodeMap namesMap = agentXmlNode.getAttributes();
            try {
                List<AbstractAgent> list = null;
                int nbOfInstances = 1;
                try {
                    nbOfInstances = Integer.parseInt(namesMap.getNamedItem("nbOfInstances").getNodeValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list = this.getKernel().createBucket(namesMap.getNamedItem("class").getNodeValue(), nbOfInstances, 1);
                boolean bucketMode = false;
                try {
                    bucketMode = Boolean.parseBoolean(namesMap.getNamedItem("bucketMode").getNodeValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                NodeList attributes = agentXmlNode.getChildNodes();
                ArrayList<String> roles = new ArrayList<String>();
                block18: for (int i = 0; i < attributes.getLength(); ++i) {
                    Node node = attributes.item(i);
                    switch (node.getNodeName()) {
                        case "Attributes": {
                            NamedNodeMap att = node.getAttributes();
                            Class<?> agentClass = list.get(0).getClass();
                            for (int j = 0; j < att.getLength(); ++j) {
                                Node item = att.item(j);
                                this.setAgentValues(Probe.findFieldOn(agentClass, item.getNodeName()), item.getNodeValue(), list);
                            }
                            continue block18;
                        }
                        case "bucketModeRole": {
                            bucketMode = true;
                            NamedNodeMap roleAttributes = node.getAttributes();
                            roles.add(roleAttributes.item(0).getNodeValue() + "," + roleAttributes.item(1).getNodeValue() + "," + roleAttributes.item(2).getNodeValue());
                            continue block18;
                        }
                    }
                }
                if (bucketMode) {
                    this.launchAgentBucket(list, roles.toArray(new String[roles.size()]));
                    break block24;
                }
                try {
                    Level logLevel = Level.parse(namesMap.getNamedItem("logLevel").getNodeValue());
                    for (AbstractAgent abstractAgent : list) {
                        abstractAgent.setLogLevel(logLevel);
                    }
                }
                catch (NullPointerException logLevel) {
                    // empty catch block
                }
                boolean guiMode = false;
                try {
                    guiMode = Boolean.parseBoolean(namesMap.getNamedItem("GUI").getNodeValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                for (AbstractAgent abstractAgent : list) {
                    this.launchAgent(abstractAgent, 0, guiMode);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NullPointerException | NumberFormatException e) {
                this.getLogger().severeLog("launchNode " + (Object)((Object)Words.FAILED) + " : " + XMLUtilities.nodeToString(agentXmlNode), e);
                return ReturnCode.SEVERE;
            }
        }
        return ReturnCode.SUCCESS;
    }

    private void setAgentValues(Field f, String stringValue, List<AbstractAgent> l) throws IllegalAccessException {
        Class<?> type = f.getType();
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                int value = Integer.parseInt(stringValue);
                for (AbstractAgent a : l) {
                    f.setInt(a, value);
                }
            } else if (type == Boolean.TYPE) {
                boolean value = Boolean.parseBoolean(stringValue);
                for (AbstractAgent a : l) {
                    f.setBoolean(a, value);
                }
            } else if (type == Float.TYPE) {
                float value = Float.parseFloat(stringValue);
                for (AbstractAgent a : l) {
                    f.setFloat(a, value);
                }
            } else if (type == Double.TYPE) {
                double value = Double.parseDouble(stringValue);
                for (AbstractAgent a : l) {
                    f.setDouble(a, value);
                }
            } else if (type == Byte.TYPE) {
                byte value = Byte.parseByte(stringValue);
                for (AbstractAgent a : l) {
                    f.setByte(a, value);
                }
            } else if (type == Short.TYPE) {
                short value = Short.parseShort(stringValue);
                for (AbstractAgent a : l) {
                    f.setShort(a, value);
                }
            } else if (type == Long.TYPE) {
                long value = Long.parseLong(stringValue);
                for (AbstractAgent a : l) {
                    f.setLong(a, value);
                }
            }
        } else if (type == Integer.class) {
            int value = Integer.parseInt(stringValue);
            for (AbstractAgent a : l) {
                f.set(a, value);
            }
        } else if (type == Boolean.class) {
            boolean value = Boolean.parseBoolean(stringValue);
            for (AbstractAgent a : l) {
                f.set(a, value);
            }
        } else if (type == Float.class) {
            float value = Float.parseFloat(stringValue);
            for (AbstractAgent a : l) {
                f.set(a, Float.valueOf(value));
            }
        } else if (type == Double.class) {
            double value = Double.parseDouble(stringValue);
            for (AbstractAgent a : l) {
                f.set(a, value);
            }
        } else if (type == String.class) {
            for (AbstractAgent a : l) {
                f.set(a, stringValue);
            }
        } else if (type == Byte.class) {
            byte value = Byte.parseByte(stringValue);
            for (AbstractAgent a : l) {
                f.set(a, value);
            }
        } else if (type == Short.class) {
            short value = Short.parseShort(stringValue);
            for (AbstractAgent a : l) {
                f.set(a, value);
            }
        } else if (type == Long.class) {
            long value = Long.parseLong(stringValue);
            for (AbstractAgent a : l) {
                f.set(a, value);
            }
        } else if (this.logger != null) {
            this.logger.severe(() -> "Do not know how to change attrib " + stringValue);
        }
    }

    public State getState() {
        return this.state.get();
    }

    public void reload() {
        try {
            MadkitClassLoader.reloadClass(this.getClass().getName());
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severeLog("", e);
        }
        this.launchAgent(this.getClass().getName(), 0, true);
        this.killAgent(this);
    }

    public <E extends Enum<E>> void proceedEnumMessage(EnumMessage<E> message) {
        if (this.logger != null) {
            this.logger.finest(() -> "proceeding command message " + message);
        }
        Object[] parameters = (Object[])message.getContent();
        Method m = null;
        try {
            m = this.findMethodFromParameters(ActionInfo.enumToMethodName(message.getCode()), parameters);
            m.invoke((Object)this, parameters);
        }
        catch (Error e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            if (this.logger != null) {
                this.logger.warning(() -> "I do not know how to " + ActionInfo.enumToMethodName(message.getCode()) + Arrays.deepToString(parameters));
            }
            this.logForSender(() -> "I have sent a message which has not been understood", message);
        }
        catch (IllegalArgumentException e) {
            if (this.logger != null) {
                this.logger.warning("Cannot proceed message : wrong argument " + m);
            }
            this.logForSender(() -> "I have sent an incorrect command message ", message);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof SelfKillException) {
                throw (SelfKillException)t;
            }
            t.printStackTrace();
        }
    }

    private void logForSender(Supplier<String> msg, EnumMessage<?> cm) {
        try {
            cm.getSender().getAgent().logger.warning(() -> (String)msg.get() + cm);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private Method findMethodFromParameters(String name2, Object[] parameters) throws NoSuchMethodException {
        Class<?>[] types = this.convertToObjectTypes(this.convertToTypes(parameters));
        Method m = this.findMethodIn(name2, this.getClass().getMethods(), types);
        if (m == null && (m = this.findMethodIn(name2, this.getClass().getDeclaredMethods(), types)) != null) {
            m.setAccessible(true);
        }
        if (m == null) {
            throw new NoSuchMethodException();
        }
        return m;
    }

    private Class<?>[] convertToObjectTypes(Class<?>[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> paramCl = parameters[i];
            if (paramCl == null || !paramCl.isPrimitive()) continue;
            parameters[i] = primitiveTypes.get(paramCl);
        }
        return parameters;
    }

    private Class<?>[] convertToTypes(Object[] parameters) {
        Class[] paramClasses = new Class[parameters.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            if (parameters[i] == null) continue;
            paramClasses[i] = parameters[i].getClass();
        }
        return paramClasses;
    }

    private Method findMethodIn(String name2, Method[] methods, Class<?>[] parameters) {
        for (Method method : methods) {
            if (!method.getName().equals(name2) || !this.checkArgumentTypes(this.convertToObjectTypes(method.getParameterTypes()), parameters)) continue;
            return method;
        }
        return null;
    }

    private boolean checkArgumentTypes(Class<?>[] types, Class<?>[] parameters) {
        if (parameters.length == types.length) {
            for (int i = 0; i < types.length; ++i) {
                if (parameters[i] == null || types[i].isAssignableFrom(parameters[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isKernelOnline() {
        return this.getMadkitKernel().isRole(this, "NetworK", "MDK_net", "MDK net agent");
    }

    protected static Madkit executeThisAgent(int nbOfInstances, boolean createFrame, String ... args) {
        StackTraceElement element = null;
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            if (!stackTraceElement.getMethodName().equals("main")) continue;
            element = stackTraceElement;
            break;
        }
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(Madkit.Option.launchAgents.toString(), element.getClassName() + "," + createFrame + "," + nbOfInstances));
        if (args != null) {
            arguments.addAll(Arrays.asList(args));
        }
        return new Madkit(arguments.toArray(new String[arguments.size()]));
    }

    protected static Madkit executeThisAgent(String ... args) {
        return AbstractAgent.executeThisAgent(1, true, args);
    }

    protected static Madkit executeThisAgent() {
        return AbstractAgent.executeThisAgent(1, true, new String[0]);
    }

    static {
        primitiveTypes.put(Integer.TYPE, Integer.class);
        primitiveTypes.put(Boolean.TYPE, Boolean.class);
        primitiveTypes.put(Byte.TYPE, Byte.class);
        primitiveTypes.put(Character.TYPE, Character.class);
        primitiveTypes.put(Float.TYPE, Float.class);
        primitiveTypes.put(Void.TYPE, Void.class);
        primitiveTypes.put(Short.TYPE, Short.class);
        primitiveTypes.put(Double.TYPE, Double.class);
        primitiveTypes.put(Long.TYPE, Long.class);
    }

    static enum Influence {
        CREATE_GROUP,
        REQUEST_ROLE,
        LEAVE_ROLE,
        LEAVE_GROUP,
        GET_AGENTS_WITH_ROLE,
        GET_AGENT_WITH_ROLE,
        SEND_MESSAGE,
        BROADCAST_MESSAGE,
        BROADCAST_MESSAGE_AND_WAIT,
        LAUNCH_AGENT,
        KILL_AGENT,
        GET_AGENT_ADDRESS_IN,
        RELOAD_CLASS;


        public String failedString() {
            return this.toString() + (Object)((Object)Words.FAILED) + " : ";
        }

        public String toString() {
            return this.name() + " ";
        }

        String successString() {
            return this.toString() + (Object)((Object)ReturnCode.SUCCESS) + " : ";
        }
    }

    public static enum ReturnCode {
        SUCCESS,
        NOT_COMMUNITY,
        NOT_GROUP,
        NOT_ROLE,
        NOT_IN_GROUP,
        ROLE_ALREADY_HANDLED,
        ACCESS_DENIED,
        ROLE_NOT_HANDLED,
        ALREADY_GROUP,
        ALREADY_LAUNCHED,
        TIMEOUT,
        AGENT_CRASH,
        NOT_YET_LAUNCHED,
        ALREADY_KILLED,
        INVALID_AGENT_ADDRESS,
        NO_RECIPIENT_FOUND,
        IGNORED,
        CANT_REPLY,
        SEVERE;

        static final ResourceBundle messages;

        public String toString() {
            return messages.getString(this.name());
        }

        static {
            messages = I18nUtilities.getResourceBundle(ReturnCode.class.getSimpleName());
        }
    }

    public static enum State {
        NOT_LAUNCHED,
        INITIALIZING,
        ACTIVATED,
        LIVING,
        ENDING,
        TERMINATED;


        final String lifeCycleMethod() {
            switch (this) {
                case ACTIVATED: {
                    return "ACTIVATE";
                }
                case LIVING: {
                    return "LIVE";
                }
                case TERMINATED: {
                    return "TERMINATE";
                }
                case ENDING: {
                    return "END";
                }
            }
            return this.name();
        }
    }
}

