/*
 * Decompiled with CFR 0.152.
 */
package madkit.action;

import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import madkit.action.ActionInfo;
import madkit.action.MDKAbstractAction;

public class BooleanAction
extends MDKAbstractAction {
    private static final long serialVersionUID = -8640665654876640983L;
    private static final Preferences BOOLEAN_PREFERENCES = Preferences.userRoot().node(BooleanAction.class.getName());
    private static AtomicInteger instancesCount = new AtomicInteger(0);
    private final String keyId = this.getValue("ActionCommandKey").toString() + instancesCount.incrementAndGet();

    public BooleanAction(ActionInfo actionInfo) {
        super(actionInfo);
        this.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("SwingSelectedKey")) {
                boolean isSelected = (Boolean)this.getValue("SwingSelectedKey");
                BOOLEAN_PREFERENCES.putBoolean(this.keyId, isSelected);
                this.onUpdate(isSelected);
            }
        });
        this.restoreSelectedKeyPreference();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            this.putValue("SwingSelectedKey", (Boolean)this.getValue("SwingSelectedKey") == false);
        }
    }

    public void restoreSelectedKeyPreference() {
        this.putValue("SwingSelectedKey", BOOLEAN_PREFERENCES.getBoolean(this.keyId, false));
    }

    public void onUpdate(boolean isSelected) {
    }

    public String toString() {
        return "action: " + this.getValue("ActionCommandKey") + ": " + this.getValue("SwingSelectedKey");
    }
}

