/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import madkit.action.KernelAction;
import madkit.kernel.Madkit;
import madkit.kernel.NetCode;
import madkit.kernel.NetworkAgent;
import madkit.kernel.NetworkMessage;
import madkit.message.KernelMessage;

final class KernelServer {
    private static final int startingPort = 4444;
    private final ServerSocket serverSocket;
    private boolean running = true;
    private static final String EXTERNAL_IP;

    private KernelServer(ServerSocket serverSocket2) {
        this.serverSocket = serverSocket2;
    }

    void activate(final NetworkAgent netAgent) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (KernelServer.this.running) {
                    try {
                        netAgent.receiveMessage(new NetworkMessage(NetCode.NEW_PEER_REQUEST, KernelServer.this.serverSocket.accept()));
                    }
                    catch (IOException e) {
                        if (!KernelServer.this.running) break;
                        netAgent.receiveMessage(new KernelMessage(KernelAction.EXIT, new Object[0]));
                        break;
                    }
                }
                KernelServer.this.stop();
            }
        });
        t.setName("MK Server " + netAgent.getName());
        t.start();
    }

    int getPort() {
        return this.serverSocket.getLocalPort();
    }

    InetAddress getIp() {
        return this.serverSocket.getInetAddress();
    }

    void stop() {
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static final KernelServer getNewKernelServer() {
        InetAddress ip = KernelServer.findInetAddress();
        if (ip == null) {
            try {
                ip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        ServerSocket serverSocket = null;
        int port = 4444;
        while (serverSocket == null) {
            try {
                serverSocket = new ServerSocket(port, 50, ip);
            }
            catch (IOException e) {
                ++port;
            }
        }
        return new KernelServer(serverSocket);
    }

    public String toString() {
        return this.getIp() + ":" + this.getPort() + EXTERNAL_IP;
    }

    private static InetAddress findInetAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                if (ni.isLoopback()) continue;
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    if (ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    return ia;
                }
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    static {
        String s = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(Madkit.WEB + "/whatismyip.php").openStream()));
            s = in.readLine();
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EXTERNAL_IP = s == null ? "" : " -- WAN : " + s;
    }
}

