/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.awt.Point;
import java.util.List;
import madkit.bees.AbstractBee;
import madkit.bees.BeeInformation;
import madkit.kernel.AgentAddress;
import madkit.message.ObjectMessage;

public class Bee
extends AbstractBee {
    private static final long serialVersionUID = -2393301912353816186L;
    BeeInformation leaderInfo = null;
    AgentAddress leader = null;

    @Override
    public void buzz() {
        this.updateLeader();
        super.buzz();
    }

    @Override
    protected void computeNewVelocities() {
        int n;
        int n2;
        Point point = this.myInformation.getCurrentPosition();
        int n3 = 0;
        if (this.beeWorld != null) {
            n3 = this.beeWorld.getBeeAcceleration().getValue();
        }
        if (this.leaderInfo != null) {
            Point point2 = this.leaderInfo.getCurrentPosition();
            if (this.logger != null) {
                this.logger.finer("following leader :" + point2);
            }
            n2 = point2.x - point.x;
            n = point2.y - point.y;
        } else {
            n2 = generator.nextInt(5);
            n = generator.nextInt(5);
            if (generator.nextBoolean()) {
                n2 = -n2;
                n = -n;
            }
        }
        int n4 = Math.abs(n2) + Math.abs(n);
        if (n4 == 0) {
            n4 = 1;
        }
        this.dX += n2 * n3 / n4 + this.randomFromRange(2);
        this.dY += n * n3 / n4 + this.randomFromRange(2);
    }

    private void updateLeader() {
        ObjectMessage objectMessage = (ObjectMessage)this.nextMessage();
        if (objectMessage == null) {
            return;
        }
        if (objectMessage.getSender().equals(this.leader)) {
            if (this.logger != null) {
                this.logger.info("my leader is getting out of the game");
            }
            this.leader = null;
            this.leaderInfo = null;
        } else {
            if (this.logger != null) {
                this.logger.fine("A leader has appeared or disappeared ");
            }
            if (this.leader == null) {
                this.followNewLeader(objectMessage);
            } else {
                List<AgentAddress> list = this.getAgentsWithRole("buzz", "bees", "queen");
                if (list != null && generator.nextDouble() < 1.0 / (double)list.size()) {
                    this.followNewLeader(objectMessage);
                }
            }
        }
    }

    private void followNewLeader(ObjectMessage<BeeInformation> objectMessage) {
        this.leader = objectMessage.getSender();
        this.leaderInfo = objectMessage.getContent();
        this.myInformation.setBeeColor(this.leaderInfo.getBeeColor());
    }

    @Override
    public void activate() {
        this.requestRole("buzz", "bees", "bee", null);
        this.requestRole("buzz", "bees", "follower", null);
    }

    @Override
    protected int getMaxVelocity() {
        if (this.beeWorld != null) {
            return this.beeWorld.getBeeVelocity().getValue();
        }
        return 0;
    }
}

