/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.awt.Point;
import java.util.Random;
import madkit.bees.BeeEnvironment;
import madkit.bees.BeeInformation;
import madkit.kernel.AbstractAgent;

public abstract class AbstractBee
extends AbstractAgent {
    private static final long serialVersionUID = -3781069534623890714L;
    protected static final Random generator = new Random(System.currentTimeMillis());
    public BeeInformation myInformation = new BeeInformation();
    protected int dX;
    protected int dY;
    protected BeeEnvironment beeWorld;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " on " + this.beeWorld + " " + this.myInformation;
    }

    protected void buzz() {
        Point point = this.myInformation.getCurrentPosition();
        this.myInformation.getPreviousPosition().setLocation(point);
        this.computeNewVelocities();
        this.normalizeVelocities(this.getMaxVelocity());
        point.x += this.dX;
        point.y += this.dY;
    }

    protected abstract int getMaxVelocity();

    protected abstract void computeNewVelocities();

    private void normalizeVelocities(int n) {
        if (this.dX > n) {
            this.dX = n;
        } else if (this.dX < -n) {
            this.dX = -n;
        }
        if (this.dY > n) {
            this.dY = n;
        } else if (this.dY < -n) {
            this.dY = -n;
        }
    }

    public int randomFromRange(int n) {
        return generator.nextInt((n /= 2) * 2 + 1) - n;
    }

    public void setEnvironment(BeeEnvironment beeEnvironment) {
        this.beeWorld = beeEnvironment;
        Point point = this.myInformation.getCurrentPosition();
        if (point.x > this.beeWorld.getWidth() || point.y > this.beeWorld.getHeight() || point.x <= 0 || point.y <= 0) {
            point.setLocation(generator.nextInt(this.beeWorld.getWidth() - 20) + 10, generator.nextInt(this.beeWorld.getHeight() - 20) + 10);
            this.myInformation.getPreviousPosition().setLocation(point);
        }
        int n = this.beeWorld.getBeeAcceleration().getValue();
        this.dX = this.randomFromRange(n);
        this.dY = this.randomFromRange(n);
    }
}

