/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import madkit.kernel.AbstractAgent;
import madkit.kernel.MadkitKernel;
import madkit.kernel.Overlooker;

public abstract class Activator<A extends AbstractAgent>
extends Overlooker<A> {
    private int nbOfsimultaneousTasks = 1;

    public Activator(String community, String group, String role) {
        super(community, group, role);
    }

    public void execute(Object ... args) {
        if (this.isMulticoreModeOn()) {
            this.multicoreExecute(new Object[0]);
        } else {
            this.execute(this.getCurrentAgentsList(), args);
        }
    }

    public abstract void execute(List<A> var1, Object ... var2);

    protected void multicoreExecute(final Object ... args) {
        final int cpuCoreNb = this.nbOfParallelTasks();
        ArrayList<Callable<Void>> workers = new ArrayList<Callable<Void>>(cpuCoreNb);
        final List list = this.getCurrentAgentsList();
        int bucketSize = list.size();
        final int nbOfAgentsPerTask = bucketSize / cpuCoreNb;
        int i = 0;
        while (i < cpuCoreNb) {
            final int index = i++;
            workers.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int firstIndex = nbOfAgentsPerTask * index;
                    Activator.this.execute(list.subList(firstIndex, firstIndex + nbOfAgentsPerTask), args);
                    return null;
                }
            });
        }
        workers.add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Activator.this.execute(list.subList(nbOfAgentsPerTask * cpuCoreNb, list.size()), args);
                return null;
            }
        });
        try {
            Activator.getMadkitServiceExecutor().invokeAll(workers);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String toString() {
        return super.toString() + (this.isMulticoreModeOn() ? " multicore mode " : "");
    }

    public boolean isMulticoreModeOn() {
        return this.nbOfsimultaneousTasks > 1;
    }

    public void useMulticore(int nbOfParallelTasks) {
        this.nbOfsimultaneousTasks = nbOfParallelTasks < 2 ? 1 : nbOfParallelTasks;
    }

    public int nbOfParallelTasks() {
        return this.nbOfsimultaneousTasks;
    }

    public static ExecutorService getMadkitServiceExecutor() {
        return MadkitKernel.getMadkitServiceExecutor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Method findMethodOn(Class<T> agentClass, String methodName) throws NoSuchMethodException {
        while (true) {
            try {
                Method m;
                while ((m = agentClass.getDeclaredMethod(methodName, new Class[0])) == null) {
                }
                if (m.isAccessible()) return m;
                m.setAccessible(true);
                return m;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                if ((agentClass = agentClass.getSuperclass()) == AbstractAgent.class) throw e;
                continue;
            }
            break;
        }
    }
}

