/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import madkit.action.KernelAction;
import madkit.gui.AgentStatusPanel;
import madkit.gui.SwingUtil;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.gui.menu.AgentMenu;
import madkit.gui.menu.HelpMenu;
import madkit.gui.menu.MadkitMenu;
import madkit.kernel.AbstractAgent;
import madkit.message.KernelMessage;

public class AgentFrame
extends JFrame {
    private static final long serialVersionUID = 6337250099157352055L;
    private JInternalFrame internalFrame;
    private final AbstractAgent agent;

    protected AgentFrame(final AbstractAgent agent) {
        super(agent.getName());
        this.agent = agent;
        this.setIconImage(SwingUtil.MADKIT_LOGO.getImage());
        this.setJMenuBar(this.createMenuBar());
        JToolBar tb = this.createJToolBar();
        if (tb != null) {
            this.add((Component)tb, "First");
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                this.closeProcess();
            }

            private void closeProcess() {
                if (agent.isAlive()) {
                    AgentFrame.this.setTitle("Closing " + agent.getName());
                    AgentFrame.killAgent(agent, 4);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.closeProcess();
            }
        });
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void dispose() {
        if (this.internalFrame != null) {
            this.internalFrame.dispose();
        }
        super.dispose();
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new MadkitMenu(this.agent));
        menuBar.add(new AgentMenu(this.agent));
        menuBar.add(new AgentLogLevelMenu(this.agent));
        menuBar.add(new HelpMenu());
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(new AgentStatusPanel(this.agent));
        return menuBar;
    }

    public JToolBar createJToolBar() {
        return null;
    }

    void setInternalFrame(JInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        if (this.internalFrame != null) {
            this.internalFrame.setLocation(x, y);
        }
    }

    @Override
    public void pack() {
        super.pack();
        if (this.internalFrame != null) {
            this.internalFrame.pack();
        }
    }

    static void killAgent(AbstractAgent agent, int timeOutSeconds) {
        if (agent.isAlive()) {
            agent.sendMessage("local", "system", "manager", new KernelMessage(KernelAction.KILL_AGENT, agent, timeOutSeconds));
        }
    }

    public AbstractAgent getAgent() {
        return this.agent;
    }

    public static AgentFrame createAgentFrame(AbstractAgent agent) {
        return new AgentFrame(agent);
    }
}

