/*
 * Decompiled with CFR 0.152.
 */
package madkit.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import madkit.action.ActionInfo;
import madkit.action.MDKAbstractAction;
import madkit.gui.SwingUtil;
import madkit.i18n.ErrorMessages;
import madkit.i18n.I18nUtilities;
import madkit.i18n.Words;
import madkit.kernel.AgentLogger;
import madkit.kernel.Madkit;
import madkit.kernel.MadkitClassLoader;

public class GlobalAction {
    private static final ResourceBundle messages = I18nUtilities.getResourceBundle(GlobalAction.class.getSimpleName());
    public static final Action JCONSOLE;
    public static final Action DEBUG;
    public static final Action LOG_FILES;
    public static final Action LAUNCH_MAIN;
    public static final Action LOAD_JAR_FILE;
    public static final Action LOAD_LOCAL_DEMOS;
    public static final Action LAUNCH_MDK_CONFIG;

    static {
        final String jconsolePath = MadkitClassLoader.findJavaExecutable("jconsole");
        JCONSOLE = jconsolePath == null ? null : new MDKAbstractAction(new ActionInfo("JCONSOLE", 76, messages)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String pid = ManagementFactory.getRuntimeMXBean().getName();
                try {
                    new ProcessBuilder(jconsolePath, pid.substring(0, pid.indexOf(64))).start();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        DEBUG = new MDKAbstractAction(new ActionInfo("DEBUG", 68, messages)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e == null) {
                    this.putValue("SwingSelectedKey", (Boolean)this.getValue("SwingSelectedKey") == false);
                }
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    AgentLogger.setAllLogLevels(Level.ALL);
                } else {
                    AgentLogger.setAllLogLevels(Level.INFO);
                }
            }
        };
        ActionInfo actionInfo = new ActionInfo("LOG_FILES", 70, messages);
        actionInfo.setIcon("LOG_LEVEL");
        LOG_FILES = new MDKAbstractAction(actionInfo){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AgentLogger.createLogFiles();
            }
        };
        final String[] params = null;
        ActionInfo actionInfo2 = new ActionInfo("LAUNCH_MAIN", 515, messages);
        LAUNCH_MAIN = new MDKAbstractAction(actionInfo2){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MadkitClassLoader.getLoader().loadClass(e.getActionCommand()).getDeclaredMethod("main", String[].class).invoke(null, new Object[]{params});
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
        };
        LAUNCH_MAIN.putValue("SmallIcon", SwingUtil.MADKIT_LOGO_SMALL);
        LOAD_JAR_FILE = new MDKAbstractAction(new ActionInfo("LOAD_JAR_FILE", 74, messages)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                chooser.setFileFilter(new FileNameExtensionFilter("Jar file", "jar"));
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        MadkitClassLoader.loadUrl(chooser.getSelectedFile().toURI().toURL());
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        LOAD_LOCAL_DEMOS = new MDKAbstractAction(new ActionInfo("LOAD_LOCAL_DEMOS", 83, messages)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = new File("demos");
                if (!f.exists() || !f.isDirectory()) {
                    for (URL url : MadkitClassLoader.getLoader().getURLs()) {
                        System.err.println(url);
                        if (!url.getFile().endsWith("madkit-" + Madkit.VERSION + ".jar")) continue;
                        try {
                            f = new File(Paths.get(url.toURI()).getParent().toString(), "demos");
                            break;
                        }
                        catch (URISyntaxException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (f.exists() && f.isDirectory()) {
                    if (!MadkitClassLoader.loadJarsFromDirectory(f.getAbsolutePath())) {
                        JOptionPane.showMessageDialog(null, f.getAbsolutePath() + " : no new resources found", this.getValue("Name").toString(), 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, f.getAbsolutePath() + " " + (Object)((Object)Words.DIRECTORY) + " " + (Object)((Object)ErrorMessages.CANT_FIND), this.getValue("Name").toString(), 2);
                }
            }
        };
        actionInfo = new ActionInfo("LAUNCH_MDK_CONFIG", 515, messages);
        LAUNCH_MDK_CONFIG = new MDKAbstractAction(actionInfo){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new Madkit(Madkit.Option.configFile.toString(), e.getActionCommand());
            }
        };
        LAUNCH_MAIN.putValue("SmallIcon", SwingUtil.MADKIT_LOGO_SMALL);
    }
}

