/*
 * Decompiled with CFR 0.152.
 */
package madkit.message;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import madkit.kernel.AgentAddress;
import madkit.message.ActMessage;

public class ACLMessage
extends ActMessage {
    private static final long serialVersionUID = -6750319187360080985L;
    public static final int ACCEPT_PROPOSAL = 0;
    public static final int AGREE = 1;
    public static final int CANCEL = 2;
    public static final int CFP = 3;
    public static final int CONFIRM = 4;
    public static final int DISCONFIRM = 5;
    public static final int FAILURE = 6;
    public static final int INFORM = 7;
    public static final int INFORM_IF = 8;
    public static final int INFORM_REF = 9;
    public static final int NOT_UNDERSTOOD = 10;
    public static final int PROPOSE = 11;
    public static final int QUERY_IF = 12;
    public static final int QUERY_REF = 13;
    public static final int REFUSE = 14;
    public static final int REJECT_PROPOSAL = 15;
    public static final int REQUEST = 16;
    public static final int REQUEST_WHEN = 17;
    public static final int REQUEST_WHENEVER = 18;
    public static final int SUBSCRIBE = 19;
    public static final int PROXY = 20;
    public static final int PROPAGATE = 21;
    public static final int UNKNOWN = -1;
    public static final String ACCEPT_PROPOSAL_STRING = "ACCEPT-PROPOSAL";
    public static final String AGREE_STRING = "AGREE";
    public static final String CANCEL_STRING = "CANCEL";
    public static final String CFP_STRING = "CFP";
    public static final String CONFIRM_STRING = "CONFIRMP";
    public static final String DISCONFIRM_STRING = "DISCONFIRM";
    public static final String FAILURE_STRING = "FAILURE";
    public static final String INFORM_STRING = "INFORM";
    public static final String INFORM_IF_STRING = "INFORM-IF";
    public static final String INFORM_REF_STRING = "INFORM-REF";
    public static final String NOT_UNDERSTOOD_STRING = "NOT-UNDERSTOOD";
    public static final String PROPOSE_STRING = "PROPOSE";
    public static final String QUERY_IF_STRING = "QUERY-IF";
    public static final String QUERY_REF_STRING = "QUERY-REF";
    public static final String REFUSE_STRING = "REFUSE";
    public static final String REJECT_PROPOSAL_STRING = "REJECT-PROPOSAL";
    public static final String REQUEST_STRING = "REQUEST";
    public static final String REQUEST_WHEN_STRING = "REQUEST-WHEN";
    public static final String REQUEST_WHENEVER_STRING = "REQUEST-WHENEVER";
    public static final String SUBSCRIBE_STRING = "SUBSCRIBE";
    public static final String PROXY_STRING = "PROXY";
    public static final String PROPAGATE_STRING = "PROPAGATE";
    private static final String SENDER_KEY = ":sender";
    private static final String RECEIVER_KEY = ":receiver";
    private static final String CONTENT_KEY = ":content";
    private static final String REPLY_WITH_KEY = ":reply-with";
    private static final String IN_REPLY_TO_KEY = ":in-reply-to";
    private static final String REPLY_BY_KEY = ":reply-by";
    private static final String LANGUAGE_KEY = ":language";
    private static final String ENCODING_KEY = ":encoding";
    private static final String ONTOLOGY_KEY = ":ontology";
    private static final String PROTOCOL_KEY = ":protocol";
    private static final String CONVERSATION_ID_KEY = ":conversation-id";
    private static final String ENVELOPE_KEY = ":envelope";
    public static final List<String> performatives = new ArrayList<String>(22);
    private final ArrayList<AgentAddress> dests = new ArrayList();
    private final ArrayList<AgentAddress> reply_to = new ArrayList();

    public ACLMessage() {
        super(NOT_UNDERSTOOD_STRING);
    }

    public ACLMessage(String actType) {
        super(actType.toUpperCase());
    }

    public ACLMessage(String actType, String cont) {
        super(actType.toUpperCase(), cont);
    }

    public ACLMessage(int perf, String cont) {
        super(performatives.get(perf), cont);
    }

    public String getAct() {
        return this.action;
    }

    @Override
    public void setContent(String s) {
        this.setField("content", s);
    }

    public String getPerformative() {
        return this.getAct();
    }

    public void setPerformative(String s) {
        this.action = s;
    }

    public void addReceiver(AgentAddress r) {
        if (r != null) {
            this.dests.add(r);
        }
    }

    public List<AgentAddress> getReceivers() {
        return this.dests;
    }

    public boolean removeReceiver(AgentAddress r) {
        if (r != null) {
            return this.dests.remove(r);
        }
        return false;
    }

    public void clearAllReceiver() {
        this.dests.clear();
    }

    public void addReplyTo(AgentAddress dest) {
        if (dest != null) {
            this.reply_to.add(dest);
        }
    }

    public boolean removeReplyTo(AgentAddress dest) {
        if (dest != null) {
            return this.reply_to.remove(dest);
        }
        return false;
    }

    public void clearAllReplyTo() {
        this.reply_to.clear();
    }

    public String getEnvelope() {
        return (String)this.getFieldValue(ENVELOPE_KEY);
    }

    public void setEnvelope(String s) {
        this.setField(ENVELOPE_KEY, s);
    }

    public String getConversationIDentifier() {
        return (String)this.getFieldValue(CONVERSATION_ID_KEY);
    }

    public void setConversationID(String s) {
        this.setField(CONVERSATION_ID_KEY, s);
    }

    public String getProtocol() {
        return (String)this.getFieldValue(PROTOCOL_KEY);
    }

    public void setProtocol(String s) {
        this.setField(PROTOCOL_KEY, s);
    }

    public String getReplyWith() {
        return (String)this.getFieldValue(REPLY_WITH_KEY);
    }

    public void setReplyWith(String s) {
        this.setField(REPLY_WITH_KEY, s);
    }

    public String getReplyBy() {
        return (String)this.getFieldValue(REPLY_BY_KEY);
    }

    public void setReplyBy(String s) {
        this.setField(REPLY_BY_KEY, s);
    }

    public void setReplyBy(Date s) {
        this.setField(REPLY_BY_KEY, s.toString());
    }

    @Override
    public String getInReplyTo() {
        return (String)this.getFieldValue(IN_REPLY_TO_KEY);
    }

    @Override
    public void setInReplyTo(String s) {
        this.setField(IN_REPLY_TO_KEY, s);
    }

    public String getLanguage() {
        return (String)this.getFieldValue(LANGUAGE_KEY);
    }

    public void setLanguage(String s) {
        this.setField(LANGUAGE_KEY, s);
    }

    public String getEncoding() {
        return (String)this.getFieldValue(ENCODING_KEY);
    }

    public void setEncoding(String s) {
        this.setField(ENCODING_KEY, s);
    }

    public String getOntology() {
        return (String)this.getFieldValue(ONTOLOGY_KEY);
    }

    public void setOntology(String s) {
        this.setField(ONTOLOGY_KEY, s);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(" + this.getAct() + " ");
        if (this.getSender() != null) {
            buffer.append(":sender " + this.getSender());
        }
        if (this.getReceiver() != null) {
            buffer.append(" :receiver " + this.getReceiver());
        }
        if (this.content != null && this.content.length() > 0) {
            buffer.append(" :content " + this.content + "\n");
        }
        buffer.append(")");
        return new String(buffer);
    }

    public ACLMessage createReply() {
        ACLMessage m = new ACLMessage();
        if (this.reply_to.isEmpty()) {
            m.addReceiver(this.getSender());
        } else {
            Iterator<AgentAddress> it = this.reply_to.iterator();
            while (it.hasNext()) {
                m.addReceiver(it.next());
            }
        }
        return m;
    }

    static {
        performatives.add(ACCEPT_PROPOSAL_STRING);
        performatives.add(AGREE_STRING);
        performatives.add(CANCEL_STRING);
        performatives.add(CFP_STRING);
        performatives.add("CONFIRM");
        performatives.add(DISCONFIRM_STRING);
        performatives.add(FAILURE_STRING);
        performatives.add(INFORM_STRING);
        performatives.add(INFORM_IF_STRING);
        performatives.add(INFORM_REF_STRING);
        performatives.add(NOT_UNDERSTOOD_STRING);
        performatives.add(PROPOSE_STRING);
        performatives.add(QUERY_IF_STRING);
        performatives.add(QUERY_REF_STRING);
        performatives.add(REFUSE_STRING);
        performatives.add(REJECT_PROPOSAL_STRING);
        performatives.add(REQUEST_STRING);
        performatives.add(REQUEST_WHEN_STRING);
        performatives.add(REQUEST_WHENEVER_STRING);
        performatives.add(SUBSCRIBE_STRING);
        performatives.add(PROXY_STRING);
        performatives.add(PROPAGATE_STRING);
    }
}

