/*
 * Decompiled with CFR 0.152.
 */
package madkit.marketorg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.gui.OutputPanel;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.message.IntegerMessage;
import madkit.message.StringMessage;

public class Provider
extends Agent {
    private static final long serialVersionUID = 9125493540160734521L;
    public static List<String> availableTransports = Arrays.asList("train", "boat", "plane", "bus");
    private static final Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    private static int nbOfProvidersOnScreen;
    private String competence = availableTransports.get((int)(Math.random() * (double)availableTransports.size()));
    private JPanel blinkPanel;

    @Override
    public void activate() {
        this.createGroupIfAbsent("travel", "travel-providers", true, null);
        this.requestRole("travel", "travel-providers", this.competence + "-" + "provider", null);
    }

    @Override
    public void live() {
        while (true) {
            Message message;
            if ((message = this.waitNextMessage()).getSender().getRole().equals("broker")) {
                this.handleBrokerMessage((StringMessage)message);
                continue;
            }
            this.finalizeContract((StringMessage)message);
        }
    }

    private void handleBrokerMessage(StringMessage stringMessage) {
        if (((String)stringMessage.getContent()).equals("make-bid-please")) {
            if (this.logger != null) {
                this.logger.info("I received a call for bid from " + stringMessage.getSender());
            }
            this.sendReply(stringMessage, new IntegerMessage((int)(Math.random() * 500.0)));
        } else {
            this.iHaveBeenSelected(stringMessage);
        }
    }

    private void iHaveBeenSelected(StringMessage stringMessage) {
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.YELLOW);
        }
        if (this.logger != null) {
            this.logger.info("I have been selected :)");
        }
        String string = (String)stringMessage.getContent();
        this.createGroup("travel", string, true);
        this.requestRole("travel", string, "provider");
        this.sendReply(stringMessage, new Message());
    }

    private void finalizeContract(StringMessage stringMessage) {
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.GREEN);
        }
        if (this.logger != null) {
            this.logger.info("I have sold something: That's great !");
        }
        this.sendReply(stringMessage, new StringMessage("ticket"));
        this.pause((int)(Math.random() * 2000.0 + 1000.0));
        this.leaveGroup("travel", stringMessage.getSender().getGroup());
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.LIGHT_GRAY);
        }
    }

    @Override
    public void setupFrame(JFrame jFrame) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new OutputPanel(this), "Center");
        this.blinkPanel = new JPanel();
        this.blinkPanel.add(new JLabel(icons.get(this.competence)));
        jPanel.add((Component)this.blinkPanel, "North");
        this.blinkPanel.setBackground(Color.LIGHT_GRAY);
        jPanel.validate();
        jFrame.add(jPanel);
        int n = nbOfProvidersOnScreen++ * 300;
        if ((double)(n + 300) > Toolkit.getDefaultToolkit().getScreenSize().getWidth()) {
            nbOfProvidersOnScreen = 0;
        }
        jFrame.setLocation(n, 640);
        jFrame.setSize(300, 300);
    }

    static {
        for (String string : availableTransports) {
            icons.put(string, new ImageIcon(Provider.class.getResource("images/" + string + ".png")));
        }
        nbOfProvidersOnScreen = 0;
    }
}

