/*
 * Decompiled with CFR 0.152.
 */
package madkit.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import madkit.util.MadkitProperties;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLUtilities {
    public static final String NB_OF_INSTANCES = "nbOfInstances";
    public static final String GUI = "GUI";
    public static final String ATTRIBUTES = "Attributes";
    public static final String CLASS = "class";
    public static final String AGENT = "Agent";
    public static final String MADKIT_PROPERTIES = "MadkitProperties";
    public static final String LOG_LEVEL = "logLevel";
    public static final String MDK = "MDK";
    public static final String BUCKET_MODE = "bucketMode";
    public static final String BUCKET_MODE_ROLE = "bucketModeRole";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getDOM(String xmlFile) throws SAXException, IOException, ParserConfigurationException {
        try (InputStream is = MadkitProperties.getInputStream(xmlFile);){
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            return document;
        }
    }

    public static String nodeToString(Node node) {
        String s = node.getNodeName() + "( ";
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                s = s + map.item(i).getNodeName() + "=" + map.item(i).getNodeValue() + " ";
            }
        }
        s = s + " )";
        return s;
    }
}

