/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import madkit.bees.Bee;
import madkit.bees.BeeScheduler;
import madkit.bees.BeeViewer;
import madkit.bees.QueenBee;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.message.EnumMessage;

public class BeeLauncher
extends Agent {
    private static final long serialVersionUID = 7558468322705057201L;
    public static final String SIMU_GROUP = "bees";
    public static final String BEE_ROLE = "bee";
    public static final String QUEEN_ROLE = "queen";
    public static final String FOLLOWER_ROLE = "follower";
    public static final String VIEWER_ROLE = "viewer";
    public static final String SCHEDULER_ROLE = "scheduler";
    public static final String LAUNCHER_ROLE = "launcher";
    public static final String COMMUNITY = "buzz";
    private int beenumber = 30000;
    private ArrayList<AbstractAgent> queensList = new ArrayList();
    private ArrayList<AbstractAgent> beesList = new ArrayList(this.beenumber * 2);
    private boolean randomMode = true;
    private BeeViewer beeViewer;
    private boolean alive = true;

    @Override
    protected void activate() {
        this.setLogLevel(Level.INFO);
        if (this.logger != null) {
            this.logger.info("Launching bees simulation...");
        }
        this.createGroup(COMMUNITY, SIMU_GROUP, false, null);
        this.requestRole(COMMUNITY, SIMU_GROUP, LAUNCHER_ROLE, null);
        long timeL = System.nanoTime();
        this.launchBees(this.beenumber);
        if (this.logger != null) {
            this.logger.fine("launch time : " + (System.nanoTime() - timeL));
        }
        BeeScheduler beeScheduler = new BeeScheduler(COMMUNITY);
        this.beeViewer = new BeeViewer(beeScheduler, COMMUNITY);
        this.launchAgent((AbstractAgent)this.beeViewer, true);
        this.launchAgent((AbstractAgent)beeScheduler, false);
        this.pause(4000);
        this.launchQueens(1);
    }

    private void exit() {
        this.alive = false;
    }

    private void randomMode(boolean on) {
        this.randomMode = on;
    }

    @Override
    protected void live() {
        while (this.alive) {
            Message m = this.waitNextMessage(500 + (int)(Math.random() * 2000.0));
            if (m != null) {
                this.proceedEnumMessage((EnumMessage)m);
            }
            if (!this.randomMode) continue;
            this.killBees(false, 150);
            if (Math.random() < 0.8) {
                if (Math.random() < 0.5) {
                    if (this.queensList.size() <= 1) continue;
                    if (this.queensList.size() > 7) {
                        this.killBees(true, (int)(Math.random() * 7.0) + 1);
                        continue;
                    }
                    this.killBees(true, (int)(Math.random() * 2.0) + 1);
                    continue;
                }
                if (this.queensList.size() >= 10) continue;
                this.launchQueens((int)(Math.random() * 2.0) + 1);
                continue;
            }
            if (Math.random() < 0.3) {
                if (this.beesList.size() >= 200000 || Runtime.getRuntime().freeMemory() <= 100000L) continue;
                this.launchBees((int)(Math.random() * 15000.0) + 5000);
                continue;
            }
            this.killBees(false, (int)(Math.random() * 500.0) + 1);
        }
    }

    @Override
    protected void end() {
        this.queensList = null;
        this.beesList = null;
        if (this.logger != null) {
            this.logger.info("I am done. Bye !");
        }
    }

    private void launchBees(int numberOfBees) {
        if (this.logger != null) {
            this.logger.info("Launching " + numberOfBees + " bees");
        }
        this.beesList.addAll(this.launchAgentBucket(Bee.class.getName(), numberOfBees, "buzz,bees,bee", "buzz,bees,follower"));
    }

    private void launchQueens(int numberOfQueens) {
        if (this.logger != null) {
            this.logger.info("Launching " + numberOfQueens + " queen bees");
        }
        this.queensList.addAll(this.launchAgentBucket(QueenBee.class.getName(), numberOfQueens, "buzz,bees,bee", "buzz,bees,queen"));
    }

    private void killBees(boolean queen, int number) {
        ArrayList<AbstractAgent> l = queen ? this.queensList : this.beesList;
        Iterator i = l.iterator();
        for (int j = 0; i.hasNext() && j < number; ++j) {
            AbstractAgent a;
            if (j % 100 == 0) {
                Thread.yield();
            }
            if ((a = (AbstractAgent)i.next()) == null) break;
            i.remove();
            this.killAgent(a);
        }
    }

    public static void main(String[] args) {
        BeeLauncher.executeThisAgent(1, false, args);
    }

    static enum BeeLauncherAction {
        RANDOM_MODE,
        LAUNCH_BEES;

    }
}

