/*
 * Decompiled with CFR 0.152.
 */
package madkit.marketorg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.gui.OutputPanel;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.message.IntegerMessage;
import madkit.message.StringMessage;

public class Provider
extends Agent {
    private static final long serialVersionUID = 9125493540160734521L;
    public static List<String> availableTransports = Arrays.asList("train", "boat", "plane", "bus");
    private static final Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    private static int nbOfProvidersOnScreen;
    private String competence = availableTransports.get((int)(Math.random() * (double)availableTransports.size()));
    private JPanel blinkPanel;

    @Override
    public void activate() {
        this.createGroupIfAbsent("travel", "travel-providers", true, null);
        this.requestRole("travel", "travel-providers", this.competence + "-" + "provider", null);
    }

    @Override
    public void live() {
        while (true) {
            Message m;
            if ((m = this.waitNextMessage()).getSender().getRole().equals("broker")) {
                this.handleBrokerMessage((StringMessage)m);
                continue;
            }
            this.finalizeContract((StringMessage)m);
        }
    }

    private void handleBrokerMessage(StringMessage m) {
        if (((String)m.getContent()).equals("make-bid-please")) {
            if (this.logger != null) {
                this.logger.info("I received a call for bid from " + m.getSender());
            }
            this.sendReply(m, new IntegerMessage((int)(Math.random() * 500.0)));
        } else {
            this.iHaveBeenSelected(m);
        }
    }

    private void iHaveBeenSelected(StringMessage m) {
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.YELLOW);
        }
        if (this.logger != null) {
            this.logger.info("I have been selected :)");
        }
        String contractGroup = (String)m.getContent();
        this.createGroup("travel", contractGroup, true);
        this.requestRole("travel", contractGroup, "provider");
        this.sendReply(m, new Message());
    }

    private void finalizeContract(StringMessage m) {
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.GREEN);
        }
        if (this.logger != null) {
            this.logger.info("I have sold something: That's great !");
        }
        this.sendReply(m, new StringMessage("ticket"));
        this.pause((int)(Math.random() * 2000.0 + 1000.0));
        this.leaveGroup("travel", m.getSender().getGroup());
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.LIGHT_GRAY);
        }
    }

    @Override
    public void setupFrame(JFrame frame) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new OutputPanel(this), "Center");
        this.blinkPanel = new JPanel();
        this.blinkPanel.add(new JLabel(icons.get(this.competence)));
        p.add((Component)this.blinkPanel, "North");
        this.blinkPanel.setBackground(Color.LIGHT_GRAY);
        p.validate();
        frame.add(p);
        int xLocation = nbOfProvidersOnScreen++ * 300;
        if ((double)(xLocation + 300) > Toolkit.getDefaultToolkit().getScreenSize().getWidth()) {
            nbOfProvidersOnScreen = 0;
        }
        frame.setLocation(xLocation, 640);
        frame.setSize(300, 300);
    }

    static {
        for (String competence : availableTransports) {
            icons.put(competence, new ImageIcon(Provider.class.getResource("images/" + competence + ".png")));
        }
        nbOfProvidersOnScreen = 0;
    }
}

