/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import madkit.action.AgentAction;
import madkit.action.MDKAbstractAction;
import madkit.gui.menu.AgentClassFilter;
import madkit.gui.menu.ClassPathSensitiveMenu;
import madkit.kernel.AbstractAgent;
import madkit.kernel.MadkitClassLoader;

public class LaunchAgentsMenu
extends ClassPathSensitiveMenu {
    private final Action myAction;
    private final AbstractAgent myAgent;
    private final AgentClassFilter filter;

    public LaunchAgentsMenu(AbstractAgent agent) {
        this(agent, "Agents", null);
    }

    public LaunchAgentsMenu(AbstractAgent agent, String menuName) {
        this(agent, menuName, null);
    }

    public LaunchAgentsMenu(final AbstractAgent agent, String menuName, AgentClassFilter filter) {
        super(menuName);
        this.filter = filter;
        this.setMnemonic(71);
        this.myAgent = agent;
        this.myAction = new MDKAbstractAction(AgentAction.LAUNCH_AGENT.getActionInfo()){
            private static final long serialVersionUID = 6530886642947530268L;

            @Override
            public void actionPerformed(ActionEvent e) {
                agent.launchAgent(e.getActionCommand(), 0, true);
            }
        };
        this.update();
    }

    private void addTomenu(Action a, JMenu subMenu, String className, boolean simpleName) {
        JMenuItem name = new JMenuItem(a);
        name.setText(simpleName ? MadkitClassLoader.getClassSimpleName(className) : className);
        name.setAccelerator(null);
        name.setActionCommand(className);
        subMenu.add(name);
    }

    @Override
    public void update() {
        if (!this.myAgent.isAlive()) {
            return;
        }
        this.removeAll();
        Set<String> classesToLaunch = MadkitClassLoader.getAllAgentClasses();
        if (this.filter != null) {
            Iterator<String> iterator = classesToLaunch.iterator();
            while (iterator.hasNext()) {
                if (this.filter.accept(iterator.next())) continue;
                iterator.remove();
            }
        }
        if (classesToLaunch.size() < 20) {
            for (String string : classesToLaunch) {
                this.addTomenu(this.myAction, this, string, false);
            }
        } else {
            String pckName = null;
            JMenu subMenu = null;
            for (String cName : classesToLaunch) {
                String pck = MadkitClassLoader.getClassPackageName(cName);
                if (pck != null) {
                    if (pck.equals(pckName)) {
                        this.addTomenu(this.myAction, subMenu, cName, true);
                        continue;
                    }
                    pckName = pck;
                    subMenu = new JMenu(pck);
                    this.add(subMenu);
                    this.addTomenu(this.myAction, subMenu, cName, true);
                    continue;
                }
                this.addTomenu(this.myAction, this, cName, false);
            }
        }
    }
}

