/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedHashSet;
import java.util.Observable;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import madkit.action.SchedulingAction;
import madkit.gui.AgentFrame;
import madkit.gui.SwingUtil;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import madkit.kernel.Agent;
import madkit.kernel.GVTJLabel;
import madkit.kernel.GVTModel;
import madkit.kernel.Message;
import madkit.message.SchedulingMessage;

public class Scheduler
extends Agent {
    private SimulationState simulationState = SimulationState.PAUSED;
    private final Set<Activator<? extends AbstractAgent>> activators = new LinkedHashSet<Activator<? extends AbstractAgent>>();
    private Action run;
    private Action step;
    private Action speedUp;
    private Action speedDown;
    private int delay;
    private final DefaultBoundedRangeModel speedModel = new DefaultBoundedRangeModel(400, 0, 0, 400){

        @Override
        public void setValue(int n) {
            super.setValue(n);
            Scheduler.this.delay = 400 - this.getValue();
            SwingUtil.UI_PREFERENCES.putInt(Scheduler.this.getName() + "speed", this.getValue());
        }
    };
    private double GVT = 0.0;
    private double simulationDuration;
    private GVTModel gvtModel;

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.speedModel.setValue(this.speedModel.getMaximum() - delay);
    }

    public double getGVT() {
        return this.GVT;
    }

    public void setGVT(double GVT) {
        this.GVT = GVT;
        if (this.gvtModel != null) {
            this.gvtModel.notifyObservers((int)GVT);
        }
    }

    public Scheduler() {
        this(Double.MAX_VALUE);
    }

    public Scheduler(double endTime) {
        this.buildActions();
        this.setSimulationDuration(endTime);
    }

    @Override
    public void setupFrame(JFrame frame) {
        this.setupFrame((AgentFrame)frame);
        super.setupFrame(frame);
        frame.add((Component)this.getSchedulerToolBar(), "First");
        frame.add((Component)this.getSchedulerStatusLabel(), "Last");
        this.setGVT(this.GVT);
        frame.getJMenuBar().add((Component)this.getSchedulerMenu(), 2);
        this.speedModel.setValue(SwingUtil.UI_PREFERENCES.getInt(this.getName() + "speed", this.speedModel.getValue()));
        this.setSimulationState(SwingUtil.UI_PREFERENCES.getBoolean(this.getName() + "autostart", false) ? SimulationState.RUNNING : SimulationState.PAUSED);
    }

    @Override
    public void setupFrame(AgentFrame frame) {
        super.setupFrame(frame);
        frame.add((Component)this.getSchedulerToolBar(), "First");
        frame.add((Component)this.getSchedulerStatusLabel(), "Last");
        this.setGVT(this.GVT);
        frame.getJMenuBar().add((Component)this.getSchedulerMenu(), 2);
        this.speedModel.setValue(SwingUtil.UI_PREFERENCES.getInt(this.getName() + "speed", this.speedModel.getValue()));
        this.setSimulationState(SwingUtil.UI_PREFERENCES.getBoolean(this.getName() + "autostart", false) ? SimulationState.RUNNING : SimulationState.PAUSED);
    }

    public void addActivator(Activator<? extends AbstractAgent> activator) {
        if (this.kernel.addOverlooker(this, activator)) {
            this.activators.add(activator);
        }
        if (this.logger != null) {
            this.logger.fine("Activator added: " + activator);
        }
    }

    public void removeActivator(Activator<? extends AbstractAgent> activator) {
        this.kernel.removeOverlooker(this, activator);
        this.activators.remove(activator);
        if (this.logger != null) {
            this.logger.fine("Activator removed: " + activator);
        }
    }

    public void doSimulationStep() {
        if (this.logger != null) {
            this.logger.finer("Doing simulation step " + this.GVT);
        }
        for (Activator<? extends AbstractAgent> activator : this.activators) {
            if (this.logger != null) {
                this.logger.finer("Activating --------> " + activator);
            }
            activator.execute(new Object[0]);
        }
        this.setGVT(this.GVT + 1.0);
    }

    @Override
    protected void end() {
        this.simulationState = SimulationState.PAUSED;
        if (this.logger != null) {
            this.logger.info("Simulation stopped !");
        }
    }

    public SimulationState getSimulationState() {
        return this.simulationState;
    }

    protected void setSimulationState(SimulationState newState) {
        if (this.simulationState != newState) {
            this.simulationState = newState;
            switch (this.simulationState) {
                case STEP: {
                    this.run.setEnabled(true);
                    break;
                }
                case PAUSED: {
                    this.run.setEnabled(true);
                    break;
                }
                case RUNNING: {
                    this.run.setEnabled(false);
                    break;
                }
                case SHUTDOWN: {
                    this.run.setEnabled(false);
                    break;
                }
                default: {
                    this.logLifeException(new Exception("state not handle : " + newState.toString()));
                }
            }
        }
    }

    @Override
    protected void live() {
        block6: while (this.isAlive()) {
            if (this.GVT > this.simulationDuration) {
                if (this.logger != null) {
                    this.logger.info("Quitting: Simulation has reached end time " + this.simulationDuration);
                }
                return;
            }
            this.pause(this.delay);
            this.checkMail(this.nextMessage());
            switch (this.simulationState) {
                case RUNNING: {
                    this.doSimulationStep();
                    continue block6;
                }
                case PAUSED: {
                    this.paused();
                    continue block6;
                }
                case STEP: {
                    this.simulationState = SimulationState.PAUSED;
                    this.doSimulationStep();
                    continue block6;
                }
                case SHUTDOWN: {
                    return;
                }
            }
            this.getLogger().severe("state not handled " + (Object)((Object)this.simulationState));
        }
    }

    protected void checkMail(Message m) {
        block12: {
            if (m != null) {
                try {
                    SchedulingAction code = (SchedulingAction)((Object)((SchedulingMessage)m).getCode());
                    switch (code) {
                        case RUN: {
                            this.setSimulationState(SimulationState.RUNNING);
                            break;
                        }
                        case STEP: {
                            this.setSimulationState(SimulationState.STEP);
                            break;
                        }
                        case PAUSE: {
                            this.setSimulationState(SimulationState.PAUSED);
                            break;
                        }
                        case SHUTDOWN: {
                            this.setSimulationState(SimulationState.SHUTDOWN);
                            break;
                        }
                        case SPEED_UP: {
                            this.speedModel.setValue(this.speedModel.getValue() - 50);
                            break;
                        }
                        case SPEED_DOWN: {
                            this.speedModel.setValue(this.speedModel.getValue() + 50);
                        }
                    }
                    if (m.getSender() != null) {
                        this.sendReply(m, m);
                    }
                }
                catch (ClassCastException e) {
                    if (this.logger == null) break block12;
                    this.logger.info("I received a message that I cannot understand" + m);
                }
            }
        }
    }

    protected void paused() {
        this.checkMail(this.waitNextMessage(1000L));
    }

    @Override
    final void terminate() {
        this.removeAllActivators();
        super.terminate();
    }

    public void removeAllActivators() {
        for (Activator<? extends AbstractAgent> a : this.activators) {
            this.kernel.removeOverlooker(this, a);
        }
        this.activators.clear();
    }

    public void setSimulationDuration(double endTime) {
        this.simulationDuration = endTime;
    }

    public double getSimulationDuration() {
        return this.simulationDuration;
    }

    private void buildActions() {
        this.run = SchedulingAction.RUN.getActionFor(this, new Object[0]);
        this.step = SchedulingAction.STEP.getActionFor(this, new Object[0]);
        this.speedUp = SchedulingAction.SPEED_UP.getActionFor(this, new Object[0]);
        this.speedDown = SchedulingAction.SPEED_DOWN.getActionFor(this, new Object[0]);
    }

    public JToolBar getSchedulerToolBar() {
        JToolBar toolBar = new JToolBar("scheduler toolbar");
        toolBar.add(this.run);
        toolBar.add(this.step);
        final JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("speed"));
        final JSlider sp = new JSlider(this.speedModel);
        sp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int move = -e.getWheelRotation();
                if (sp.getValue() < 398) {
                    move *= 10;
                }
                move = move + sp.getValue() > sp.getMaximum() ? sp.getMaximum() : move + sp.getValue();
                sp.setValue(move);
                sp.getChangeListeners()[0].stateChanged(new ChangeEvent(this));
            }
        });
        sp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Scheduler.this.updateToolTip(p, sp);
            }
        });
        this.updateToolTip(p, sp);
        p.add(sp);
        toolBar.add(p);
        SwingUtil.scaleAllAbstractButtonIconsOf(toolBar, 24);
        return toolBar;
    }

    private void updateToolTip(JPanel p, JSlider sp) {
        String text = "pause = " + this.getDelay() + " ms";
        sp.setToolTipText(text);
        p.setToolTipText(text);
    }

    public JMenu getSchedulerMenu() {
        JMenu myMenu = new JMenu("Scheduling");
        myMenu.setMnemonic(83);
        myMenu.add(this.run);
        myMenu.add(this.step);
        myMenu.add(this.speedUp);
        myMenu.add(this.speedDown);
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("autostart", SwingUtil.UI_PREFERENCES.getBoolean(this.getName() + "autostart", false));
        menuItem.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtil.UI_PREFERENCES.putBoolean(Scheduler.this.getName() + "autostart", menuItem.isSelected());
            }
        });
        myMenu.add(menuItem);
        return myMenu;
    }

    public JLabel getSchedulerStatusLabel() {
        if (this.gvtModel == null) {
            this.gvtModel = new GVTModel();
        }
        GVTJLabel timer = new GVTJLabel(){

            @Override
            public void update(Observable o, Object arg) {
                this.setText("Simulation " + (Object)((Object)Scheduler.this.simulationState) + ", time is " + arg);
            }
        };
        timer.setText("GVT");
        this.gvtModel.addObserver(timer);
        timer.setBorder(new EmptyBorder(4, 4, 4, 4));
        timer.setHorizontalAlignment(10);
        this.setGVT(this.getGVT());
        return timer;
    }

    public JLabel getGVTLabel() {
        if (this.gvtModel == null) {
            this.gvtModel = new GVTModel();
        }
        GVTJLabel timer = new GVTJLabel();
        timer.setText("0");
        this.gvtModel.addObserver(timer);
        timer.setBorder(new EmptyBorder(4, 4, 4, 4));
        timer.setHorizontalAlignment(10);
        this.setGVT(this.getGVT());
        return timer;
    }

    public static enum SimulationState {
        RUNNING,
        STEP,
        PAUSED,
        SHUTDOWN;

    }
}

