/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import madkit.action.GlobalAction;
import madkit.action.KernelAction;
import madkit.gui.ConsoleAgent;
import madkit.gui.MASModel;
import madkit.i18n.ErrorMessages;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentExecutor;
import madkit.kernel.AgentLogger;
import madkit.kernel.AgentThreadFactory;
import madkit.kernel.AgentsJob;
import madkit.kernel.CGRNotAvailable;
import madkit.kernel.CGRSynchro;
import madkit.kernel.CandidateAgentAddress;
import madkit.kernel.Gatekeeper;
import madkit.kernel.Group;
import madkit.kernel.KernelAddress;
import madkit.kernel.LoggedKernel;
import madkit.kernel.Madkit;
import madkit.kernel.MadkitClassLoader;
import madkit.kernel.MadkitWarning;
import madkit.kernel.Message;
import madkit.kernel.NetworkAgent;
import madkit.kernel.Organization;
import madkit.kernel.OrganizationWarning;
import madkit.kernel.Overlooker;
import madkit.kernel.RequestRoleSecure;
import madkit.kernel.Role;
import madkit.message.BooleanMessage;
import madkit.message.KernelMessage;
import madkit.message.ObjectMessage;
import madkit.message.hook.AgentLifeEvent;
import madkit.message.hook.HookMessage;
import madkit.message.hook.MessageEvent;
import madkit.message.hook.OrganizationEvent;
import madkit.util.MadkitProperties;
import org.xml.sax.SAXException;

class MadkitKernel
extends Agent {
    private static final ThreadGroup SYSTEM = new ThreadGroup("MK_SYSTEM"){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.err.println("\n------------uncaught exception on " + t);
        }
    };
    private static final ThreadPoolExecutor serviceExecutor = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 2L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(SYSTEM, r);
            t.setPriority(10);
            t.setName(SYSTEM.getName());
            t.setDaemon(true);
            return t;
        }
    });
    private final ThreadPoolExecutor lifeExecutor;
    private final ConcurrentHashMap<String, Organization> organizations;
    private final Set<Overlooker<? extends AbstractAgent>> operatingOverlookers;
    private final Madkit platform;
    private final KernelAddress kernelAddress;
    protected MadkitKernel loggedKernel;
    private volatile boolean shuttedDown = false;
    private final AgentThreadFactory normalAgentThreadFactory;
    private final AgentThreadFactory daemonAgentThreadFactory;
    private AgentAddress netAgent;
    private AgentAddress netUpdater;
    private AgentAddress netEmmiter;
    private AgentAddress kernelRole;
    private final Set<Agent> threadedAgents;
    private EnumMap<HookMessage.AgentActionEvent, Set<AbstractAgent>> hooks;

    static final ExecutorService getMadkitServiceExecutor() {
        return serviceExecutor;
    }

    MadkitKernel(Madkit m) {
        super(true);
        this.platform = m;
        this.kernel = this;
        this.threadedAgents = new HashSet<Agent>(20);
        this.kernelAddress = new KernelAddress();
        String logDirKey = Madkit.Option.logDirectory.name();
        MadkitProperties madkitConfig = this.getMadkitConfig();
        String logBaseDir = madkitConfig.getProperty(logDirKey) + File.separator;
        String logDir = logBaseDir + Madkit.DATE_FORMAT.format(new Date()) + this.kernelAddress;
        while (new File(logDir).exists()) {
            logDir = logBaseDir + Madkit.DATE_FORMAT.format(new Date()) + this.kernelAddress;
        }
        madkitConfig.setProperty(logDirKey, logDir);
        this.organizations = new ConcurrentHashMap();
        this.operatingOverlookers = new LinkedHashSet<Overlooker<? extends AbstractAgent>>();
        this.loggedKernel = new LoggedKernel(this);
        this.getLogger();
        this.setLogLevel(Madkit.LevelOption.kernelLogLevel.getValue(madkitConfig));
        if (this.logger != null && Madkit.BooleanOption.createLogFiles.isActivated(madkitConfig)) {
            this.logger.createLogFile();
        }
        this.normalAgentThreadFactory = new AgentThreadFactory(this.kernelAddress, false);
        this.daemonAgentThreadFactory = new AgentThreadFactory(this.kernelAddress, true);
        this.lifeExecutor = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(MadkitKernel.this.normalAgentThreadFactory.getThreadGroup(), r);
                return t;
            }
        });
        this.lifeExecutor.prestartAllCoreThreads();
        this.lifeExecutor.allowCoreThreadTimeOut(true);
    }

    MadkitKernel() {
        super(null);
        this.kernel = this;
        this.threadedAgents = null;
        this.loggedKernel = this;
        this.platform = null;
        this.kernelAddress = null;
        this.organizations = null;
        this.operatingOverlookers = null;
        this.normalAgentThreadFactory = null;
        this.daemonAgentThreadFactory = null;
        this.lifeExecutor = null;
    }

    MadkitKernel(MadkitKernel k) {
        super(null);
        this.threadedAgents = null;
        this.platform = k.platform;
        this.kernelAddress = k.kernelAddress;
        this.organizations = k.organizations;
        this.operatingOverlookers = k.operatingOverlookers;
        this.normalAgentThreadFactory = null;
        this.daemonAgentThreadFactory = null;
        this.lifeExecutor = null;
        this.kernel = k;
    }

    @Override
    protected void activate() {
        if (this.logger != null) {
            this.logger.setWarningLogLevel(Level.INFO);
        }
        this.createGroup("local", "system", false, new Gatekeeper(){

            @Override
            public boolean allowAgentToTakeRole(String req, String roleName, Object memberCard) {
                return false;
            }
        });
        this.createGroup("local", "kernels", true);
        this.createGroup("local", "network", false);
        this.requestRole("local", "network", "kernel", null);
        this.requestRole("local", "network", "updater", null);
        this.requestRole("local", "network", "emmiter", null);
        this.netUpdater = this.getAgentAddressIn("local", "network", "updater");
        this.netEmmiter = this.getAgentAddressIn("local", "network", "emmiter");
        this.kernelRole = this.getAgentAddressIn("local", "network", "kernel");
        this.myThread.setPriority(6);
        if (Madkit.BooleanOption.loadLocalDemos.isActivated(this.getMadkitConfig())) {
            GlobalAction.LOAD_LOCAL_DEMOS.actionPerformed(null);
        }
        this.launchGuiManagerAgent();
        if (Madkit.BooleanOption.console.isActivated(this.getMadkitConfig())) {
            this.launchAgent(new ConsoleAgent());
        }
        this.launchNetworkAgent();
    }

    private void startSession() {
        this.launchXMLConfigurations();
        this.launchConfigAgents();
    }

    @Override
    protected void live() {
        if (Madkit.BooleanOption.autoConnectMadkitWebsite.isActivated(this.getMadkitConfig())) {
            this.addWebRepository();
        }
        this.startSession();
        while (!this.shuttedDown) {
            this.handleMessage(this.waitNextMessage());
        }
    }

    @Override
    public boolean isAlive() {
        return super.isAlive() && !this.shuttedDown;
    }

    private final void launchGuiManagerAgent() {
        if (this.logger != null) {
            this.logger.fine("\n\t****** Launching GUI Manager ******\n");
        }
        try {
            Constructor<?> c = MadkitClassLoader.getLoader().loadClass("madkit.gui.GUIManagerAgent").getDeclaredConstructor(Boolean.TYPE);
            c.setAccessible(true);
            AbstractAgent a = (AbstractAgent)c.newInstance(!Madkit.BooleanOption.desktop.isActivated(this.getMadkitConfig()));
            a.setLogLevel(Madkit.LevelOption.guiLogLevel.getValue(this.getMadkitConfig()));
            this.launchAgent(a);
            this.threadedAgents.remove(a);
            if (this.logger != null) {
                this.logger.fine("\n\t****** GUI Manager launched ******\n");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.bugReport(e);
        }
    }

    private void connectToIp(InetAddress ip) {
        this.launchNetwork();
        this.sendNetworkMessageWithRole(new KernelMessage(KernelAction.CONNECT_TO_IP, ip), this.kernelRole);
    }

    private void copy() {
        this.startSession(false);
    }

    private void restart() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    MadkitKernel.this.myThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MadkitKernel.this.copy();
            }
        }, 100L);
        this.exit();
    }

    private void addWebRepository() {
        block16: {
            String repoLocation = this.getMadkitConfig().getProperty("madkit.repository.url");
            if (this.logger != null) {
                this.logger.fine("** CONNECTING WEB REPO **" + repoLocation);
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(new URL(this.getMadkitProperty("madkit.repository.url")).openStream()));){
                for (String s : in.readLine().split("<br/>")) {
                    MadkitClassLoader.loadUrl(new URL(s));
                }
            }
            catch (IOException e) {
                if (this.logger == null) break block16;
                this.logger.log(Level.WARNING, (Object)((Object)ErrorMessages.CANT_CONNECT) + ": " + repoLocation + "\n" + e.getMessage());
            }
        }
    }

    private void launchMas(MASModel dm) {
        if (this.logger != null) {
            this.logger.finer("** LAUNCHING SESSION " + dm.getName());
        }
        MadkitProperties mkCfg = this.platform.getConfigOption();
        Properties currentConfig = new Properties();
        currentConfig.putAll((Map<?, ?>)mkCfg);
        mkCfg.putAll((Map<?, ?>)this.platform.buildConfigFromArgs(dm.getSessionArgs()));
        this.launchConfigAgents();
        mkCfg.putAll((Map<?, ?>)currentConfig);
    }

    private void launchXml(String xmlFile, boolean inNewMadkit) {
        if (this.logger != null) {
            this.logger.finer("** LAUNCHING XML CONFIG " + xmlFile);
        }
        if (inNewMadkit) {
            new Madkit(Madkit.Option.configFile.toString(), xmlFile);
        } else {
            MadkitProperties mkCfg = this.platform.getConfigOption();
            Properties currentConfig = new Properties();
            currentConfig.putAll((Map<?, ?>)mkCfg);
            try {
                mkCfg.loadPropertiesFromMaDKitXML(xmlFile);
                this.launchXmlAgents(xmlFile);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                this.getLogger().severeLog("", e);
            }
            mkCfg.putAll((Map<?, ?>)currentConfig);
        }
    }

    private void console() {
        this.launchAgent(ConsoleAgent.class.getName());
    }

    private void launchConfigAgents() {
        String agentsTolaunch;
        if (this.logger != null) {
            this.logger.fine("** LAUNCHING CONFIG AGENTS **");
        }
        if (!(agentsTolaunch = this.platform.getConfigOption().getProperty(Madkit.Option.launchAgents.name())).equals("null")) {
            String[] agentsClasses;
            for (String classNameAndOption : agentsClasses = agentsTolaunch.split(";")) {
                String[] classAndOptions = classNameAndOption.split(",");
                final String className = classAndOptions[0].trim();
                final boolean withGUI = classAndOptions.length > 1 ? Boolean.parseBoolean(classAndOptions[1].trim()) : false;
                int number = 1;
                if (classAndOptions.length > 2) {
                    try {
                        number = Integer.parseInt(classAndOptions[2].trim());
                    }
                    catch (NumberFormatException e) {
                        this.getLogger().severeLog(ErrorMessages.OPTION_MISUSED.toString() + Madkit.Option.launchAgents.toString() + " " + agentsTolaunch + " " + e.getClass().getName() + " !!!\n", null);
                    }
                }
                if (this.logger != null) {
                    this.logger.finer("Launching " + number + " instance(s) of " + className + " with GUI = " + withGUI);
                }
                try {
                    final Class<?> agentClass = MadkitClassLoader.getLoader().loadClass(className);
                    for (int i = 0; i < number; ++i) {
                        this.lifeExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (!MadkitKernel.this.shuttedDown) {
                                    try {
                                        MadkitKernel.this.launchAgent((AbstractAgent)agentClass.newInstance(), 0, withGUI);
                                    }
                                    catch (Exception e) {
                                        MadkitKernel.this.cannotLaunchAgent(className, e, null);
                                    }
                                }
                            }
                        });
                    }
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void launchXMLConfigurations() {
        String filesName;
        if (this.logger != null) {
            this.logger.fine("** LAUNCHING XML CONFIGS **");
        }
        if (!(filesName = this.getMadkitProperty(Madkit.Option.configFile)).equals("null")) {
            for (final String fileName : filesName.split(";")) {
                if (!fileName.endsWith(".xml")) continue;
                this.lifeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (MadkitKernel.this.logger != null) {
                                MadkitKernel.this.logger.finer("Launching xml " + fileName);
                            }
                            MadkitKernel.this.launchXmlAgents(fileName);
                        }
                        catch (IOException | ParserConfigurationException | SAXException e) {
                            MadkitKernel.this.getLogger().severeLog("xml config", e);
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    private void startSession(boolean externalVM) {
        if (this.logger != null) {
            this.logger.config("starting new MaDKit session with " + Arrays.deepToString(this.platform.args));
        }
        if (externalVM) {
            try {
                String args = "";
                for (String s : this.platform.args) {
                    args = args + s + " ";
                }
                Runtime.getRuntime().exec(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java -cp " + System.getProperty("java.class.path") + " " + this.platform.getConfigOption().getProperty("madkit.main.class") + " " + args);
            }
            catch (IOException e) {
                this.bugReport(e);
            }
        } else {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    new Madkit(((MadkitKernel)MadkitKernel.this).platform.args);
                }
            });
            t.setDaemon(false);
            t.start();
        }
    }

    private void stopNetwork() {
        if (this.sendNetworkMessageWithRole(new KernelMessage(KernelAction.STOP_NETWORK, new Object[0]), this.kernelRole) == AbstractAgent.ReturnCode.SUCCESS) {
            if (this.logger != null) {
                this.logger.fine("\n\t****** Network stopped ******\n");
            }
        } else if (this.logger != null) {
            this.logger.fine("\n\t****** Network already down ******\n");
        }
    }

    private void handleMessage(Message m) {
        if (m instanceof KernelMessage) {
            this.proceedEnumMessage((KernelMessage)m);
        } else if (m instanceof HookMessage) {
            this.handleHookRequest((HookMessage)m);
        } else if (m instanceof RequestRoleSecure) {
            this.handleRequestRoleSecure((RequestRoleSecure)m);
        } else if (this.logger != null) {
            this.logger.warning("I received a message that I do not understand. Discarding " + m);
        }
    }

    private void handleRequestRoleSecure(RequestRoleSecure m) {
        AgentAddress requesterAddress = m.getRequester();
        Group g = null;
        try {
            g = this.getGroup(requesterAddress.getCommunity(), requesterAddress.getGroup());
        }
        catch (CGRNotAvailable cGRNotAvailable) {
            // empty catch block
        }
        this.sendReply(m, new BooleanMessage(g != null && g.getGatekeeper().allowAgentToTakeRole(requesterAddress.getAgentNetworkID(), m.getRoleName(), m.getContent())));
    }

    private void handleHookRequest(HookMessage m) {
        Set<AbstractAgent> l;
        if (this.hooks == null) {
            this.hooks = new EnumMap(HookMessage.AgentActionEvent.class);
        }
        if ((l = this.hooks.get(m.getContent())) == null) {
            l = new HashSet<AbstractAgent>();
            this.hooks.put((HookMessage.AgentActionEvent)((Enum)m.getContent()), l);
        }
        AbstractAgent requester = m.getSender().getAgent();
        this.getLogger().setLevel(Level.INFO);
        if (!l.add(requester)) {
            l.remove(requester);
            if (l.isEmpty()) {
                this.hooks.remove(m.getContent());
                if (this.hooks.isEmpty()) {
                    this.hooks = null;
                }
            }
        }
    }

    private void launchNetworkAgent() {
        if (Madkit.BooleanOption.network.isActivated(this.getMadkitConfig())) {
            this.launchNetwork();
        } else if (this.logger != null) {
            this.logger.fine("** Networking is off: No Net Agent **\n");
        }
    }

    final MadkitKernel getLoggedKernel() {
        return this.loggedKernel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode createGroup(AbstractAgent creator, String community, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        Objects.requireNonNull(group, ErrorMessages.G_NULL.toString());
        Organization organization = new Organization(community, this);
        Organization tmpOrg = this.organizations.putIfAbsent(community, organization);
        if (tmpOrg != null) {
            organization = tmpOrg;
        }
        Organization organization2 = organization;
        synchronized (organization2) {
            if (!organization.addGroup(creator, group, gatekeeper, isDistributed)) {
                return AbstractAgent.ReturnCode.ALREADY_GROUP;
            }
            try {
                if (isDistributed) {
                    this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.CREATE_GROUP, this.getRole(community, group, "manager").getAgentAddressOf(creator)), this.netUpdater);
                }
                if (this.hooks != null) {
                    this.informHooks(HookMessage.AgentActionEvent.CREATE_GROUP, this.getRole(community, group, "manager").getAgentAddressOf(creator));
                }
            }
            catch (CGRNotAvailable e) {
                this.getLogger().severeLog("Please bug report", e);
            }
        }
        return AbstractAgent.ReturnCode.SUCCESS;
    }

    void informHooks(HookMessage.AgentActionEvent action, Object parameter) {
        Set<AbstractAgent> l;
        if (this.hooks != null && (l = this.hooks.get((Object)action)) != null) {
            HookMessage hm = null;
            switch (action) {
                case CREATE_GROUP: 
                case REQUEST_ROLE: 
                case LEAVE_GROUP: 
                case LEAVE_ROLE: {
                    hm = new OrganizationEvent(action, (AgentAddress)parameter);
                    break;
                }
                case BROADCAST_MESSAGE: 
                case SEND_MESSAGE: {
                    hm = new MessageEvent(action, (Message)parameter);
                    break;
                }
                case AGENT_STARTED: 
                case AGENT_TERMINATED: {
                    hm = new AgentLifeEvent(action, (AbstractAgent)parameter);
                    break;
                }
            }
            for (AbstractAgent a : l) {
                a.receiveMessage(hm);
            }
        }
    }

    AbstractAgent.ReturnCode requestRole(AbstractAgent requester, String community, String group, String role, Object memberCard) {
        Group g;
        try {
            g = this.getGroup(community, group);
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
        AbstractAgent.ReturnCode result = g.requestRole(requester, role, memberCard);
        if (result == AbstractAgent.ReturnCode.SUCCESS) {
            if (g.isDistributed()) {
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.REQUEST_ROLE, new AgentAddress(requester, (Role)g.get(role), this.kernelAddress)), this.netUpdater);
            }
            if (this.hooks != null) {
                this.informHooks(HookMessage.AgentActionEvent.REQUEST_ROLE, new AgentAddress(requester, (Role)g.get(role), this.kernelAddress));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode leaveGroup(AbstractAgent requester, String community, String group) {
        List<Role> affectedRoles;
        Group g;
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            try {
                g = this.getGroup(community, group);
            }
            catch (CGRNotAvailable e) {
                return e.getCode();
            }
            affectedRoles = g.leaveGroup(requester);
        }
        if (affectedRoles != null) {
            for (Role role : affectedRoles) {
                role.removeFromOverlookers(requester);
            }
            if (g.isDistributed()) {
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.LEAVE_GROUP, new AgentAddress(requester, new Role(community, group), this.kernelAddress)), this.netUpdater);
            }
            if (this.hooks != null) {
                this.informHooks(HookMessage.AgentActionEvent.LEAVE_GROUP, new AgentAddress(requester, new Role(community, group), this.kernelAddress));
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        return AbstractAgent.ReturnCode.NOT_IN_GROUP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode leaveRole(AbstractAgent requester, String community, String group, String role) {
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            AbstractAgent.ReturnCode rc;
            Role r;
            try {
                r = this.getRole(community, group, role);
            }
            catch (CGRNotAvailable e) {
                return e.getCode();
            }
            if (r.getMyGroup().isDistributed()) {
                AgentAddress leaver = r.getAgentAddressOf(requester);
                if (leaver == null) {
                    return AbstractAgent.ReturnCode.ROLE_NOT_HANDLED;
                }
                rc = r.removeMember(requester);
                if (rc != AbstractAgent.ReturnCode.SUCCESS) {
                    throw new AssertionError((Object)("cannot remove " + requester + " from " + r.buildAndGetAddresses()));
                }
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.LEAVE_ROLE, new AgentAddress(requester, r, this.kernelAddress)), this.netUpdater);
            } else {
                rc = r.removeMember(requester);
            }
            if (rc == AbstractAgent.ReturnCode.SUCCESS) {
                r.removeFromOverlookers(requester);
                if (this.hooks != null) {
                    this.informHooks(HookMessage.AgentActionEvent.LEAVE_ROLE, new AgentAddress(requester, r, this.kernelAddress));
                }
            }
            return rc;
        }
    }

    List<AgentAddress> getAgentsWithRole(AbstractAgent requester, String community, String group, String role, boolean callerIncluded) {
        try {
            if (callerIncluded) {
                return this.getRole(community, group, role).getAgentAddressesCopy();
            }
            return this.getOtherRolePlayers(requester, community, group, role);
        }
        catch (CGRNotAvailable e) {
            return null;
        }
    }

    AgentAddress getAgentWithRole(AbstractAgent requester, String community, String group, String role) {
        try {
            return this.getAnotherRolePlayer(requester, community, group, role);
        }
        catch (CGRNotAvailable e) {
            return null;
        }
    }

    AgentAddress getDistantAgentWithRole(AbstractAgent abstractAgent, String community, String group, String role, KernelAddress from) {
        try {
            List<AgentAddress> l = this.getOtherRolePlayers(abstractAgent, community, group, role);
            if (l != null) {
                for (AgentAddress agentAddress : l) {
                    if (!agentAddress.getKernelAddress().equals(from)) continue;
                    return agentAddress;
                }
            }
        }
        catch (CGRNotAvailable cGRNotAvailable) {
            // empty catch block
        }
        return null;
    }

    AbstractAgent.ReturnCode sendMessage(AbstractAgent requester, String community, String group, String role, Message message, String senderRole) {
        try {
            AgentAddress receiver = this.getAnotherRolePlayer(requester, community, group, role);
            if (receiver == null) {
                return AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND;
            }
            return this.buildAndSendMessage(this.getSenderAgentAddress(requester, receiver, senderRole), receiver, message);
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    AbstractAgent.ReturnCode sendMessage(AbstractAgent requester, AgentAddress receiver, Message message, String senderRole) {
        AgentAddress target = this.resolveAddress(receiver);
        if (target == null && !(receiver instanceof CandidateAgentAddress)) {
            return AbstractAgent.ReturnCode.INVALID_AGENT_ADDRESS;
        }
        try {
            return this.buildAndSendMessage(this.getSenderAgentAddress(requester, target, senderRole), target, message);
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    final AgentAddress resolveAddress(AgentAddress receiver) {
        Role roleObject = receiver.getRoleObject();
        if (roleObject != null) {
            if (roleObject.players == null) {
                try {
                    return this.getRole(roleObject.getCommunityName(), roleObject.getGroupName(), roleObject.getRoleName()).resolveAgentAddress(receiver);
                }
                catch (CGRNotAvailable e) {
                    return null;
                }
            }
            return receiver;
        }
        return null;
    }

    AbstractAgent.ReturnCode broadcastMessageWithRole(AbstractAgent requester, String community, String group, String role, Message messageToSend, String senderRole) {
        try {
            List<AgentAddress> receivers = this.getOtherRolePlayers(requester, community, group, role);
            if (receivers == null) {
                return AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND;
            }
            AgentAddress senderAgentAddress = this.getSenderAgentAddress(requester, receivers.get(0), senderRole);
            messageToSend.setSender(senderAgentAddress);
            this.broadcasting(receivers, messageToSend);
            if (this.hooks != null) {
                messageToSend.setReceiver(receivers.get(0));
                this.informHooks(HookMessage.AgentActionEvent.BROADCAST_MESSAGE, messageToSend.clone());
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    List<Message> broadcastMessageWithRoleAndWaitForReplies(AbstractAgent requester, String community, String group, String role, Message message, String senderRole, Integer timeOutMilliSeconds) {
        try {
            List<AgentAddress> receivers = this.getOtherRolePlayers(requester, community, group, role);
            if (receivers == null) {
                return null;
            }
            message.setSender(this.getSenderAgentAddress(requester, receivers.get(0), senderRole));
            this.broadcasting(receivers, message);
            return requester.waitAnswers(message, receivers.size(), timeOutMilliSeconds);
        }
        catch (CGRNotAvailable e) {
            if (requester.getKernel() != this && requester.isWarningOn()) {
                AbstractAgent.ReturnCode r = e.getCode();
                if (r == AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND) {
                    requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE_AND_WAIT, new MadkitWarning(r));
                } else if (r == AbstractAgent.ReturnCode.ROLE_NOT_HANDLED) {
                    requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE_AND_WAIT, new OrganizationWarning(r, community, group, senderRole));
                } else {
                    requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE_AND_WAIT, new OrganizationWarning(r, community, group, role));
                }
            }
            return null;
        }
    }

    private void broadcasting(Collection<AgentAddress> receivers, Message m) {
        receivers.parallelStream().forEach(agentAddress -> {
            Message cm = m.clone();
            cm.setReceiver((AgentAddress)agentAddress);
            this.sendMessage(cm, agentAddress.getAgent());
        });
    }

    private final AbstractAgent.ReturnCode sendMessage(Message m, AbstractAgent target) {
        if (target == null) {
            m.getConversationID().setOrigin(this.kernelAddress);
            return this.sendNetworkMessageWithRole(new ObjectMessage<Message>(m), this.netEmmiter);
        }
        target.receiveMessage(m);
        return AbstractAgent.ReturnCode.SUCCESS;
    }

    final AbstractAgent.ReturnCode sendNetworkMessageWithRole(Message m, AgentAddress role) {
        this.updateNetworkAgent();
        if (this.netAgent != null) {
            m.setSender(role);
            m.setReceiver(this.netAgent);
            this.netAgent.getAgent().receiveMessage(m);
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        return AbstractAgent.ReturnCode.SEVERE;
    }

    private void updateNetworkAgent() {
        if (this.netAgent == null || !this.checkAgentAddress(this.netAgent)) {
            this.netAgent = this.getAgentWithRole("local", "network", "net agent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void launchAgentBucketWithRoles(final AbstractAgent requester, List<AbstractAgent> bucket, int cpuCoreNb, String ... cgrLocations) {
        if (cgrLocations != null && cgrLocations.length != 0) {
            AgentsJob init = new AgentsJob(){

                @Override
                void proceedAgent(AbstractAgent a) {
                    a.state.set(AbstractAgent.State.INITIALIZING);
                    a.setKernel(MadkitKernel.this);
                    a.getAlive().set(true);
                    a.logger = null;
                }
            };
            this.doMulticore(init.getJobs(bucket, cpuCoreNb));
            MadkitKernel madkitKernel = this;
            synchronized (madkitKernel) {
                for (String cgrLocation : cgrLocations) {
                    String[] cgr = cgrLocation.split(",");
                    if (cgr.length != 3) {
                        throw new IllegalArgumentException("\"" + cgrLocation + "\" is incorrect. As of MDK 5.0.2, correct format is \"C,G,R\" ");
                    }
                    this.createGroup(requester, cgr[0], cgr[1], null, false);
                    Group g = null;
                    try {
                        g = this.getGroup(cgr[0], cgr[1]);
                    }
                    catch (CGRNotAvailable e) {
                        throw new AssertionError((Object)e);
                    }
                    boolean roleCreated = false;
                    Role r = (Role)g.get(cgr[2]);
                    if (r == null) {
                        r = g.createRole(cgr[2]);
                        roleCreated = true;
                    }
                    r.addMembers(bucket, roleCreated);
                }
                init = new AgentsJob(){

                    @Override
                    void proceedAgent(AbstractAgent a) {
                        try {
                            a.activate();
                            a.state.set(AbstractAgent.State.ACTIVATED);
                        }
                        catch (Throwable e) {
                            requester.cannotLaunchAgent(a != null ? a.getClass().getName() : "launchAgentBucketWithRoles : list contains null", e, null);
                        }
                    }
                };
                this.doMulticore(init.getJobs(bucket, cpuCoreNb));
            }
        }
        AgentsJob aj = new AgentsJob(){

            @Override
            void proceedAgent(AbstractAgent a) {
                a.state.set(AbstractAgent.State.ACTIVATED);
                a.setKernel(MadkitKernel.this);
                a.getAlive().set(true);
                a.logger = null;
                try {
                    a.activate();
                }
                catch (Throwable e) {
                    requester.cannotLaunchAgent("launchAgentBucketWithRoles : " + a.getClass().getName(), e, null);
                }
            }
        };
        this.doMulticore(aj.getJobs(bucket, cpuCoreNb));
    }

    final List<AbstractAgent> createBucket(String agentClass, int bucketSize, int cpuCoreNb) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        int i;
        final Class<?> constructor = MadkitClassLoader.getLoader().loadClass(agentClass);
        cpuCoreNb = cpuCoreNb > 0 ? cpuCoreNb : 1;
        ArrayList<AbstractAgent> result = new ArrayList<AbstractAgent>(bucketSize);
        final int nbOfAgentsPerTask = bucketSize / cpuCoreNb;
        ExecutorCompletionService<List<AbstractAgent>> ecs = new ExecutorCompletionService<List<AbstractAgent>>(serviceExecutor);
        for (i = 0; i < cpuCoreNb; ++i) {
            ecs.submit(new Callable<List<AbstractAgent>>(){

                @Override
                public List<AbstractAgent> call() throws InvocationTargetException, InstantiationException, IllegalAccessException {
                    ArrayList<AbstractAgent> list = new ArrayList<AbstractAgent>(nbOfAgentsPerTask);
                    for (int j = nbOfAgentsPerTask; j > 0; --j) {
                        list.add((AbstractAgent)constructor.newInstance());
                    }
                    return list;
                }
            });
        }
        for (i = bucketSize - nbOfAgentsPerTask * cpuCoreNb; i > 0; --i) {
            result.add((AbstractAgent)constructor.newInstance());
        }
        for (i = 0; i < cpuCoreNb; ++i) {
            try {
                result.addAll((Collection)ecs.take().get());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void doMulticore(ArrayList<AgentsJob> arrayList) {
        try {
            serviceExecutor.invokeAll(arrayList);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    AbstractAgent.ReturnCode launchAgent(AbstractAgent requester, final AbstractAgent agent, int timeOutSeconds, final boolean defaultGUI) {
        try {
            AbstractAgent.ReturnCode returnCode;
            if (this.logger != null) {
                this.logger.finest(requester + " launching " + agent + " by " + Thread.currentThread());
            }
            if ((returnCode = this.lifeExecutor.submit(new Callable<AbstractAgent.ReturnCode>(){

                @Override
                public AbstractAgent.ReturnCode call() {
                    return MadkitKernel.this.launchingAgent(agent, defaultGUI);
                }
            }).get(timeOutSeconds, TimeUnit.SECONDS)) == AbstractAgent.ReturnCode.AGENT_CRASH || returnCode == AbstractAgent.ReturnCode.ALREADY_LAUNCHED) {
                requester.getLogger().severeLog(AbstractAgent.Influence.LAUNCH_AGENT.failedString(), new MadkitWarning(agent.toString(), returnCode));
            }
            return returnCode;
        }
        catch (InterruptedException e) {
            requester.handleInterruptedException();
            return AbstractAgent.ReturnCode.TIMEOUT;
        }
        catch (ExecutionException e) {
            this.bugReport("Launching task failed on " + agent, e);
            return AbstractAgent.ReturnCode.SEVERE;
        }
        catch (TimeoutException e) {
            return AbstractAgent.ReturnCode.TIMEOUT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAgent.ReturnCode launchingAgent(final AbstractAgent agent, boolean defaultGUI) {
        if (!agent.state.compareAndSet(AbstractAgent.State.NOT_LAUNCHED, AbstractAgent.State.INITIALIZING) || this.shuttedDown) {
            return AbstractAgent.ReturnCode.ALREADY_LAUNCHED;
        }
        agent.setKernel(this);
        this.informHooks(HookMessage.AgentActionEvent.AGENT_STARTED, agent);
        if (defaultGUI) {
            agent.createGUIOnStartUp();
        }
        Level defaultLevel = Madkit.LevelOption.agentLogLevel.getValue(this.getMadkitConfig());
        if (agent.logger == AgentLogger.DEFAULT_AGENT_LOGGER) {
            if (defaultLevel == Level.OFF) {
                agent.logger = null;
            } else {
                agent.setLogLevel(defaultLevel);
                agent.getLogger().setWarningLogLevel(Madkit.LevelOption.warningLogLevel.getValue(this.getMadkitConfig()));
            }
        }
        if (!(agent instanceof Agent)) {
            AbstractAgent.ReturnCode r = AbstractAgent.ReturnCode.AGENT_CRASH;
            Future<AbstractAgent.ReturnCode> activationAttempt = this.lifeExecutor.submit(new Callable<AbstractAgent.ReturnCode>(){

                @Override
                public AbstractAgent.ReturnCode call() {
                    return agent.activation();
                }
            });
            try {
                r = activationAttempt.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.bugReport(agent + " activation task failed using " + Thread.currentThread(), e);
            }
            if (r != AbstractAgent.ReturnCode.SUCCESS) {
                AtomicReference<AbstractAgent.State> atomicReference = agent.state;
                synchronized (atomicReference) {
                    agent.state.notify();
                }
                this.startEndBehavior(agent, 0, false);
            } else if (agent.isAlive()) {
                agent.state.set(AbstractAgent.State.LIVING);
            }
            return r;
        }
        try {
            Agent a = (Agent)agent;
            AgentExecutor ae = a.getAgentExecutor();
            Set<Agent> set = this.threadedAgents;
            synchronized (set) {
                this.threadedAgents.add(a);
            }
            ae.setThreadFactory(a.isDaemon() ? this.daemonAgentThreadFactory : this.normalAgentThreadFactory);
            if (!this.shuttedDown) {
                return ae.start().get();
            }
            return AbstractAgent.ReturnCode.AGENT_CRASH;
        }
        catch (InterruptedException | ExecutionException e) {
            if (!this.shuttedDown) {
                this.bugReport(e);
                return AbstractAgent.ReturnCode.SEVERE;
            }
        }
        catch (CancellationException e) {
            return AbstractAgent.ReturnCode.AGENT_CRASH;
        }
        return AbstractAgent.ReturnCode.TIMEOUT;
    }

    AbstractAgent.ReturnCode killAgent(AbstractAgent requester, final AbstractAgent target, final int timeOutSeconds) {
        if (target.getState().compareTo(AbstractAgent.State.ACTIVATED) < 0) {
            return AbstractAgent.ReturnCode.NOT_YET_LAUNCHED;
        }
        Future<AbstractAgent.ReturnCode> killAttempt = serviceExecutor.submit(new Callable<AbstractAgent.ReturnCode>(){

            @Override
            public AbstractAgent.ReturnCode call() {
                return MadkitKernel.this.killingAgent(target, timeOutSeconds);
            }
        });
        try {
            return killAttempt.get();
        }
        catch (InterruptedException e) {
            requester.handleInterruptedException();
            return AbstractAgent.ReturnCode.TIMEOUT;
        }
        catch (ExecutionException e) {
            this.bugReport("Kill failed: " + target, e);
            return AbstractAgent.ReturnCode.SEVERE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractAgent.ReturnCode killingAgent(AbstractAgent target, int timeOutSeconds) {
        AtomicReference<AbstractAgent.State> atomicReference = target.state;
        synchronized (atomicReference) {
            if (!target.getAlive().compareAndSet(true, false)) {
                return AbstractAgent.ReturnCode.ALREADY_KILLED;
            }
        }
        if (target instanceof Agent && ((Agent)target).myThread != null) {
            return this.killThreadedAgent((Agent)target, timeOutSeconds);
        }
        this.stopAbstractAgentProcess(AbstractAgent.State.ACTIVATED, target);
        return this.startEndBehavior(target, timeOutSeconds, false);
    }

    private void stopAbstractAgentProcess(AbstractAgent.State s, AbstractAgent target) {
        ThreadGroup group = this.normalAgentThreadFactory.getThreadGroup();
        Thread[] list = new Thread[group.activeCount()];
        group.enumerate(list);
        String threadName = target.getAgentThreadName(s);
        for (Thread t : list) {
            if (t == null || !t.getName().equals(threadName)) continue;
            this.stopAgentProcess(s, target, t);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopAgentProcess(AbstractAgent.State s, AbstractAgent target, Thread t) {
        AtomicReference<AbstractAgent.State> atomicReference = target.state;
        synchronized (atomicReference) {
            if (target.getState() == s && t.getName().equals(target.getAgentThreadName(s))) {
                if (this.logger != null) {
                    this.logger.finer("Hard kill on " + target + " " + t.getName());
                }
                t.stop();
                if (this.logger != null) {
                    this.logger.finer("now waiting for " + (Object)((Object)s) + " to end on " + target);
                }
                try {
                    target.state.wait();
                }
                catch (InterruptedException e) {
                    this.bugReport(e);
                }
                return true;
            }
        }
        if (this.logger != null) {
            this.logger.finer((Object)((Object)s) + " already done on " + target);
        }
        return false;
    }

    final AbstractAgent.ReturnCode startEndBehavior(final AbstractAgent target, int timeOutSeconds, boolean asDaemon) {
        ThreadPoolExecutor executor;
        AbstractAgent.ReturnCode r = AbstractAgent.ReturnCode.SUCCESS;
        ThreadPoolExecutor threadPoolExecutor = executor = asDaemon ? serviceExecutor : this.lifeExecutor;
        if (timeOutSeconds != 0) {
            Future<Boolean> endAttempt = executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return target.ending();
                }
            });
            try {
                endAttempt.get(timeOutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("----------------------\n\n---------------------------------------------");
            }
            catch (ExecutionException e) {
                this.bugReport("Killing task failed on " + target, e);
            }
            catch (TimeoutException e) {
                r = AbstractAgent.ReturnCode.TIMEOUT;
                this.stopAbstractAgentProcess(AbstractAgent.State.ENDING, target);
            }
        }
        if (!(target instanceof Agent) || ((Agent)target).myThread == null) {
            target.terminate();
        }
        return r;
    }

    private final AbstractAgent.ReturnCode killThreadedAgent(Agent target, int timeOutSeconds) {
        AgentExecutor ae = target.getAgentExecutor();
        Future<?> end = ae.getEndProcess();
        if (timeOutSeconds == 0) {
            end.cancel(false);
        }
        ae.getLiveProcess().cancel(false);
        ae.getActivate().cancel(false);
        Thread.yield();
        target.myThread.setPriority(1);
        AbstractAgent.ReturnCode result = AbstractAgent.ReturnCode.SUCCESS;
        if (!this.stopAgentProcess(AbstractAgent.State.ACTIVATED, target, target.myThread)) {
            this.stopAgentProcess(AbstractAgent.State.LIVING, target, target.myThread);
        }
        if (timeOutSeconds != 0) {
            try {
                end.get(timeOutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException | CancellationException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                this.bugReport("kill task failed on " + target, e);
            }
            catch (TimeoutException e) {
                result = AbstractAgent.ReturnCode.TIMEOUT;
            }
        }
        this.stopAgentProcess(AbstractAgent.State.ENDING, target, target.myThread);
        try {
            ae.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.bugReport(e);
        }
        return result;
    }

    private final Organization getCommunity(String community) throws CGRNotAvailable {
        Organization org = this.organizations.get(community);
        if (org == null) {
            throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_COMMUNITY);
        }
        return org;
    }

    final Group getGroup(String community, String group) throws CGRNotAvailable {
        Group g = (Group)this.getCommunity(community).get(group);
        if (g == null) {
            throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_GROUP);
        }
        return g;
    }

    final Role getRole(String community, String group, String role) throws CGRNotAvailable {
        Role r = (Role)this.getGroup(community, group).get(role);
        if (r == null) {
            throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_ROLE);
        }
        return r;
    }

    final List<AgentAddress> getOtherRolePlayers(AbstractAgent abstractAgent, String community, String group, String role) throws CGRNotAvailable {
        List<AgentAddress> result = this.getRole(community, group, role).getAgentAddressesCopy();
        Role.removeAgentAddressOf(abstractAgent, result);
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    final AgentAddress getAnotherRolePlayer(AbstractAgent abstractAgent, String community, String group, String role) throws CGRNotAvailable {
        List<AgentAddress> others = this.getOtherRolePlayers(abstractAgent, community, group, role);
        if (others != null) {
            return others.get((int)(Math.random() * (double)others.size()));
        }
        return null;
    }

    private AbstractAgent.ReturnCode buildAndSendMessage(AgentAddress sender, AgentAddress receiver, Message m) {
        m.setSender(sender);
        m.setReceiver(receiver);
        AbstractAgent.ReturnCode r = this.sendMessage(m, receiver.getAgent());
        if (r == AbstractAgent.ReturnCode.SUCCESS && this.hooks != null) {
            this.informHooks(HookMessage.AgentActionEvent.SEND_MESSAGE, m);
        }
        return r;
    }

    final AgentAddress getSenderAgentAddress(AbstractAgent sender, AgentAddress receiver, String senderRole) throws CGRNotAvailable {
        AgentAddress senderAA = null;
        Role targetedRole = receiver.getRoleObject();
        if (senderRole == null) {
            senderAA = targetedRole.getAgentAddressInGroup(sender);
            if (senderAA == null) {
                if (targetedRole.getRoleName().equals("manager")) {
                    return new CandidateAgentAddress(sender, targetedRole, this.kernelAddress);
                }
                throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_IN_GROUP);
            }
            return senderAA;
        }
        Role senderRoleObject = (Role)targetedRole.getMyGroup().get(senderRole);
        if (senderRoleObject != null) {
            senderAA = senderRoleObject.getAgentAddressOf(sender);
        }
        if (senderAA == null) {
            if (senderRole.equals("candidate") && targetedRole.getRoleName().equals("manager")) {
                return new CandidateAgentAddress(sender, targetedRole, this.kernelAddress);
            }
            if (targetedRole.getAgentAddressInGroup(sender) == null) {
                throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_IN_GROUP);
            }
            throw new CGRNotAvailable(AbstractAgent.ReturnCode.ROLE_NOT_HANDLED);
        }
        return senderAA;
    }

    synchronized boolean addOverlooker(AbstractAgent requester, Overlooker<? extends AbstractAgent> o) {
        if (this.operatingOverlookers.add(o)) {
            try {
                this.getRole(o.getCommunity(), o.getGroup(), o.getRole()).addOverlooker(o);
            }
            catch (CGRNotAvailable cGRNotAvailable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    synchronized boolean removeOverlooker(AbstractAgent requester, Overlooker<? extends AbstractAgent> o) {
        Role r = o.getOverlookedRole();
        if (r != null) {
            r.removeOverlooker(o);
        }
        return this.operatingOverlookers.remove(o);
    }

    void removeCommunity(String community) {
        this.organizations.remove(community);
    }

    @Override
    public KernelAddress getKernelAddress() {
        return this.kernelAddress;
    }

    @Override
    public String getServerInfo() {
        if (this.netAgent != null) {
            return this.netAgent.getAgent().getServerInfo();
        }
        return "";
    }

    Set<Overlooker<? extends AbstractAgent>> getOperatingOverlookers() {
        return this.operatingOverlookers;
    }

    void removeAgentFromOrganizations(AbstractAgent theAgent) {
        for (Organization org : this.organizations.values()) {
            for (String groupName : org.removeAgentFromAllGroups(theAgent)) {
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.LEAVE_GROUP, new AgentAddress(theAgent, new Role(org.getName(), groupName), this.kernelAddress)), this.netUpdater);
            }
        }
    }

    @Override
    public MadkitProperties getMadkitConfig() {
        return this.platform.getConfigOption();
    }

    @Override
    MadkitKernel getMadkitKernel() {
        return this;
    }

    @Override
    public TreeSet<String> getExistingCommunities() {
        return new TreeSet<String>(this.organizations.keySet());
    }

    @Override
    public TreeSet<String> getExistingGroups(String community) {
        try {
            return new TreeSet<String>(this.getCommunity(community).keySet());
        }
        catch (CGRNotAvailable e) {
            return null;
        }
    }

    @Override
    public TreeSet<String> getExistingRoles(String community, String group) {
        try {
            return new TreeSet<String>(this.getGroup(community, group).keySet());
        }
        catch (CGRNotAvailable e) {
            return null;
        }
    }

    boolean isCommunity(AbstractAgent requester, String community) {
        try {
            return this.getCommunity(community) != null;
        }
        catch (CGRNotAvailable e) {
            return false;
        }
    }

    boolean isGroup(AbstractAgent requester, String community, String group) {
        try {
            return this.getGroup(community, group) != null;
        }
        catch (CGRNotAvailable e) {
            return false;
        }
    }

    boolean isRole(AbstractAgent requester, String community, String group, String role) {
        try {
            return this.getRole(community, group, role) != null;
        }
        catch (CGRNotAvailable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void importDistantOrg(Map<String, Map<String, Map<String, Set<AgentAddress>>>> distantOrg) {
        if (this.logger != null) {
            this.logger.finer("Importing org..." + distantOrg);
        }
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            for (String communityName : distantOrg.keySet()) {
                Organization org;
                Organization previous = this.organizations.putIfAbsent(communityName, org = new Organization(communityName, this));
                if (previous != null) {
                    org = previous;
                }
                org.importDistantOrg(distantOrg.get(communityName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Map<String, Map<String, Set<AgentAddress>>>> getOrganizationSnapShot(boolean global) {
        TreeMap<String, Map<String, Map<String, Set<AgentAddress>>>> export = new TreeMap<String, Map<String, Map<String, Set<AgentAddress>>>>();
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, Organization> org : this.organizations.entrySet()) {
                Map<String, Map<String, Set<AgentAddress>>> currentOrg = org.getValue().getOrgMap(global);
                if (currentOrg.isEmpty()) continue;
                export.put(org.getKey(), org.getValue().getOrgMap(global));
            }
        }
        return export;
    }

    final void injectMessage(ObjectMessage<Message> m) {
        block7: {
            Message toInject = m.getContent();
            AgentAddress receiver = toInject.getReceiver();
            AgentAddress sender = toInject.getSender();
            try {
                Role receiverRole = this.kernel.getRole(receiver.getCommunity(), receiver.getGroup(), receiver.getRole());
                receiver.setRoleObject(receiverRole);
                if (receiverRole == null) break block7;
                AbstractAgent target = receiverRole.getAbstractAgentWithAddress(receiver);
                if (target != null) {
                    receiver.setAgent(target);
                    try {
                        sender.setRoleObject(this.kernel.getRole(sender.getCommunity(), sender.getGroup(), sender.getRole()));
                    }
                    catch (CGRNotAvailable e) {
                        sender.setRoleObject(null);
                    }
                    target.receiveMessage(toInject);
                    if (this.hooks != null) {
                        this.informHooks(HookMessage.AgentActionEvent.SEND_MESSAGE, toInject);
                    }
                    break block7;
                }
                if (this.logger != null) {
                    this.logger.finer(m + " received but the agent address is no longer valid !! Current distributed org is " + this.getOrganizationSnapShot(false));
                }
            }
            catch (CGRNotAvailable e) {
                this.kernel.bugReport("Cannot inject " + m + "\n" + this.getOrganizationSnapShot(false), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void injectOperation(CGRSynchro m) {
        AgentAddress agentAddress = (AgentAddress)m.getContent();
        String communityName = agentAddress.getCommunity();
        String groupName = agentAddress.getGroup();
        String roleName = agentAddress.getRole();
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            switch (m.getCode()) {
                case CREATE_GROUP: {
                    Organization organization = null;
                    try {
                        organization = this.getCommunity(communityName);
                    }
                    catch (CGRNotAvailable e) {
                        organization = new Organization(communityName, this);
                        this.organizations.put(communityName, organization);
                    }
                    if (organization.putIfAbsent(groupName, new Group(communityName, groupName, agentAddress, organization)) != null) break;
                    this.informHooks(HookMessage.AgentActionEvent.CREATE_GROUP, agentAddress);
                    break;
                }
                case REQUEST_ROLE: {
                    try {
                        this.getGroup(communityName, groupName).addDistantMember(agentAddress);
                        this.informHooks(HookMessage.AgentActionEvent.REQUEST_ROLE, agentAddress);
                    }
                    catch (CGRNotAvailable e) {
                        this.logInjectOperationFailure(m, agentAddress, e);
                    }
                    break;
                }
                case LEAVE_ROLE: {
                    try {
                        this.getRole(communityName, groupName, roleName).removeDistantMember(agentAddress);
                        this.informHooks(HookMessage.AgentActionEvent.LEAVE_ROLE, agentAddress);
                    }
                    catch (CGRNotAvailable e) {
                        this.logInjectOperationFailure(m, agentAddress, e);
                    }
                    break;
                }
                case LEAVE_GROUP: {
                    try {
                        this.getGroup(communityName, groupName).removeDistantMember(agentAddress);
                        this.informHooks(HookMessage.AgentActionEvent.LEAVE_GROUP, agentAddress);
                    }
                    catch (CGRNotAvailable e) {
                        this.logInjectOperationFailure(m, agentAddress, e);
                    }
                    break;
                }
                default: {
                    this.bugReport(new UnsupportedOperationException("case not treated in injectOperation"));
                }
            }
        }
    }

    private void logInjectOperationFailure(CGRSynchro m, AgentAddress agentAddress, CGRNotAvailable e) {
        this.getLogger().log(Level.FINE, "distant CGR " + (Object)((Object)m.getCode()) + " update failed on " + agentAddress, e);
    }

    @Override
    void terminate() {
        super.terminate();
        if (Madkit.LevelOption.madkitLogLevel.getValue(this.getMadkitConfig()) != Level.OFF) {
            System.out.println("\n\t---------------------------------------\n\t         MaDKit Kernel " + this.kernelAddress + " \n\t        is shutting down, Bye !\n\t---------------------------------------\n");
        }
    }

    private void exit() {
        this.shuttedDown = true;
        this.sendNetworkMessageWithRole(new KernelMessage(KernelAction.EXIT, new Object[0]), this.kernelRole);
        this.broadcastMessageWithRole(this, "local", "gui", "manager", new KernelMessage(KernelAction.EXIT, new Object[0]), null);
        while (this.getAgentWithRole("local", "gui", "manager") != null) {
            this.pause(10);
        }
        if (this.logger != null) {
            this.logger.finer("***** SHUTINGDOWN MADKIT ********\n");
        }
        this.killAgents(true);
        this.killAgent(this);
    }

    private void launchNetwork() {
        this.updateNetworkAgent();
        if (this.netAgent == null) {
            NetworkAgent na = new NetworkAgent();
            AbstractAgent.ReturnCode r = this.launchAgent(na);
            this.threadedAgents.remove(na);
            if (r == AbstractAgent.ReturnCode.SUCCESS) {
                if (this.logger != null) {
                    this.logger.fine("\n\t****** Network agent launched ******\n");
                }
            } else if (this.logger != null) {
                this.logger.severe("\n\t****** Problem launching network agent ******\n");
            }
        } else if (this.sendNetworkMessageWithRole(new KernelMessage(KernelAction.LAUNCH_NETWORK, new Object[0]), this.kernelRole) == AbstractAgent.ReturnCode.SUCCESS) {
            if (this.logger != null) {
                this.logger.fine("\n\t****** Network agent up ******\n");
            }
        } else if (this.logger != null) {
            this.logger.fine("\n\t****** Problem relaunching network ******\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killAgents(boolean untilEmpty) {
        ArrayList<Agent> l;
        this.threadedAgents.remove(this);
        Set<Agent> set = this.threadedAgents;
        synchronized (set) {
            l = new ArrayList<Agent>(this.threadedAgents);
        }
        do {
            for (Agent a : l) {
                this.killAgent(this, a, 10);
            }
            this.pause(10);
        } while (untilEmpty && !this.threadedAgents.isEmpty());
    }

    boolean createGroupIfAbsent(AbstractAgent abstractAgent, String community, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        return this.createGroup(abstractAgent, community, group, gatekeeper, isDistributed) == AbstractAgent.ReturnCode.SUCCESS;
    }

    private void bugReport(Throwable e) {
        this.bugReport("", e);
    }

    private void bugReport(String m, Throwable e) {
        this.getMadkitKernel().getLogger().severeLog("********************** KERNEL PROBLEM, please bug report " + m, e);
    }

    final synchronized void removeAgentsFromDistantKernel(KernelAddress kernelAddress2) {
        for (Organization org : this.organizations.values()) {
            org.removeAgentsFromDistantKernel(kernelAddress2);
        }
    }

    synchronized AbstractAgent.ReturnCode destroyCommunity(AbstractAgent abstractAgent, String community) {
        try {
            this.getCommunity(community).destroy();
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    synchronized AbstractAgent.ReturnCode destroyGroup(AbstractAgent abstractAgent, String community, String group) {
        try {
            this.getGroup(community, group).destroy();
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    synchronized AbstractAgent.ReturnCode destroyRole(AbstractAgent abstractAgent, String community, String group, String role) {
        try {
            this.getRole(community, group, role).destroy();
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThreadedAgent(Agent myAgent) {
        Set<Agent> set = this.threadedAgents;
        synchronized (set) {
            this.threadedAgents.remove(myAgent);
            if (this.logger != null) {
                this.logger.finest(this.threadedAgents.toString());
            }
        }
    }

    AgentAddress getAgentAddressIn(AbstractAgent agent, String community, String group, String role) {
        try {
            return this.getRole(community, group, role).getAgentAddressOf(agent);
        }
        catch (CGRNotAvailable e) {
            if (agent.isWarningOn()) {
                agent.setAgentStackTrace(e);
                agent.handleException(AbstractAgent.Influence.GET_AGENT_ADDRESS_IN, new OrganizationWarning(e.getCode(), community, group, role));
            }
            return null;
        }
    }

    final boolean isHooked() {
        return this.hooks != null;
    }

    final TreeSet<String> getGroupsOf(AbstractAgent abstractAgent, String community) {
        TreeSet<String> groups = new TreeSet<String>();
        try {
            for (Group g : this.getCommunity(community).values()) {
                if (!g.isIn(abstractAgent)) continue;
                groups.add(g.getName());
            }
        }
        catch (CGRNotAvailable e) {
            return null;
        }
        return groups;
    }

    final TreeSet<String> getRolesOf(AbstractAgent abstractAgent, String community, String group) {
        TreeSet<String> roles = new TreeSet<String>();
        try {
            for (Role r : this.getGroup(community, group).values()) {
                if (!r.contains(abstractAgent)) continue;
                roles.add(r.getRoleName());
            }
        }
        catch (CGRNotAvailable e) {
            return null;
        }
        return roles;
    }

    static {
        serviceExecutor.prestartAllCoreThreads();
        serviceExecutor.allowCoreThreadTimeOut(true);
    }
}

