/*
 * Decompiled with CFR 0.152.
 */
package madkit.marketorg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.gui.OutputPanel;
import madkit.kernel.Agent;
import madkit.kernel.Madkit;
import madkit.kernel.Message;
import madkit.marketorg.Broker;
import madkit.marketorg.Provider;
import madkit.message.StringMessage;

public class Client
extends Agent {
    static int nbOfClientsOnScreen = 0;
    private JPanel blinkPanel;
    private static ImageIcon clientImage = new ImageIcon(new ImageIcon(Client.class.getResource("images/client.png")).getImage().getScaledInstance(70, 70, 4));
    private String product = Provider.availableTransports.get((int)(Math.random() * (double)Provider.availableTransports.size()));

    @Override
    protected void activate() {
        this.createGroupIfAbsent("travel", "travel-clients", true, null);
        this.requestRole("travel", "travel-clients", "client", null);
        int pause = 1000 + (int)(Math.random() * 2000.0);
        if (this.logger != null) {
            this.logger.info("I will be looking for a " + this.product + " in " + pause + " ms !");
        }
        this.pause(pause);
    }

    @Override
    protected void live() {
        boolean haveTicket = false;
        while (!haveTicket) {
            Message brokerAnswer = null;
            while (brokerAnswer == null) {
                brokerAnswer = this.sendMessageWithRoleAndWaitForReply("travel", "travel-clients", "broker", new StringMessage(this.product), "client", 1000);
                if (this.logger != null && brokerAnswer == null) {
                    this.logger.info("For now there is nothing for me :(");
                }
                this.pause(500);
            }
            this.logFindBroker(brokerAnswer);
            haveTicket = this.buyTicket((StringMessage)brokerAnswer);
        }
    }

    @Override
    protected void end() {
        if (this.logger != null) {
            this.logger.info("I will quit soon now, buit I will launch another one like me !");
        }
        this.pause((int)(Math.random() * 2000.0 + 500.0));
        this.launchAgent(new Client(), 4, true);
    }

    private void logFindBroker(Message brokerAnswer) {
        if (this.logger != null) {
            this.logger.info("I found a broker : " + brokerAnswer.getSender());
        }
        if (this.blinkPanel != null) {
            this.blinkPanel.setBackground(Color.YELLOW);
            this.pause(1000);
        }
    }

    private boolean buyTicket(StringMessage brokerAnswer) {
        String contractGroupID = (String)brokerAnswer.getContent();
        this.requestRole("travel", contractGroupID, "client");
        Message ticket = this.sendMessageAndWaitForReply("travel", contractGroupID, "provider", new StringMessage("money"), 4000);
        if (ticket != null) {
            if (this.logger != null) {
                this.logger.info("Yeeeaah: I have my ticket :) ");
            }
            if (this.hasGUI()) {
                this.blinkPanel.setBackground(Color.GREEN);
            }
            this.leaveGroup("travel", "travel-clients");
            this.pause((int)(1000.0 + Math.random() * 2000.0));
            return true;
        }
        return false;
    }

    @Override
    public void setupFrame(JFrame frame) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new OutputPanel(this), "Center");
        this.blinkPanel = new JPanel();
        this.blinkPanel.add(new JLabel(clientImage));
        this.blinkPanel.add(new JLabel(new ImageIcon(this.getClass().getResource("images/" + this.product + ".png"))));
        p.add((Component)this.blinkPanel, "North");
        p.validate();
        frame.add(p);
        int xLocation = nbOfClientsOnScreen++ * 390;
        if ((double)(xLocation + 390) > Toolkit.getDefaultToolkit().getScreenSize().getWidth()) {
            nbOfClientsOnScreen = 0;
        }
        frame.setLocation(xLocation, 0);
        frame.setSize(390, 300);
    }

    public static void main(String[] args) {
        nbOfClientsOnScreen = 0;
        Broker.nbOfBrokersOnScreen = 0;
        new Madkit(Madkit.Option.launchAgents.toString(), Broker.class.getName() + ",true,3;" + Client.class.getName() + ",true,2;" + Provider.class.getName() + ",true,7");
    }
}

