/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.util.logging.Level;
import madkit.action.SchedulingAction;
import madkit.bees.AbstractBee;
import madkit.bees.BeeViewer;
import madkit.kernel.Message;
import madkit.kernel.Scheduler;
import madkit.message.ObjectMessage;
import madkit.message.SchedulingMessage;
import madkit.simulation.activator.GenericBehaviorActivator;

public class BeeScheduler
extends Scheduler {
    private static final long serialVersionUID = -6881984366833257439L;
    private String community;
    private GenericBehaviorActivator<AbstractBee> bees;
    private GenericBehaviorActivator<BeeViewer> viewer;

    BeeScheduler(String community) {
        this.community = community;
    }

    @Override
    public void activate() {
        super.activate();
        this.getLogger().setWarningLogLevel(Level.INFO);
        this.setLogLevel(Level.ALL);
        this.setLogLevel(Level.OFF);
        this.requestRole("buzz", "bees", "scheduler", null);
        this.bees = new GenericBehaviorActivator(this.community, "bees", "bee", "buzz");
        this.addActivator(this.bees);
        this.viewer = new GenericBehaviorActivator(this.community, "bees", "bee observer", "observe");
        this.addActivator(this.viewer);
        this.setDelay(20);
        this.setDelay(0);
        this.receiveMessage(new SchedulingMessage(SchedulingAction.RUN, new Object[0]));
    }

    @Override
    protected void checkMail(Message m) {
        if (m != null) {
            try {
                boolean mutiCore = (Boolean)((ObjectMessage)m).getContent();
                if (mutiCore) {
                    this.bees.useMulticore(Runtime.getRuntime().availableProcessors());
                } else {
                    this.bees.useMulticore(1);
                }
            }
            catch (ClassCastException e) {
                super.checkMail(m);
            }
        }
    }
}

