/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.awt.Point;
import java.util.List;
import madkit.bees.AbstractBee;
import madkit.bees.BeeInformation;
import madkit.kernel.AgentAddress;
import madkit.message.ObjectMessage;

public class Bee
extends AbstractBee {
    private static final long serialVersionUID = -2393301912353816186L;
    BeeInformation leaderInfo = null;
    AgentAddress leader = null;

    @Override
    public void buzz() {
        this.updateLeader();
        super.buzz();
    }

    @Override
    protected void computeNewVelocities() {
        int dty;
        int dtx;
        Point location = this.myInformation.getCurrentPosition();
        int acc = 0;
        if (this.beeWorld != null) {
            acc = this.beeWorld.getBeeAcceleration().getValue();
        }
        if (this.leaderInfo != null) {
            Point leaderLocation = this.leaderInfo.getCurrentPosition();
            if (this.logger != null) {
                this.logger.finer("following leader :" + leaderLocation);
            }
            dtx = leaderLocation.x - location.x;
            dty = leaderLocation.y - location.y;
        } else {
            dtx = generator.nextInt(5);
            dty = generator.nextInt(5);
            if (generator.nextBoolean()) {
                dtx = -dtx;
                dty = -dty;
            }
        }
        int dist = Math.abs(dtx) + Math.abs(dty);
        if (dist == 0) {
            dist = 1;
        }
        this.dX += dtx * acc / dist + this.randomFromRange(2);
        this.dY += dty * acc / dist + this.randomFromRange(2);
    }

    private void updateLeader() {
        ObjectMessage m = (ObjectMessage)this.nextMessage();
        if (m == null) {
            return;
        }
        if (m.getSender().equals(this.leader)) {
            if (this.logger != null) {
                this.logger.info("my leader is getting out of the game");
            }
            this.leader = null;
            this.leaderInfo = null;
        } else {
            if (this.logger != null) {
                this.logger.fine("A leader has appeared or disappeared ");
            }
            if (this.leader == null) {
                this.followNewLeader(m);
            } else {
                List<AgentAddress> queens = this.getAgentsWithRole("buzz", "bees", "queen");
                if (queens != null && generator.nextDouble() < 1.0 / (double)queens.size()) {
                    this.followNewLeader(m);
                }
            }
        }
    }

    private void followNewLeader(ObjectMessage<BeeInformation> leaderMessage) {
        this.leader = leaderMessage.getSender();
        this.leaderInfo = leaderMessage.getContent();
        this.myInformation.setBeeColor(this.leaderInfo.getBeeColor());
    }

    @Override
    public void activate() {
        this.requestRole("buzz", "bees", "bee", null);
        this.requestRole("buzz", "bees", "follower", null);
    }

    @Override
    protected int getMaxVelocity() {
        if (this.beeWorld != null) {
            return this.beeWorld.getBeeVelocity().getValue();
        }
        return 0;
    }
}

