/*
 * Decompiled with CFR 0.152.
 */
package madkit.action;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class ActionInfo {
    private static final String IMAGE_DIR = "/madkit/action/images/";
    private final int keyEvent;
    private ImageIcon bigIcon;
    private ImageIcon smallIcon;
    private String name;
    private final String shortDescription;
    private final String longDescription;

    public <E extends Enum<E>> ActionInfo(E enumAction, int keyEvent, ResourceBundle resource) {
        this(enumAction.name(), keyEvent, resource);
    }

    public ActionInfo(String codeName, int keyEvent, ResourceBundle resource) {
        this.name = codeName;
        this.keyEvent = keyEvent;
        this.setIcon(this.name);
        String[] codes = null;
        try {
            codes = resource.getString(codeName).split(";");
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        if (codes != null) {
            this.shortDescription = codes.length > 1 ? codes[1] : codes[0];
            this.longDescription = codes.length > 2 ? codes[2] : this.shortDescription;
            this.name = codes[0];
        } else {
            this.shortDescription = this.longDescription = this.name;
        }
    }

    void setIcon(String fileName) {
        URL imageUrl = this.getClass().getResource(IMAGE_DIR + fileName + ".png");
        if (imageUrl != null) {
            this.bigIcon = new ImageIcon(imageUrl);
            this.smallIcon = this.bigIcon.getIconWidth() > 16 ? new ImageIcon(this.bigIcon.getImage().getScaledInstance(16, 16, 4)) : this.bigIcon;
        } else {
            this.smallIcon = null;
            this.bigIcon = null;
        }
    }

    public int getKeyEvent() {
        return this.keyEvent;
    }

    public ImageIcon getBigIcon() {
        return this.bigIcon;
    }

    public ImageIcon getSmallIcon() {
        return this.smallIcon;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public static <E extends Enum<E>> String enumToMethodName(E e) {
        String[] tab = e.name().split("_");
        String methodName = tab[0].toLowerCase();
        for (int i = 1; i < tab.length; ++i) {
            String s = tab[i];
            methodName = methodName + s.charAt(0) + s.substring(1).toLowerCase();
        }
        return methodName;
    }
}

