/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import madkit.i18n.I18nUtilities;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentExecutor;
import madkit.kernel.Message;
import madkit.kernel.SelfKillException;
import madkit.message.ConversationFilter;
import madkit.message.MessageFilter;

public class Agent
extends AbstractAgent {
    Thread myThread;
    private final AgentExecutor agentExecutor;
    private final boolean isDaemon;

    public Agent(boolean isDaemon) {
        this.isDaemon = isDaemon;
        this.agentExecutor = new AgentExecutor(this);
    }

    public Agent() {
        this(false);
    }

    public void setThreadPriority(int newPriority) {
        if (this.myThread != null) {
            this.myThread.setPriority(newPriority);
        }
    }

    public int getThreadPriority() {
        if (this.myThread != null) {
            return this.myThread.getPriority();
        }
        return 5;
    }

    Agent(Object o) {
        super(o);
        this.isDaemon = false;
        this.agentExecutor = null;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    final AgentExecutor getAgentExecutor() {
        return this.agentExecutor;
    }

    @Override
    final void suicide(SelfKillException e) {
        this.getAgentExecutor().getLiveProcess().cancel(false);
        this.getAgentExecutor().getEndProcess().cancel(false);
        super.suicide(e);
        this.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean living() {
        try {
            this.state.set(AbstractAgent.State.LIVING);
            this.setMyThread(Thread.currentThread());
            this.logMethod(true);
            try {
                this.live();
            }
            catch (SelfKillException e) {
                this.suicide(e);
            }
            catch (Throwable e) {
                AtomicReference atomicReference = this.state;
                synchronized (atomicReference) {
                    this.logLifeException(e);
                    this.alive.set(false);
                }
            }
            if (!this.alive.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (ThreadDeath e) {
            this.logLifeException(e);
        }
        this.logMethod(false);
        return true;
    }

    protected void live() {
        this.setLogLevel(Level.INFO);
        this.logger.talk("\n\tHi Human and hello World !!\n\n I am an instance of the madkit.kernel.Agent class\n As such, I am a MaDKit threaded Agent\n and thus have an autonomous activity!");
        this.pause(5000);
        this.logger.talk("\n\n And in fact, I am the simplest agent ever\n because I simply do nothing at all :)\n\n");
        this.pause(4000);
        int i = (int)(Math.random() * 3000.0 + 4500.0);
        this.logger.info("I will quit in " + i + " milliseconds... Bye !");
        this.pause(i);
    }

    @Override
    public AbstractAgent.ReturnCode killAgent(AbstractAgent target, int timeOutSeconds) {
        if (target == this && this.myThread == Thread.currentThread() && this.alive.compareAndSet(true, false)) {
            throw new SelfKillException(timeOutSeconds);
        }
        return super.killAgent(target, timeOutSeconds);
    }

    public Message sendMessageAndWaitForReply(AgentAddress receiver, Message messageToSend) {
        return this.sendMessageWithRoleAndWaitForReply(receiver, messageToSend, null, null);
    }

    public Message sendMessageAndWaitForReply(AgentAddress receiver, Message messageToSend, int timeOutMilliSeconds) {
        return this.sendMessageWithRoleAndWaitForReply(receiver, messageToSend, null, timeOutMilliSeconds);
    }

    public Message sendMessageWithRoleAndWaitForReply(AgentAddress receiver, Message messageToSend, String senderRole) {
        return this.sendMessageWithRoleAndWaitForReply(receiver, messageToSend, senderRole, null);
    }

    public Message sendMessageWithRoleAndWaitForReply(AgentAddress receiver, Message messageToSend, String senderRole, Integer timeOutMilliSeconds) {
        if (this.logger != null) {
            this.logger.finest("sendMessageAndWaitForReply : sending " + messageToSend + " to " + receiver + ", and waiting reply...");
        }
        if (this.getKernel().sendMessage(this, receiver, messageToSend, senderRole) != AbstractAgent.ReturnCode.SUCCESS) {
            return null;
        }
        return this.waitAnswer(messageToSend, timeOutMilliSeconds);
    }

    public Message sendMessageAndWaitForReply(String community, String group, String role, Message messageToSend) {
        return this.sendMessageWithRoleAndWaitForReply(community, group, role, messageToSend, null, null);
    }

    public Message sendMessageWithRoleAndWaitForReply(String community, String group, String role, Message messageToSend, String senderRole) {
        return this.sendMessageWithRoleAndWaitForReply(community, group, role, messageToSend, senderRole, null);
    }

    public Message sendMessageAndWaitForReply(String community, String group, String role, Message messageToSend, int timeOutMilliSeconds) {
        return this.sendMessageWithRoleAndWaitForReply(community, group, role, messageToSend, null, timeOutMilliSeconds);
    }

    public Message sendMessageWithRoleAndWaitForReply(String community, String group, String role, Message messageToSend, String senderRole, Integer timeOutMilliSeconds) {
        if (this.logger != null) {
            this.logger.finest("sendMessageAndWaitForReply : sending " + messageToSend + " to any " + I18nUtilities.getCGRString(community, group, role) + (timeOutMilliSeconds == null ? "" : ", and waiting reply for " + TimeUnit.MILLISECONDS.toSeconds(timeOutMilliSeconds.intValue()) + " s..."));
        }
        if (this.getKernel().sendMessage(this, community, group, role, messageToSend, senderRole) != AbstractAgent.ReturnCode.SUCCESS) {
            return null;
        }
        return this.waitAnswer(messageToSend, timeOutMilliSeconds);
    }

    public Message sendReplyAndWaitForReply(Message messageToReplyTo, Message reply) {
        return this.sendReplyWithRoleAndWaitForReply(messageToReplyTo, reply, null, null);
    }

    public Message sendReplyAndWaitForReply(Message messageToReplyTo, Message reply, int timeOutMilliSeconds) {
        return this.sendReplyWithRoleAndWaitForReply(messageToReplyTo, reply, null, timeOutMilliSeconds);
    }

    public Message sendReplyWithRoleAndWaitForReply(Message messageToReplyTo, Message reply, String senderRole) {
        return this.sendReplyWithRoleAndWaitForReply(messageToReplyTo, reply, senderRole, null);
    }

    public Message sendReplyWithRoleAndWaitForReply(Message messageToReplyTo, Message reply, String senderRole, Integer timeOutMilliSeconds) {
        if (this.sendReplyWithRole(messageToReplyTo, reply, senderRole) != AbstractAgent.ReturnCode.SUCCESS) {
            return null;
        }
        if (this.logger != null) {
            this.logger.finest("sendReplyAndWaitForReply : sending " + reply + " as reply to " + messageToReplyTo + ", and waiting reply...");
        }
        return this.waitAnswer(reply, timeOutMilliSeconds);
    }

    public List<Message> broadcastMessageWithRoleAndWaitForReplies(String community, String group, String role, Message message, String senderRole, Integer timeOutMilliSeconds) {
        return this.getKernel().broadcastMessageWithRoleAndWaitForReplies(this, community, group, role, message, senderRole, timeOutMilliSeconds);
    }

    public Message waitNextMessage() {
        if (this.logger != null) {
            this.logger.finest("waitNextMessage...");
            Message m = this.waitingNextMessageForEver();
            if (this.logger != null) {
                this.logger.finest("..." + (Object)((Object)Words.NEW_MSG) + ": " + m);
            }
            return m;
        }
        return this.waitingNextMessageForEver();
    }

    public Message waitNextMessage(long timeOutMilliseconds) {
        if (this.logger != null) {
            this.logger.finest("Waiting next message during " + timeOutMilliseconds + " milliseconds...");
            Message m = this.waitingNextMessage(timeOutMilliseconds, TimeUnit.MILLISECONDS);
            if (m != null) {
                this.logger.finest("waitNextMessage->" + (Object)((Object)Words.NEW_MSG) + ": " + m);
            } else {
                this.logger.finest("waitNextMessage time out !");
            }
            return m;
        }
        return this.waitingNextMessage(timeOutMilliseconds, TimeUnit.MILLISECONDS);
    }

    public Message waitNextMessage(MessageFilter filter) {
        ArrayList<Message> receptions = new ArrayList<Message>();
        Message m = this.waitingNextMessageForEver();
        while (!filter.accept(m)) {
            receptions.add(m);
            m = this.waitingNextMessageForEver();
        }
        this.addAllToMessageBox(receptions);
        if (this.logger != null) {
            this.logger.finest("a match has arrived " + m);
        }
        return m;
    }

    public Message waitNextMessage(Integer timeOutMilliseconds, MessageFilter filter) {
        if (timeOutMilliseconds == null) {
            return this.waitNextMessage(filter);
        }
        long timeOutNanos = TimeUnit.MILLISECONDS.toNanos(timeOutMilliseconds.intValue());
        ArrayList<Message> receptions = new ArrayList<Message>();
        long endTime = System.nanoTime() + timeOutNanos;
        Message answer = this.waitingNextMessage(timeOutNanos, TimeUnit.NANOSECONDS);
        while (answer != null && !filter.accept(answer)) {
            receptions.add(answer);
            answer = this.waitingNextMessage(endTime - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
        this.addAllToMessageBox(receptions);
        if (this.logger != null) {
            this.logger.finest(answer == null ? "...Waiting time out, no compliant message received" : "...a match has arrived : " + answer);
        }
        return answer;
    }

    protected void pause(int milliSeconds) {
        if (milliSeconds > 0) {
            if (this.logger != null) {
                this.logger.finest((Object)((Object)Words.PAUSE) + " " + milliSeconds + " ms.");
            }
            try {
                Thread.sleep(milliSeconds);
            }
            catch (InterruptedException e) {
                this.handleInterruptedException();
            }
        }
    }

    private Message waitingNextMessageForEver() {
        try {
            return (Message)this.messageBox.take();
        }
        catch (InterruptedException e) {
            this.handleInterruptedException();
            return null;
        }
    }

    public Message waitAnswer(Message query) {
        return this.waitNextMessage(new ConversationFilter(query));
    }

    public Message waitAnswer(Message query, Integer timeOutMilliSeconds) {
        return this.waitNextMessage(timeOutMilliSeconds, new ConversationFilter(query));
    }
}

