/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.Scanner;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentLogger;

public class OutputPanel
extends JPanel {
    private static final long serialVersionUID = 602152712654986449L;
    private OutputStream out;
    private final JTextArea outField = new JTextArea(5, 32);

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputPanel(AbstractAgent agent) {
        this.setLayout(new BorderLayout());
        this.outField.setEditable(false);
        this.setPreferredSize(new Dimension(250, 100));
        this.setBackground(Color.WHITE);
        try {
            final PipedInputStream inPipe = new PipedInputStream();
            this.out = new PipedOutputStream(inPipe);
            new SwingWorker<Void, String>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Scanner s = new Scanner(inPipe);
                    while (s.hasNextLine()) {
                        String line = s.nextLine();
                        this.publish(line + "\n");
                    }
                    s.close();
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String line : chunks) {
                        OutputPanel.this.outField.append(line);
                    }
                }
            }.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StreamHandler handler = new StreamHandler(this.out, AgentLogger.AGENT_FILE_FORMATTER){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        agent.getLogger().addHandler(handler);
        this.add("Center", new JScrollPane(this.outField));
        JButton b = new JButton("clear");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.clearOutput();
            }
        });
        this.add("South", b);
        this.setBackground(Color.WHITE);
    }

    public void clearOutput() {
        this.outField.setText(null);
    }

    @Override
    public void setBackground(Color bg) {
        if (this.outField != null) {
            this.outField.setBackground(bg);
        }
        super.setBackground(bg);
    }
}

