/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentFormatter;
import madkit.kernel.Madkit;
import madkit.util.MadkitProperties;

public final class AgentLogger
extends Logger {
    public static final Formatter AGENT_FORMATTER = new AgentFormatter();
    public static final Formatter AGENT_FILE_FORMATTER = new AgentFormatter(){

        @Override
        protected String getHeader(LogRecord record) {
            return "";
        }
    };
    static final AgentLogger DEFAULT_AGENT_LOGGER = new AgentLogger();
    static final Level TALK_LEVEL = Level.parse("1100");
    private static final Map<AbstractAgent, AgentLogger> AGENT_LOGGERS = new ConcurrentHashMap<AbstractAgent, AgentLogger>();
    private FileHandler fh;
    private final AbstractAgent myAgent;
    private Level warningLogLevel = Madkit.LevelOption.warningLogLevel.getValue(Madkit.DEFAULT_CONFIG);

    static final AgentLogger getLogger(AbstractAgent agent) {
        AgentLogger al = AGENT_LOGGERS.get(agent);
        if (al == null) {
            al = new AgentLogger(agent);
            AGENT_LOGGERS.put(agent, al);
        }
        return al;
    }

    public Level getWarningLogLevel() {
        return this.warningLogLevel;
    }

    public void setWarningLogLevel(Level warningLogLevel) {
        this.warningLogLevel = Objects.requireNonNull(warningLogLevel);
        AgentLogLevelMenu.update(this.myAgent);
    }

    private AgentLogger() {
        super("[UNREGISTERED AGENT]", null);
        this.myAgent = null;
        this.setUseParentHandlers(false);
        super.setLevel(Madkit.LevelOption.agentLogLevel.getValue(Madkit.DEFAULT_CONFIG));
        if (!Madkit.BooleanOption.noAgentConsoleLog.isActivated(Madkit.DEFAULT_CONFIG)) {
            this.addHandler(new ConsoleHandler());
        }
    }

    private AgentLogger(AbstractAgent agent) {
        super("[" + agent.getName() + "]", null);
        this.myAgent = agent;
        this.setUseParentHandlers(false);
        MadkitProperties madkitConfig = this.myAgent.getMadkitConfig();
        Level l = this.myAgent.logger == null ? Level.OFF : Madkit.LevelOption.agentLogLevel.getValue(madkitConfig);
        super.setLevel(l);
        this.setWarningLogLevel(Madkit.LevelOption.warningLogLevel.getValue(madkitConfig));
        if (!Madkit.BooleanOption.noAgentConsoleLog.isActivated(madkitConfig)) {
            ConsoleHandler ch = new ConsoleHandler();
            this.addHandler(ch);
            ch.setFormatter(AGENT_FORMATTER);
        }
        if (Madkit.BooleanOption.createLogFiles.isActivated(madkitConfig) && agent.getMadkitKernel() != agent) {
            this.createLogFile();
        }
    }

    public void createLogFile() {
        if (this.fh == null) {
            String logDir = this.myAgent.getMadkitConfig().getProperty(Madkit.Option.logDirectory.name());
            new File(logDir).mkdirs();
            String logFileName = logDir + File.separator + this.getName();
            final File logFile = new File(logFileName);
            String lineSeparator = "----------------------------------------------------------------------\n";
            final String logSession = "----------------------------------------------------------------------\n-- Log session for " + logFileName.substring(logFileName.lastIndexOf(File.separator) + 1);
            String logEnd = " --\n----------------------------------------------------------------------\n\n";
            final Date date = new Date();
            try (FileWriter fw = new FileWriter(logFile, true);){
                fw.write(logSession + " started on " + Madkit.DATE_FORMAT.format(date) + " --\n----------------------------------------------------------------------\n\n");
                this.fh = new FileHandler(logFileName, true){

                    @Override
                    public synchronized void close() throws SecurityException {
                        super.close();
                        try (FileWriter fw2 = new FileWriter(logFile, true);){
                            date.setTime(System.currentTimeMillis());
                            fw2.write("\n\n" + logSession + " closed on  " + Madkit.DATE_FORMAT.format(date) + " --\n----------------------------------------------------------------------\n\n");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.fh.setFormatter(AGENT_FILE_FORMATTER);
            }
            catch (IOException | SecurityException e) {
                e.printStackTrace();
            }
            this.addHandler(this.fh);
        }
    }

    final synchronized void close() {
        for (Handler h : this.getHandlers()) {
            this.removeHandler(h);
            h.close();
        }
        AGENT_LOGGERS.remove(this.myAgent);
    }

    @Override
    public synchronized void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
        handler.setLevel(this.getLevel());
    }

    static void resetLoggers() {
        for (AgentLogger l : AGENT_LOGGERS.values()) {
            l.close();
        }
    }

    public void talk(String msg) {
        if (this.getLevel() == Level.OFF) {
            System.out.print(msg);
        } else {
            this.log(TALK_LEVEL, msg);
        }
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(Objects.requireNonNull(newLevel));
        for (Handler h : this.getHandlers()) {
            h.setLevel(newLevel);
        }
        if (this.myAgent.hasGUI()) {
            AgentLogLevelMenu.update(this.myAgent);
        }
    }

    public String toString() {
        return this.getName() + " logger: \n\tlevel " + this.getLevel() + "\n\twarningLogLevel " + this.getWarningLogLevel();
    }

    @Override
    public void log(LogRecord record) {
        Throwable t = record.getThrown();
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            record.setMessage(record.getMessage() + "\n ** " + sw);
        }
        super.log(record);
    }

    public void severeLog(String msg, Throwable t) {
        Level lvl;
        AgentLogger l = this.myAgent.getMadkitKernel().logger;
        if (l != null) {
            l.log(Level.FINEST, "log for " + this.myAgent + "\n" + msg, t);
        }
        if (t != null) {
            this.myAgent.setAgentStackTrace(t);
        }
        if ((lvl = this.getLevel()) == Level.OFF) {
            this.setLevel(Level.ALL);
        }
        if (t != null) {
            this.log(Level.SEVERE, msg, t);
        } else {
            this.log(Level.SEVERE, msg);
        }
        this.setLevel(lvl);
    }

    public void severeLog(String msg) {
        this.severeLog(msg, null);
    }

    public static void setAllLogLevels(Level level) {
        for (AbstractAgent loggedAgent : AGENT_LOGGERS.keySet()) {
            if (loggedAgent != loggedAgent.getMadkitKernel()) {
                loggedAgent.setLogLevel(level);
                continue;
            }
            loggedAgent.setMadkitProperty(Madkit.LevelOption.agentLogLevel.name(), level.toString());
        }
    }

    public static void createLogFiles() {
        try {
            AbstractAgent a = new ArrayList<AbstractAgent>(AGENT_LOGGERS.keySet()).get(0);
            a.setMadkitProperty(Madkit.BooleanOption.createLogFiles.name(), "true");
            JOptionPane.showMessageDialog(null, (Object)((Object)Words.DIRECTORY) + " " + new File(a.getMadkitProperty(Madkit.Option.logDirectory)).getAbsolutePath() + " " + (Object)((Object)Words.CREATED), "OK", 1);
            for (AgentLogger logger : AGENT_LOGGERS.values()) {
                logger.createLogFile();
            }
        }
        catch (IndexOutOfBoundsException e) {
            JOptionPane.showMessageDialog(null, "No active agents yet", Words.FAILED.toString(), 2);
        }
    }
}

