/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import madkit.action.KernelAction;
import madkit.gui.AgentStatusPanel;
import madkit.gui.PrintableFrame;
import madkit.gui.SwingUtil;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.gui.menu.AgentMenu;
import madkit.gui.menu.DisplayMenu;
import madkit.gui.menu.HelpMenu;
import madkit.gui.menu.MadkitMenu;
import madkit.kernel.AbstractAgent;
import madkit.message.KernelMessage;

public class AgentFrame
extends JFrame
implements PrintableFrame {
    private static final long serialVersionUID = 6337250099157352055L;
    private JInternalFrame internalFrame;
    private final AbstractAgent agent;
    private final String classUIPreferenceCodeBase;
    private final String agentUIPreferenceCodeBase;

    protected AgentFrame(final AbstractAgent agent) {
        super(agent.getName());
        this.agent = agent;
        this.classUIPreferenceCodeBase = agent.getClass().getName();
        this.agentUIPreferenceCodeBase = agent.getName();
        this.setIconImage(SwingUtil.MADKIT_LOGO.getImage());
        this.setJMenuBar(this.createMenuBar());
        JToolBar tb = this.createJToolBar();
        if (tb != null) {
            this.add((Component)tb, "First");
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                this.closeProcess();
            }

            private void closeProcess() {
                if (agent.isAlive()) {
                    AgentFrame.this.setTitle("Closing " + agent.getName());
                    AgentFrame.killAgent(agent, 4);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.closeProcess();
            }
        });
        this.restoreUIPreferences();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Component component = e.getComponent();
                SwingUtil.UI_PREFERENCES.putInt(AgentFrame.this.agentUIPreferenceCodeBase + "_X", component.getX());
                SwingUtil.UI_PREFERENCES.putInt(AgentFrame.this.agentUIPreferenceCodeBase + "_Y", component.getY());
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Component component = e.getComponent();
                SwingUtil.UI_PREFERENCES.putInt(AgentFrame.this.agentUIPreferenceCodeBase + "_W", component.getWidth());
                SwingUtil.UI_PREFERENCES.putInt(AgentFrame.this.agentUIPreferenceCodeBase + "_H", component.getHeight());
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("background")) {
                    SwingUtil.UI_PREFERENCES.putInt(AgentFrame.this.classUIPreferenceCodeBase + "_BGC", AgentFrame.this.getBackground().getRGB());
                }
            }
        });
    }

    @Override
    public void dispose() {
        if (this.internalFrame != null) {
            this.internalFrame.dispose();
        }
        super.dispose();
    }

    public Dimension getLastSavedDimensionPreference() {
        return new Dimension(SwingUtil.UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_W", 400), SwingUtil.UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_H", 300));
    }

    public Point getLastSavedLocationPreference() {
        return new Point(SwingUtil.UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_X", -1), SwingUtil.UI_PREFERENCES.getInt(this.agentUIPreferenceCodeBase + "_Y", -1));
    }

    public Color getLastSavedBackgroundPreference() {
        return new Color(SwingUtil.UI_PREFERENCES.getInt(this.classUIPreferenceCodeBase + "_BGC", Color.WHITE.getRGB()));
    }

    public void restoreUIPreferences() {
        Color lastSavedBackgroundPreference = this.getLastSavedBackgroundPreference();
        this.setBackground(lastSavedBackgroundPreference);
        this.setSize(this.getLastSavedDimensionPreference());
        this.setLocation(this.getLastSavedLocationPreference());
        if (this.getLocation().equals(new Point(-1, -1))) {
            this.setLocationRelativeTo(null);
        }
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new MadkitMenu(this.agent));
        menuBar.add(new AgentMenu(this.agent));
        menuBar.add(new AgentLogLevelMenu(this.agent));
        menuBar.add(new DisplayMenu(this));
        menuBar.add(new HelpMenu());
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(new AgentStatusPanel(this.agent));
        return menuBar;
    }

    public JToolBar createJToolBar() {
        return null;
    }

    void setInternalFrame(JInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
        for (ComponentListener l : this.getComponentListeners()) {
            this.internalFrame.addComponentListener(l);
        }
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        if (this.internalFrame != null) {
            this.internalFrame.setLocation(x, y);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.internalFrame != null) {
            this.internalFrame.setSize(width, height);
        }
    }

    @Override
    public void pack() {
        super.pack();
        if (this.internalFrame != null) {
            this.internalFrame.pack();
        }
    }

    static void killAgent(AbstractAgent agent, int timeOutSeconds) {
        if (agent.isAlive()) {
            agent.sendMessage("local", "system", "manager", new KernelMessage(KernelAction.KILL_AGENT, agent, timeOutSeconds));
        }
    }

    public AbstractAgent getAgent() {
        return this.agent;
    }

    public static AgentFrame createAgentFrame(AbstractAgent agent) {
        return new AgentFrame(agent);
    }

    @Override
    public String toString() {
        return "AFrame for " + this.agent + " " + super.toString();
    }

    @Override
    public Container getPrintableContainer() {
        if (this.internalFrame != null) {
            return this.internalFrame.getDesktopPane().getTopLevelAncestor();
        }
        return this;
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        this.getContentPane().setBackground(bgColor);
    }
}

