/*
 * Decompiled with CFR 0.152.
 */
package madkit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import madkit.i18n.ErrorMessages;
import madkit.kernel.MadkitClassLoader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MadkitProperties
extends Properties {
    private static final long serialVersionUID = 1964226720362899440L;
    private static final Logger logger = Logger.getLogger(MadkitProperties.class.getName());
    public static final boolean JAVAWS_IS_ON = System.getProperty("javawebstart.version") != null;

    public void loadPropertiesFromMaDKitXML(String filePath) throws IOException {
        try (InputStream is = MadkitProperties.getInputStream(filePath);){
            NodeList madkitOptionNodes = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is).getDocumentElement().getElementsByTagName("MadkitProperties");
            for (int i = 0; i < madkitOptionNodes.getLength(); ++i) {
                NamedNodeMap options = madkitOptionNodes.item(i).getAttributes();
                for (int j = 0; j < options.getLength(); ++j) {
                    this.put(options.item(j).getNodeName(), options.item(j).getNodeValue());
                }
            }
            logger.fine("** Config file " + filePath + " successfully loaded **\n");
        }
        catch (ParserConfigurationException | SAXException e) {
            logger.log(Level.WARNING, (Object)((Object)ErrorMessages.CANT_LOAD) + "configuration " + filePath, e);
        }
    }

    public void loadPropertiesFromPropertiesFile(String pathname) throws IOException {
        try (InputStream is = MadkitProperties.getInputStream(pathname);){
            this.load(is);
        }
    }

    public void loadPropertiesFromFile(String pathname) throws IOException {
        if (pathname.endsWith(".xml")) {
            this.loadPropertiesFromMaDKitXML(pathname);
        } else {
            this.loadPropertiesFromPropertiesFile(pathname);
        }
    }

    public static InputStream getInputStream(String pathname) throws IOException {
        InputStream is;
        File f = new File(pathname);
        InputStream inputStream = is = f.exists() ? new FileInputStream(f) : MadkitClassLoader.getLoader().getResourceAsStream(pathname);
        if (is == null) {
            throw new FileNotFoundException(pathname);
        }
        return is;
    }
}

