/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import madkit.action.ActionInfo;
import madkit.action.GUIManagerAction;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentLogger;

public class AgentLogLevelMenu
extends JMenu {
    private static final long serialVersionUID = -5402608797586593530L;
    private static final Map<AbstractAgent, AgentLogLevelMenu> menus = new HashMap<AbstractAgent, AgentLogLevelMenu>();
    private static final Level[] logLevels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    private final AbstractAgent myAgent;
    private final ButtonGroup logGroup;
    private final ButtonGroup warningGroup;

    public AgentLogLevelMenu(AbstractAgent agent) {
        super("Logging");
        this.setMnemonic(76);
        this.myAgent = agent;
        ActionInfo action = GUIManagerAction.LOG_LEVEL.getActionInfo();
        JMenu logLevelMenu = new JMenu(action.getName());
        logLevelMenu.setIcon(action.getSmallIcon());
        logLevelMenu.setToolTipText(action.getShortDescription());
        action = GUIManagerAction.WARNING_LOG_LEVEL.getActionInfo();
        JMenu warningLogLevelMenu = new JMenu(action.getName());
        warningLogLevelMenu.setIcon(action.getSmallIcon());
        warningLogLevelMenu.setToolTipText(action.getShortDescription());
        this.logGroup = new ButtonGroup();
        this.warningGroup = new ButtonGroup();
        this.add(logLevelMenu);
        this.add(warningLogLevelMenu);
        ActionListener setLogLevelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgentLogLevelMenu.this.myAgent.setLogLevel(Level.parse(e.getActionCommand()));
            }
        };
        ActionListener setWarningLogLevelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgentLogLevelMenu.this.myAgent.getLogger().setWarningLogLevel(Level.parse(e.getActionCommand()));
            }
        };
        for (Level l : logLevels) {
            JRadioButtonMenuItem logItem = new JRadioButtonMenuItem(l.getLocalizedName());
            JRadioButtonMenuItem warningItem = new JRadioButtonMenuItem(l.getLocalizedName());
            this.initMenuItem(logItem, setLogLevelListener, l.toString(), this.logGroup, logLevelMenu);
            this.initMenuItem(warningItem, setWarningLogLevelListener, l.toString(), this.warningGroup, warningLogLevelMenu);
        }
        this.update();
        if (this.myAgent.hasGUI()) {
            menus.put(this.myAgent, this);
        }
    }

    private void update() {
        AgentLogger logger = this.myAgent.getLogger();
        this.updateButtonGroup(this.logGroup, logger.getLevel());
        this.updateButtonGroup(this.warningGroup, logger.getWarningLogLevel());
    }

    public static void update(AbstractAgent agent) {
        AgentLogLevelMenu menu = menus.get(agent);
        if (menu != null) {
            menu.update();
        }
    }

    private void updateButtonGroup(ButtonGroup group, Level logLevel) {
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.getActionCommand().equals(logLevel.toString())) continue;
            button.setSelected(true);
            return;
        }
    }

    private void initMenuItem(JRadioButtonMenuItem logItem, ActionListener listener, String actionCommand, ButtonGroup group, JMenu menu) {
        menu.add(logItem);
        logItem.setActionCommand(actionCommand);
        logItem.addActionListener(listener);
        group.add(logItem);
    }

    public static void remove(AbstractAgent abstractAgent) {
        menus.remove(abstractAgent);
    }
}

