/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Role;

abstract class Overlooker<A extends AbstractAgent> {
    private Role overlookedRole;
    private final String community;
    private final String group;
    private final String role;

    Overlooker(String communityName, String groupName, String roleName) {
        this.community = communityName;
        this.group = groupName;
        this.role = roleName;
    }

    final void setOverlookedRole(Role theRole) {
        this.overlookedRole = theRole;
        if (theRole != null) {
            try {
                this.initialize();
            }
            catch (Throwable e) {
                System.err.println("\n-----MADKIT WARNING : problem during initialize()-----\n-----Problem on " + this.getClass().getSimpleName() + " on <" + this.community + "," + this.group + "," + this.role + ">-----\n-----Method call is at:");
                e.printStackTrace();
            }
        }
    }

    final Role getOverlookedRole() {
        return this.overlookedRole;
    }

    public String getCommunity() {
        return this.community;
    }

    public String getGroup() {
        return this.group;
    }

    public String getRole() {
        return this.role;
    }

    public void initialize() {
        this.adding((A)this.getCurrentAgentsList());
    }

    protected void adding(List<A> agents) {
        for (AbstractAgent agent : agents) {
            this.adding(agent);
        }
    }

    protected void adding(A agent) {
    }

    protected void removing(List<A> agents) {
        for (AbstractAgent agent : agents) {
            this.removing(agent);
        }
    }

    protected void removing(A agent) {
    }

    public int size() {
        return this.getCurrentAgentsList().size();
    }

    public List<A> getCurrentAgentsList() {
        if (this.overlookedRole != null) {
            return this.overlookedRole.getAgentsList();
        }
        return Collections.emptyList();
    }

    public List<A> getShuffledList() {
        try {
            List<A> l = this.getCurrentAgentsList();
            Collections.shuffle(l);
            return l;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " <" + this.community + "," + this.group + "," + this.role + "> " + this.size() + " agents";
    }

    final void addAgent(AbstractAgent a) {
        this.adding(a);
    }

    final void removeAgent(AbstractAgent a) {
        this.removing(a);
    }

    final void addAgents(List<AbstractAgent> l) {
        this.adding((A)l);
    }

    final void removeAgents(List<AbstractAgent> l) {
        this.removing((A)l);
    }

    public void killAgents() {
        ArrayList<A> l = new ArrayList<A>(this.getCurrentAgentsList());
        this.allAgentsLeaveRole();
        for (AbstractAgent agent : l) {
            agent.killAgent(agent, 0);
        }
    }

    public void allAgentsLeaveRole() {
        if (this.overlookedRole != null) {
            this.overlookedRole.removeMembers(this.getCurrentAgentsList());
        }
    }
}

