/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.awt.Point;
import madkit.bees.AbstractBee;
import madkit.bees.BeeInformation;
import madkit.bees.BeeViewer;
import madkit.kernel.Message;
import madkit.message.ObjectMessage;

public class QueenBee
extends AbstractBee {
    private static final long serialVersionUID = -6999130646300839798L;
    static int border = 20;

    @Override
    protected void buzz() {
        Message message = this.nextMessage();
        if (message != null) {
            this.sendReply(message, new ObjectMessage<BeeInformation>(this.myInformation));
        }
        super.buzz();
        if (this.beeWorld != null) {
            Point point = this.myInformation.getCurrentPosition();
            if (point.x < border || point.x > this.beeWorld.getWidth() - border) {
                this.dX = -this.dX;
                point.x += this.dX;
            }
            if (point.y < border || point.y > this.beeWorld.getHeight() - border) {
                this.dY = -this.dY;
                point.y += this.dY;
            }
            if (this.logger != null) {
                this.logger.fine("my env = " + this.beeWorld);
                this.logger.finest(this.myInformation.getPreviousPosition().toString());
                this.logger.finest(this.myInformation.getCurrentPosition().toString());
            }
        }
    }

    @Override
    protected void activate() {
        this.requestRole("buzz", "bees", "queen", null);
        this.requestRole("buzz", "bees", "bee", null);
        this.broadcastMessage("buzz", "bees", "follower", new ObjectMessage<BeeInformation>(this.myInformation));
        ++BeeViewer.nbOfBroadcast;
        if (this.logger != null) {
            this.logger.info("my initial location" + this.myInformation.getCurrentPosition());
        }
    }

    @Override
    protected void end() {
        ++BeeViewer.nbOfBroadcast;
        this.broadcastMessage("buzz", "bees", "follower", new ObjectMessage<BeeInformation>(this.myInformation));
    }

    @Override
    protected int getMaxVelocity() {
        if (this.beeWorld != null) {
            return this.beeWorld.getQueenVelocity().getValue();
        }
        return 0;
    }

    @Override
    protected void computeNewVelocities() {
        if (this.beeWorld != null) {
            int n = this.beeWorld.getQueenAcceleration().getValue();
            this.dX += this.randomFromRange(n);
            this.dY += this.randomFromRange(n);
        }
    }
}

