/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.FakeKernel;
import madkit.kernel.KernelException;
import madkit.kernel.MadkitKernel;

final class AgentExecutor
extends ThreadPoolExecutor {
    private final Agent myAgent;
    private final FutureTask<AbstractAgent.ReturnCode> activate;
    private final FutureTask<Void> live;
    private final FutureTask<Void> end;

    public AgentExecutor(Agent a) {
        super(1, 1, 0L, TimeUnit.NANOSECONDS, new ArrayBlockingQueue<Runnable>(4, false));
        this.myAgent = a;
        this.activate = new FutureTask<AbstractAgent.ReturnCode>(new Callable<AbstractAgent.ReturnCode>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AbstractAgent.ReturnCode call() {
                ((AgentExecutor)AgentExecutor.this).myAgent.myThread = Thread.currentThread();
                AbstractAgent.ReturnCode r = AgentExecutor.this.myAgent.activation();
                if (r != AbstractAgent.ReturnCode.SUCCESS) {
                    AgentExecutor.this.live.cancel(false);
                    if (AgentExecutor.this.end.isCancelled()) {
                        AtomicReference atomicReference = ((AgentExecutor)AgentExecutor.this).myAgent.state;
                        synchronized (atomicReference) {
                            ((AgentExecutor)AgentExecutor.this).myAgent.state.notify();
                        }
                    }
                }
                return r;
            }
        });
        this.live = new FutureTask<Object>(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AgentExecutor.this.myAgent.getAlive().get()) {
                    AgentExecutor.this.myAgent.living();
                }
                if (AgentExecutor.this.end.isCancelled()) {
                    AtomicReference atomicReference = ((AgentExecutor)AgentExecutor.this).myAgent.state;
                    synchronized (atomicReference) {
                        ((AgentExecutor)AgentExecutor.this).myAgent.state.notify();
                    }
                }
            }
        }, null);
        this.end = new FutureTask<Object>(new Runnable(){

            @Override
            public void run() {
                AgentExecutor.this.myAgent.ending();
            }
        }, null);
    }

    Future<AbstractAgent.ReturnCode> start() {
        this.execute(this.activate);
        this.execute(this.live);
        this.execute(this.end);
        this.execute(new Runnable(){

            @Override
            public void run() {
                AgentExecutor.this.shutdown();
            }
        });
        return this.activate;
    }

    @Override
    protected void terminated() {
        this.myAgent.state.set(AbstractAgent.State.TERMINATED);
        if (!(this.myAgent.getKernel() instanceof FakeKernel)) {
            try {
                MadkitKernel k = this.myAgent.getMadkitKernel();
                this.myAgent.terminate();
                k.removeThreadedAgent(this.myAgent);
            }
            catch (KernelException e) {
                System.err.println(this.myAgent.getKernel());
                e.printStackTrace();
            }
        }
    }

    Future<?> getEndProcess() {
        return this.end;
    }

    Future<?> getLiveProcess() {
        return this.live;
    }

    Future<AbstractAgent.ReturnCode> getActivate() {
        return this.activate;
    }
}

