/*
 * Decompiled with CFR 0.152.
 */
package madkit.marketorg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.gui.OutputPanel;
import madkit.kernel.Agent;
import madkit.kernel.Madkit;
import madkit.kernel.Message;
import madkit.marketorg.Broker;
import madkit.marketorg.Provider;
import madkit.message.StringMessage;

public class Client
extends Agent {
    static int nbOfClientsOnScreen = 0;
    private JPanel blinkPanel;
    private static ImageIcon clientImage = new ImageIcon(new ImageIcon(Client.class.getResource("images/client.png")).getImage().getScaledInstance(70, 70, 4));
    private String product = Provider.availableTransports.get((int)(Math.random() * (double)Provider.availableTransports.size()));

    @Override
    protected void activate() {
        this.createGroupIfAbsent("travel", "travel-clients", true, null);
        this.requestRole("travel", "travel-clients", "client", null);
        int n = 1000 + (int)(Math.random() * 2000.0);
        if (this.logger != null) {
            this.logger.info("I will be looking for a " + this.product + " in " + n + " ms !");
        }
        this.pause(n);
    }

    @Override
    protected void live() {
        boolean bl = false;
        while (!bl) {
            Message message = null;
            while (message == null) {
                message = this.sendMessageWithRoleAndWaitForReply("travel", "travel-clients", "broker", new StringMessage(this.product), "client", 1000);
                if (this.logger != null && message == null) {
                    this.logger.info("For now there is nothing for me :(");
                }
                this.pause(500);
            }
            this.logFindBroker(message);
            bl = this.buyTicket((StringMessage)message);
        }
    }

    @Override
    protected void end() {
        if (this.logger != null) {
            this.logger.info("I will quit soon now, buit I will launch another one like me !");
        }
        this.pause((int)(Math.random() * 2000.0 + 500.0));
        this.launchAgent(new Client(), 4, true);
    }

    private void logFindBroker(Message message) {
        if (this.logger != null) {
            this.logger.info("I found a broker : " + message.getSender());
        }
        if (this.blinkPanel != null) {
            this.blinkPanel.setBackground(Color.YELLOW);
            this.pause(1000);
        }
    }

    private boolean buyTicket(StringMessage stringMessage) {
        String string = (String)stringMessage.getContent();
        this.requestRole("travel", string, "client");
        Message message = this.sendMessageAndWaitForReply("travel", string, "provider", new StringMessage("money"), 4000);
        if (message != null) {
            if (this.logger != null) {
                this.logger.info("Yeeeaah: I have my ticket :) ");
            }
            if (this.hasGUI()) {
                this.blinkPanel.setBackground(Color.GREEN);
            }
            this.leaveGroup("travel", "travel-clients");
            this.pause((int)(1000.0 + Math.random() * 2000.0));
            return true;
        }
        return false;
    }

    @Override
    public void setupFrame(JFrame jFrame) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new OutputPanel(this), "Center");
        this.blinkPanel = new JPanel();
        this.blinkPanel.add(new JLabel(clientImage));
        this.blinkPanel.add(new JLabel(new ImageIcon(this.getClass().getResource("images/" + this.product + ".png"))));
        jPanel.add((Component)this.blinkPanel, "North");
        jPanel.validate();
        jFrame.add(jPanel);
        int n = nbOfClientsOnScreen++ * 390;
        if ((double)(n + 390) > Toolkit.getDefaultToolkit().getScreenSize().getWidth()) {
            nbOfClientsOnScreen = 0;
        }
        jFrame.setLocation(n, 0);
        jFrame.setSize(390, 300);
    }

    public static void main(String[] stringArray) {
        nbOfClientsOnScreen = 0;
        Broker.nbOfBrokersOnScreen = 0;
        new Madkit(Madkit.Option.launchAgents.toString(), Broker.class.getName() + ",true,3;" + Client.class.getName() + ",true,2;" + Provider.class.getName() + ",true,7");
    }
}

