/*
 * Decompiled with CFR 0.152.
 */
package madkit.marketorg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.action.AgentAction;
import madkit.gui.OutputPanel;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.message.IntegerMessage;
import madkit.message.ObjectMessage;
import madkit.message.StringMessage;

public class Broker
extends Agent {
    private static final long serialVersionUID = 1217908977100108396L;
    static int nbOfBrokersOnScreen = 0;
    private static ImageIcon brokerImage = new ImageIcon(new ImageIcon(Broker.class.getResource("images/broker.png")).getImage().getScaledInstance(70, 70, 4));
    private JPanel blinkPanel;

    @Override
    protected void activate() {
        this.createGroupIfAbsent("travel", "travel-clients", true, null);
        this.createGroupIfAbsent("travel", "travel-providers", true, null);
        this.requestRole("travel", "travel-clients", "broker", null);
        this.requestRole("travel", "travel-providers", "broker", null);
    }

    @Override
    protected void live() {
        while (true) {
            String string;
            Message message;
            if ((message = this.purgeMailbox()) == null) {
                message = this.waitNextMessage();
            }
            if (!(string = message.getSender().getRole()).equals("client")) continue;
            this.handleClientRequest((StringMessage)message);
        }
    }

    @Override
    protected void end() {
        AgentAction.RELOAD.getActionFor(this, new Object[0]).actionPerformed(null);
    }

    private void handleClientRequest(StringMessage stringMessage) {
        List<Message> list;
        if (!this.checkAgentAddress(stringMessage.getSender())) {
            return;
        }
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.YELLOW);
        }
        if (this.logger != null) {
            this.logger.info("I received a request for a " + (String)stringMessage.getContent() + " \nfrom " + stringMessage.getSender());
        }
        if ((list = this.broadcastMessageWithRoleAndWaitForReplies("travel", "travel-providers", (String)stringMessage.getContent() + "-" + "provider", new StringMessage("make-bid-please"), "broker", 900)) == null) {
            if (this.logger != null) {
                this.logger.info("No bids at all : No one is selling " + ((String)stringMessage.getContent()).toUpperCase() + " !!\nPlease launch other providers !a");
            }
            if (this.hasGUI()) {
                this.blinkPanel.setBackground(Color.LIGHT_GRAY);
            }
            return;
        }
        List<IntegerMessage> list2 = Arrays.asList(list.toArray(new IntegerMessage[0]));
        IntegerMessage integerMessage = ObjectMessage.min(list2);
        if (this.logger != null) {
            this.logger.info("The best offer is from " + integerMessage.getSender() + " " + integerMessage.getContent());
        }
        String string = "" + System.nanoTime();
        Message message = this.sendMessageWithRoleAndWaitForReply(integerMessage.getSender(), new StringMessage(string), "broker", 1000);
        if (message != null) {
            if (this.logger != null) {
                this.logger.info("Provider is ready !\nSending the contract number to client");
            }
            this.sendReply(stringMessage, new StringMessage(string));
            this.pause((int)(Math.random() * 2000.0 + 1000.0));
        } else if (this.logger != null) {
            this.logger.info("Provider disappears !!!!");
        }
        if (this.hasGUI()) {
            this.blinkPanel.setBackground(Color.LIGHT_GRAY);
        }
    }

    @Override
    public void setupFrame(JFrame jFrame) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new OutputPanel(this), "Center");
        this.blinkPanel = new JPanel();
        this.blinkPanel.add(new JLabel(brokerImage));
        jPanel.add((Component)this.blinkPanel, "North");
        this.blinkPanel.setBackground(Color.LIGHT_GRAY);
        jPanel.validate();
        jFrame.add(jPanel);
        int n = nbOfBrokersOnScreen++ * 390;
        if ((double)(n + 390) > Toolkit.getDefaultToolkit().getScreenSize().getWidth()) {
            nbOfBrokersOnScreen = 0;
        }
        jFrame.setLocation(n, 320);
        jFrame.setSize(390, 300);
    }
}

