/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import madkit.action.KernelAction;
import madkit.action.SchedulingAction;
import madkit.bees.AbstractBee;
import madkit.bees.BeeEnvironment;
import madkit.bees.BeeInformation;
import madkit.bees.BeeLauncher;
import madkit.bees.BeeScheduler;
import madkit.gui.SwingUtil;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.gui.menu.AgentMenu;
import madkit.gui.menu.LaunchAgentsMenu;
import madkit.gui.menu.MadkitMenu;
import madkit.message.EnumMessage;
import madkit.message.KernelMessage;
import madkit.message.ObjectMessage;
import madkit.message.SchedulingMessage;
import madkit.simulation.probe.PropertyProbe;
import madkit.simulation.viewer.SwingViewer;

public class BeeViewer
extends SwingViewer {
    private BeeEnvironment environment;
    private JPanel display;
    private AbstractAction synchroPaint;
    private AbstractAction artMode;
    private AbstractAction randomMode;
    private AbstractAction launch;
    private AbstractAction trailModeAction;
    private AbstractAction multicoreMode;
    private PropertyProbe<AbstractBee, BeeInformation> beeProbe;
    private BeeScheduler sch;
    private String community;
    protected int nbOfBeesToLaunch = 30000;
    public static int nbOfBroadcast = 0;

    public BeeViewer(BeeScheduler beeScheduler, String string) {
        this.community = string;
        this.sch = beeScheduler;
        this.setLogLevel(Level.OFF);
        this.environment = new BeeEnvironment(new Dimension(1600, 1024));
    }

    @Override
    protected void activate() {
        this.requestRole(this.community, "bees", "bee observer");
        this.beeProbe = new PropertyProbe<AbstractBee, BeeInformation>(this.community, "bees", "bee", "myInformation"){

            @Override
            public void adding(AbstractBee abstractBee) {
                super.adding(abstractBee);
                abstractBee.setEnvironment(BeeViewer.this.environment);
            }
        };
        if (this.logger != null) {
            this.logger.info("ENV is " + this.environment);
        }
        this.addProbe(this.beeProbe);
    }

    @Override
    protected void end() {
        this.removeProbe(this.beeProbe);
        this.sendMessage(this.community, "bees", "launcher", new KernelMessage(KernelAction.EXIT, new Object[0]));
        this.sendMessage(this.community, "bees", "scheduler", new SchedulingMessage(SchedulingAction.SHUTDOWN, new Object[0]));
        this.leaveRole(this.community, "bees", "viewer");
    }

    @Override
    protected void render(Graphics graphics) {
        if (graphics != null) {
            this.computeFromInfoProbe(graphics);
        }
    }

    private void computeFromInfoProbe(Graphics graphics) {
        graphics.drawString("You are watching " + this.beeProbe.size() + " MaDKit agents", 10, 10);
        Color color = null;
        boolean bl = (Boolean)this.trailModeAction.getValue("SwingSelectedKey");
        for (AbstractBee abstractBee : this.beeProbe.getCurrentAgentsList()) {
            BeeInformation beeInformation = this.beeProbe.getPropertyValue(abstractBee);
            Color color2 = beeInformation.getBeeColor();
            if (color2 != color) {
                color = color2;
                graphics.setColor(color);
            }
            Point point = beeInformation.getCurrentPosition();
            if (bl) {
                Point point2 = beeInformation.getPreviousPosition();
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                continue;
            }
            graphics.drawLine(point.x, point.y, point.x, point.y);
        }
    }

    @Override
    public void setupFrame(JFrame jFrame) {
        JComponent jComponent;
        JComponent jComponent2;
        super.setupFrame(jFrame);
        this.buildActions(jFrame);
        jFrame.setBackground(Color.black);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(new MadkitMenu(this));
        jMenuBar.add(new AgentMenu(this));
        jMenuBar.add(new LaunchAgentsMenu(this));
        jMenuBar.add(new AgentLogLevelMenu(this));
        jMenuBar.add(this.sch.getSchedulerMenu());
        JMenu jMenu = new JMenu("Options");
        jMenu.add(new JCheckBoxMenuItem(this.synchroPaint));
        jMenu.add(new JCheckBoxMenuItem(this.artMode));
        jMenu.add(new JCheckBoxMenuItem(this.randomMode));
        jMenu.add(new JCheckBoxMenuItem(this.trailModeAction));
        jMenu.add(this.launch);
        jMenuBar.add(jMenu);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeeViewer.this.sendLaunchMessage(Integer.parseInt(actionEvent.getActionCommand()));
            }
        };
        JMenu jMenu2 = new JMenu("Number of bees to launch when clicking the icon");
        JMenu jMenu3 = new JMenu("Launching");
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 10000;
        for (int i = 1000; i <= 1000000; i *= 10) {
            jComponent2 = new JRadioButtonMenuItem("Launch " + i + " bees at a time");
            ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BeeViewer.this.nbOfBeesToLaunch = Integer.parseInt(actionEvent.getActionCommand());
                }
            });
            jComponent = new JMenuItem("Launch " + i + " bees");
            ((AbstractButton)jComponent).addActionListener(actionListener);
            ((AbstractButton)jComponent).setActionCommand("" + i);
            jMenu3.add((JMenuItem)jComponent);
            ((AbstractButton)jComponent2).setActionCommand("" + i);
            if (i == n) {
                ((AbstractButton)jComponent2).setSelected(true);
            }
            buttonGroup.add((AbstractButton)jComponent2);
            jMenu2.add((JMenuItem)jComponent2);
        }
        jMenu.add(jMenu2);
        jMenuBar.add(jMenu3);
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.display = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                if (!((Boolean)BeeViewer.this.artMode.getValue("SwingSelectedKey")).booleanValue()) {
                    super.paintComponent(graphics);
                }
                BeeViewer.this.render(graphics);
            }
        };
        this.setDisplayPane(this.display);
        this.display.setBackground(Color.BLACK);
        this.display.setForeground(Color.white);
        jFrame.add(this.display);
        this.display.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                BeeViewer.this.environment.setEnvSize(componentEvent.getComponent().getSize());
                if (BeeViewer.this.beeProbe != null) {
                    BeeViewer.this.beeProbe.initialize();
                }
            }
        });
        JToolBar jToolBar = new JToolBar();
        this.addButtonToToolbar(jToolBar, this.randomMode);
        this.addButtonToToolbar(jToolBar, this.artMode);
        this.addButtonToToolbar(jToolBar, this.trailModeAction);
        this.addButtonToToolbar(jToolBar, this.synchroPaint);
        this.addButtonToToolbar(jToolBar, this.launch);
        this.addButtonToToolbar(jToolBar, this.multicoreMode);
        jComponent2 = new JPanel(new FlowLayout(0));
        jComponent2.add(jToolBar);
        jComponent2.add(this.sch.getSchedulerToolBar());
        jComponent = new JToolBar();
        jComponent.add(SwingUtil.createSliderPanel(this.environment.getQueenAcceleration(), "queen acceleration"));
        jComponent.add(SwingUtil.createSliderPanel(this.environment.getQueenVelocity(), "queen velocity"));
        jComponent.add(SwingUtil.createSliderPanel(this.environment.getBeeAcceleration(), "bee acceleration"));
        jComponent.add(SwingUtil.createSliderPanel(this.environment.getBeeVelocity(), "bee velocity"));
        jComponent2.add(jComponent);
        jFrame.add((Component)this.sch.getSchedulerStatusLabel(), "South");
        this.display.getParent().add((Component)jComponent2, "First");
        jFrame.setLocationRelativeTo(null);
        jFrame.setExtendedState(6);
    }

    private void addButtonToToolbar(JToolBar jToolBar, Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        jToggleButton.setText(null);
        jToolBar.add(jToggleButton);
    }

    void buildActions(JFrame jFrame) {
        this.synchroPaint = new AbstractAction("Synchronous painting"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeeViewer.this.setSynchronousPainting((Boolean)BeeViewer.this.synchroPaint.getValue("SwingSelectedKey") == false);
            }
        };
        this.initActionIcon(this.synchroPaint, "Deactivate the synchronous painting mode (faster)", "synchroPaint");
        this.synchroPaint.putValue("SwingSelectedKey", false);
        this.artMode = new AbstractAction("Art mode"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.initActionIcon(this.artMode, "A funny painting mode", "artMode");
        this.randomMode = new AbstractAction("Random mode"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeeViewer.this.sendMessage(BeeViewer.this.community, "bees", "launcher", new EnumMessage<BeeLauncher.BeeLauncherAction>(BeeLauncher.BeeLauncherAction.RANDOM_MODE, BeeViewer.this.randomMode.getValue("SwingSelectedKey")));
            }
        };
        this.initActionIcon(this.randomMode, "Random mode: Randomly launch or kill bees", "random");
        this.randomMode.putValue("SwingSelectedKey", true);
        this.multicoreMode = new AbstractAction("Multicore mode"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeeViewer.this.sendMessage(BeeViewer.this.community, "bees", "scheduler", new ObjectMessage<Boolean>((Boolean)BeeViewer.this.multicoreMode.getValue("SwingSelectedKey")));
            }
        };
        this.initActionIcon(this.multicoreMode, "Multicore mode: Use several processor cores if available (more efficient if synchro painting is off", "multicore");
        this.trailModeAction = new AbstractAction("Trail mode"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.initActionIcon(this.trailModeAction, "Trails mode: display agents with trails or like point particles", "trail");
        this.trailModeAction.putValue("SwingSelectedKey", true);
        this.launch = new AbstractAction("Launch bees"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeeViewer.this.sendLaunchMessage(BeeViewer.this.nbOfBeesToLaunch);
            }
        };
        this.initActionIcon(this.launch, "Launch some bees", "launch");
    }

    private void initActionIcon(AbstractAction abstractAction, String string, String string2) {
        abstractAction.putValue("SwingSelectedKey", false);
        abstractAction.putValue("ActionCommandKey", string2);
        abstractAction.putValue("ShortDescription", string);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("images/bees_" + string2 + ".png"));
        abstractAction.putValue("SwingLargeIconKey", imageIcon);
        abstractAction.putValue("SmallIcon", new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4)));
    }

    private void sendLaunchMessage(int n) {
        this.sendMessage(this.community, "bees", "launcher", new EnumMessage<BeeLauncher.BeeLauncherAction>(BeeLauncher.BeeLauncherAction.LAUNCH_BEES, n));
    }
}

